/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import oracle.ide.config.ChangeEventSource;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class HistoryOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY = "HistoryOptions";
    public static final int MAX_LIFESPAN = 365;
    public static final int MAX_REVISIONS = 999;
    private static final String ENABLED = "enabled";
    private static final String LIFESPAN = "lifespan";
    private static final String REVISIONS = "revisions";

    public HistoryOptions() {
        this(HashStructure.newInstance());
    }

    private HistoryOptions(HashStructure hash) {
        super(hash);
    }

    public static HistoryOptions getInstance(PropertyStorage prefs) {
        return new HistoryOptions(HistoryOptions.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public boolean isEnabled() {
        return this._hash.getBoolean(ENABLED, true);
    }

    public void setEnabled(boolean enabled) {
        this._hash.putBoolean(ENABLED, enabled);
    }

    public static String getEnabledLabel() {
        return IdeImplArb.getString(28);
    }

    public int getLifespan() {
        return this._hash.getInt(LIFESPAN, 7);
    }

    public void setLifespan(int lifespan) {
        if (lifespan >= 0) {
            this._hash.putInt(LIFESPAN, lifespan);
        }
    }

    public int getRevisions() {
        return this._hash.getInt(REVISIONS, 50);
    }

    public void setRevisions(int revisions) {
        if (revisions > 0) {
            this._hash.putInt(REVISIONS, revisions);
        }
    }
}

