/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.ide.config.IdeSettings;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.history.HistoryOptions;
import oracle.ideimpl.resource.IdeImplArb;

public class HistoryOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox enabledCheckBox;
    private GridBagLayout gridBagLayout1;
    private JLabel lifespanLabel;
    private JSpinner lifespanSpinner;
    private JLabel lifespanHint;
    private JLabel revisionsLabel;
    private JSpinner revisionsSpinner;
    private JLabel revisionsHint;

    private void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.lifespanLabel = new JLabel();
        this.lifespanSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 365, 1));
        this.lifespanHint = new JLabel();
        this.revisionsLabel = new JLabel();
        this.revisionsSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this.revisionsHint = new JLabel();
    }

    public HistoryOptionsPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem hs = HelpSystem.getHelpSystem();
            if (hs != null) {
                hs.registerTopic((JComponent)((Object)this), "f1_idedidesetlocalhistory_html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.enabledCheckBox = new JCheckBox();
        this.setLayout(this.gridBagLayout1);
        this.enabledCheckBox.addItemListener(new 1());
        this.lifespanHint.setText(EnvironOptionsArb.getString((int)9));
        this.lifespanHint.setHorizontalAlignment(2);
        this.revisionsHint.setText(EnvironOptionsArb.getString((int)9));
        this.revisionsHint.setHorizontalAlignment(2);
        ResourceUtils.resButton((AbstractButton)this.enabledCheckBox, (String)HistoryOptions.getEnabledLabel());
        ResourceUtils.resSpinner((JLabel)this.lifespanLabel, (JSpinner)this.lifespanSpinner, (String)IdeImplArb.getString(15));
        ResourceUtils.resSpinner((JLabel)this.revisionsLabel, (JSpinner)this.revisionsSpinner, (String)IdeImplArb.getString(74));
        this.add(this.enabledCheckBox, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.lifespanLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add(this.lifespanSpinner, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.lifespanHint, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.revisionsLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add(this.revisionsSpinner, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.revisionsHint, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        HistoryOptions options = HistoryOptions.getInstance(tc.getPropertyStorage());
        this.enabledCheckBox.setSelected(options.isEnabled());
        this.lifespanSpinner.setValue(options.getLifespan());
        this.revisionsSpinner.setValue(options.getRevisions());
        this.updateEnabled(null);
    }

    public void onExit(TraversableContext tc) {
        HistoryOptions options = HistoryOptions.getInstance(tc.getPropertyStorage());
        int lifespan = (Integer)this.lifespanSpinner.getValue();
        int revisions = (Integer)this.revisionsSpinner.getValue();
        boolean restart = lifespan != options.getLifespan() || revisions != options.getRevisions();
        options.setEnabled(this.enabledCheckBox.isSelected());
        options.setLifespan(lifespan);
        options.setRevisions(revisions);
        if (restart) {
            IdeSettings settings = (IdeSettings)tc.find("ide-options");
            settings.setAskExit(true);
        }
    }

    private void updateEnabled(ItemEvent e) {
        this.lifespanSpinner.setEnabled(this.enabledCheckBox.isSelected());
        this.revisionsSpinner.setEnabled(this.enabledCheckBox.isSelected());
    }

    static void mav$updateEnabled(HistoryOptionsPanel historyOptionsPanel, ItemEvent itemEvent) {
        historyOptionsPanel.updateEnabled(itemEvent);
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            HistoryOptionsPanel.mav$updateEnabled(HistoryOptionsPanel.this, e);
        }
    }
}

