/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.net.URL;
import java.util.Date;
import oracle.ide.history.LocalState;
import oracle.ideimpl.history.HistoryManagerImpl;

final class LocalStateImpl
extends LocalState {
    public static final String FIELD_SEPARATOR = "|";
    private Date date;
    private Integer nodeId;
    private Integer nodeUrlId;
    private Integer dataUrlId;

    LocalStateImpl(Date date, Integer nodeId, Integer nodeUrlId, Integer dataUrlId) {
        this.date = date;
        this.nodeId = nodeId;
        this.nodeUrlId = nodeUrlId;
        this.dataUrlId = dataUrlId;
    }

    public Date getDate() {
        return this.date;
    }

    public URL getNodeURL() {
        return HistoryManagerImpl.getCurrentUrl(this.nodeId);
    }

    public URL getStateURL() {
        return HistoryManagerImpl.getUrl(this.nodeUrlId);
    }

    public URL getDataURL() {
        return HistoryManagerImpl.getUrl(this.dataUrlId);
    }

    public String getDescription() {
        return HistoryManagerImpl.getDescription(this);
    }

    public Object getNodeId() {
        return this.nodeId;
    }

    Object getStateUrlId() {
        return this.nodeUrlId;
    }

    Object getDataUrlId() {
        return this.dataUrlId;
    }

    public static LocalStateImpl decode(String data) throws NumberFormatException {
        String[] tokens = new String[4];
        int cnt = 0;
        int start = 0;
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            if (c == '|') {
                tokens[cnt] = data.substring(start, i);
                start = i + 1;
                if (++cnt == 4) break;
            }
            ++i;
        }
        if (cnt == 3) {
            tokens[3] = data.substring(start);
            ++cnt;
        }
        if (cnt < 4) {
            throw new IllegalArgumentException(data);
        }
        Integer nodeId = Integer.valueOf(tokens[0]);
        Date date = new Date(Long.valueOf(tokens[1]));
        Integer nodeUrlId = Integer.valueOf(tokens[2]);
        Integer dataUrlId = Integer.valueOf(tokens[3]);
        return new LocalStateImpl(date, nodeId, nodeUrlId, dataUrlId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.nodeId);
        buffer.append(FIELD_SEPARATOR);
        buffer.append(this.date.getTime());
        buffer.append(FIELD_SEPARATOR);
        buffer.append(this.nodeUrlId);
        buffer.append(FIELD_SEPARATOR);
        buffer.append(this.dataUrlId);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalStateImpl) {
            LocalStateImpl other = (LocalStateImpl)((Object)obj);
            return other.date.equals(this.date) && other.nodeId.equals(this.nodeId) && other.nodeUrlId.equals(this.nodeUrlId) && other.dataUrlId.equals(this.dataUrlId);
        }
        return false;
    }

    public static void main(String[] args) {
        String[] s;
        String[] stringArray = s = "foo|bar".split("\\|");
        int n = 0;
        while (n < stringArray.length) {
            String i = stringArray[n];
            System.out.println(i);
            ++n;
        }
    }
}

