/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;
import javax.ide.util.MissingIconException;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.IdeIcons;
import oracle.ideimpl.jsr198.JSR198Action;
import oracle.ideimpl.jsr198.JavaxIdeController;
import oracle.ideimpl.jsr198.WrappedOracleAction;

public final class OracleActionRegistry
extends ActionRegistry {
    private static final Map TL_MENU_ID_MAP = new HashMap();
    private static final Map STANDARD_SECTIONS = new HashMap();
    private static final Map STANDARD_ITEMS = new HashMap();
    private static Map ACTION_ALIAS_MAP = null;

    static {
        TL_MENU_ID_MAP.put("javax.ide.FILE_MENU_ID", "File");
        TL_MENU_ID_MAP.put("javax.ide.EDIT_MENU_ID", "Edit");
        TL_MENU_ID_MAP.put("javax.ide.VIEW_MENU_ID", "View");
        TL_MENU_ID_MAP.put("javax.ide.HELP_MENU_ID", "Help");
        STANDARD_SECTIONS.put("javax.ide.OPEN_SECTION_ID", new Float(1.0f));
        STANDARD_SECTIONS.put("javax.ide.NEW_SECTION_ID", new Float(1.0f));
        STANDARD_SECTIONS.put("javax.ide.PRINT_SECTION_ID", new Float(MenuConstants.SECTION_FILE_PRINT));
        STANDARD_SECTIONS.put("javax.ide.SAVE_SECTION_ID", new Float(MenuConstants.SECTION_FILE_SAVE));
        STANDARD_SECTIONS.put("javax.ide.COPY_PASTE_SECTION_ID", new Float(MenuConstants.SECTION_EDIT_CUT_COPY_PASTE));
        STANDARD_ITEMS.put("javax.ide.OPEN_ACTION_ID", new Float(MenuConstants.WEIGHT_FILE_OPEN));
        STANDARD_ITEMS.put("javax.ide.CUT_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_CUT));
        STANDARD_ITEMS.put("javax.ide.COPY_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_COPY));
        STANDARD_ITEMS.put("javax.ide.PASTE_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_PASTE));
    }

    protected void initialize() {
        this.registerActions();
        if (Ide.getMainWindow().isVisible()) {
            this.postMainWindowInit();
        } else {
            Ide.addIdeListener((IdeListener)new 1());
        }
    }

    private void postMainWindowInit() {
        this.registerTopLevelMenus();
        this.registerControllerChains();
        this.registerContextMenus();
    }

    private ExtensionRegistry getExtensionRegistry() {
        return ExtensionRegistry.getOracleRegistry();
    }

    private void registerContextMenus() {
        NavigatorManager m = NavigatorManager.getWorkspaceNavigatorManager();
        if (m != null) {
            m.getContextMenu().addContextMenuListener((ContextMenuListener)new MyContextMenuListener("javax.ide.view.PROJECT_EXPLORER_POPUP_ID"));
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)new MyContextMenuListener("javax.ide.view.EDITOR_POPUP_ID"));
    }

    private void registerControllerChains() {
        if (ACTION_ALIAS_MAP == null) {
            ACTION_ALIAS_MAP = new HashMap();
            ACTION_ALIAS_MAP.put("javax.ide.OPEN_ACTION_ID", Ide.findCmdName((int)9));
            ACTION_ALIAS_MAP.put("javax.ide.CUT_ACTION_ID", Ide.findCmdName((int)17));
            ACTION_ALIAS_MAP.put("javax.ide.COPY_ACTION_ID", Ide.findCmdName((int)18));
            ACTION_ALIAS_MAP.put("javax.ide.PASTE_ACTION_ID", Ide.findCmdName((int)19));
        }
        Map jsr198Actions = this.getModel().getActions();
        Set actionsWithControllers = this.getModel().getActionsWithControllers();
        for (String actionId : actionsWithControllers) {
            Integer oideActionId;
            List javaxIdeControllers = this.getModel().getControllers(actionId);
            if (jsr198Actions.get(actionId) != null) continue;
            String alias = (String)ACTION_ALIAS_MAP.get(actionId);
            if (alias != null) {
                actionId = alias;
            }
            if ((oideActionId = Ide.findCmdID((String)actionId)) == null) continue;
            IdeAction oideAction = IdeAction.find((int)oideActionId);
            for (javax.ide.command.Controller javaxIdeController : javaxIdeControllers) {
                oideAction.addController((Controller)new 2(this, javaxIdeController, oideAction));
            }
        }
    }

    private void registerTopLevelMenus() {
        MenuModel model = this.getModel();
        Map pullDownMenus = model.getMenuBars();
        MenuBar mainWindowMenu = (MenuBar)pullDownMenus.get("javax.ide.view.MAIN_WINDOW_MENUBAR_ID");
        if (mainWindowMenu != null) {
            float weight = 0.0f;
            List menus = mainWindowMenu.getMenus();
            Iterator i = menus.iterator();
            while (i.hasNext()) {
                weight += 0.001f;
                Menu menu = (Menu)i.next();
                JMenu physicalMenu = this.getPhysicalMenu(menu);
                if (physicalMenu != null) {
                    Float w = (Float)physicalMenu.getClientProperty("menu-weight");
                    if (w == null) {
                        this.getExtensionRegistry().getLogger().warning("Found menu " + menu.getID() + " with no weight. Order may be wrong.");
                    } else {
                        weight = w.floatValue();
                    }
                } else {
                    physicalMenu = Ide.getMenubar().createMenu(menu.getLabel(), new Integer(menu.getMnemonic()), weight);
                    Ide.getMenubar().add((Component)physicalMenu);
                    MenuManager.putJMenu((String)menu.getID(), (JMenu)physicalMenu);
                }
                this.addToMenu(new JMenuWrapper(physicalMenu), (SectionContainer)menu);
            }
        }
    }

    private void addToMenu(PhysicalMenuWrapper physicalMenu, SectionContainer modelMenu) {
        Menubar omenumgr = Ide.getMenubar();
        float sectionId = Float.MAX_VALUE;
        for (Section section : modelMenu.getSections()) {
            float weight = 1000.0f;
            Float standardSection = (Float)STANDARD_SECTIONS.get(section.getID());
            if (standardSection != null) {
                sectionId = standardSection.floatValue();
                if ("javax.ide.NEW_SECTION_ID".equals(section.getID())) {
                    weight = MenuConstants.WEIGHT_FILE_OPEN - 0.05f;
                }
            }
            for (Object item : section.getContent()) {
                if (item instanceof Item) {
                    String actionId = ((Item)item).getActionID();
                    Float standardWeight = (Float)STANDARD_ITEMS.get(actionId);
                    if (standardWeight != null) {
                        weight = standardWeight.floatValue();
                        continue;
                    }
                    Integer cmdId = Ide.findCmdID((String)actionId);
                    if (cmdId == null) {
                        this.getExtensionRegistry().getLogger().warning("Action id " + actionId + " not found in menu " + modelMenu.getID());
                        continue;
                    }
                    IdeAction theAction = IdeAction.find((int)cmdId);
                    physicalMenu.add(omenumgr.createMenuItem((ToggleAction)theAction, weight), sectionId);
                    continue;
                }
                if (!(item instanceof Menu)) continue;
                Menu submenu = (Menu)item;
                JMenu menu = omenumgr.createSubMenu(submenu.getLabel(), new Integer(submenu.getMnemonic()), weight);
                if (submenu.getIcon() != null) {
                    try {
                        URL url = submenu.getIcon().getURL();
                        ImageIcon icon = new ImageIcon(url);
                        menu.setIcon(icon);
                    }
                    catch (MissingIconException mie) {
                        this.getExtensionRegistry().getLogger().warning(mie.getMessage());
                    }
                } else {
                    menu.setIcon(IdeIcons.getIcon((int)23));
                }
                physicalMenu.add(menu, sectionId);
                this.addToMenu(new JMenuWrapper(menu), (SectionContainer)submenu);
            }
            sectionId += 1.0f;
        }
    }

    private JMenu getPhysicalMenu(Menu menu) {
        String jsr198ID = menu.getID();
        String jdevID = (String)TL_MENU_ID_MAP.get(jsr198ID);
        if (jdevID == null) {
            jdevID = jsr198ID;
        }
        return MenuManager.getJMenu((String)jdevID);
    }

    private void registerActions() {
        Map actionMap = this.getModel().getActions();
        for (String id : actionMap.keySet()) {
            Integer cmd = Ide.findCmdID((String)id);
            if (cmd != null) {
                this.getExtensionRegistry().getLogger().warning("Action with id '" + id + "' is defined both in an extension manifest and " + "programmatically. The programmatic definition wins.");
                return;
            }
            int cmdId = Ide.findOrCreateCmdID((String)id);
            JSR198Action theAction = new JSR198Action((IDEAction)actionMap.get(id));
            Ide.getIdeActionMap().put(new Integer(cmdId), (Action)((Object)theAction));
        }
    }

    static MenuModel mav$getModel(OracleActionRegistry oracleActionRegistry) {
        return oracleActionRegistry.getModel();
    }

    static void mav$addToMenu(OracleActionRegistry oracleActionRegistry, PhysicalMenuWrapper physicalMenuWrapper, SectionContainer sectionContainer) {
        oracleActionRegistry.addToMenu(physicalMenuWrapper, sectionContainer);
    }

    static void mav$postMainWindowInit(OracleActionRegistry oracleActionRegistry) {
        oracleActionRegistry.postMainWindowInit();
    }

    final class 1
    implements IdeListener {
        public void addinsLoaded(IdeEvent e) {
        }

        public void mainWindowOpened(IdeEvent e) {
            Ide.removeIdeListener((IdeListener)this);
            OracleActionRegistry.mav$postMainWindowInit(OracleActionRegistry.this);
        }

        public void mainWindowClosing(IdeEvent e) {
        }
    }

    private class MyContextMenuListener
    implements ContextMenuListener {
        private final String _popupId;

        public MyContextMenuListener(String popupId) {
            this._popupId = popupId;
        }

        public void menuWillShow(ContextMenu popup) {
            MenuModel model = OracleActionRegistry.mav$getModel(OracleActionRegistry.this);
            PopupMenu javaxPopup = (PopupMenu)model.getPopupMenus().get(this._popupId);
            if (javaxPopup != null) {
                OracleActionRegistry.mav$addToMenu(OracleActionRegistry.this, new ContextMenuWrapper(popup), (SectionContainer)javaxPopup);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    final class 2
    extends JavaxIdeController {
        private final /* synthetic */ IdeAction v$oideAction;
        final /* synthetic */ OracleActionRegistry this$0;

        protected IDEAction getJavaxIdeAction() {
            return new WrappedOracleAction(this.v$oideAction.getCommandId());
        }

        public 2(OracleActionRegistry oracleActionRegistry, javax.ide.command.Controller controller, IdeAction ideAction) {
            this.v$oideAction = ideAction;
            this.this$0 = oracleActionRegistry;
            super(controller);
        }
    }

    private interface PhysicalMenuWrapper {
        public void add(Component var1, float var2);
    }

    private class JMenuWrapper
    implements PhysicalMenuWrapper {
        private final JMenu _menu;

        JMenuWrapper(JMenu menu) {
            this._menu = menu;
        }

        public void add(Component item, float sectionId) {
            Ide.getMenubar().add(item, this._menu, sectionId);
        }
    }

    private class ContextMenuWrapper
    implements PhysicalMenuWrapper {
        private final ContextMenu _contextMenu;

        ContextMenuWrapper(ContextMenu contextMenu) {
            this._contextMenu = contextMenu;
        }

        public void add(Component item, float sectionId) {
            this._contextMenu.add(item, sectionId);
        }
    }
}

