/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystemHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.jsr198.TheVirtualFileSystem;

final class VirtualFileSystemHelperImpl
extends VirtualFileSystemHelper {
    public URI canonicalize(URI uri) throws IOException {
        URL url = URLFileSystem.canonicalize((URL)this.toURL(uri));
        return URIFactory.newURI((URL)url);
    }

    public boolean canRead(URI uri) {
        return URLFileSystem.canRead((URL)this.toURL(uri));
    }

    public boolean canWrite(URI uri) {
        return URLFileSystem.canWrite((URL)this.toURL(uri));
    }

    public boolean canCreate(URI uri) {
        return URLFileSystem.canCreate((URL)this.toURL(uri));
    }

    public boolean delete(URI uri) {
        return URLFileSystem.delete((URL)this.toURL(uri));
    }

    public boolean equals(URI uri1, URI uri2) {
        return URLFileSystem.equals((URL)this.toURL(uri1), (URL)this.toURL(uri2));
    }

    public boolean exists(URI uri) {
        URL url = this.toURL(uri);
        return URLFileSystem.exists((URL)url);
    }

    public long getLength(URI uri) {
        return URLFileSystem.getLength((URL)this.toURL(uri));
    }

    public URI getParent(URI uri) {
        URL parentURL = URLFileSystem.getParent((URL)this.toURL(uri));
        return URIFactory.newURI((URL)parentURL);
    }

    public String getPlatformPathName(URI uri) {
        return URLFileSystem.getPlatformPathName((URL)this.toURL(uri));
    }

    public boolean hasSuffix(URI uri, String suffix) {
        return URLFileSystem.hasSuffix((URL)this.toURL(uri), (String)suffix);
    }

    public boolean isDirectory(URI uri) {
        return URLFileSystem.isDirectory((URL)this.toURL(uri));
    }

    public boolean isHidden(URI uri) {
        return URLFileSystem.isHidden((URL)this.toURL(uri));
    }

    public boolean isRegularFile(URI uri) {
        return URLFileSystem.isRegularFile((URL)this.toURL(uri));
    }

    public long lastModified(URI uri) {
        return URLFileSystem.lastModified((URL)this.toURL(uri));
    }

    public boolean isReadOnly(URI uri) {
        return URLFileSystem.isReadOnly((URL)this.toURL(uri));
    }

    public URI[] list(URI uri) {
        URL[] urls = URLFileSystem.list((URL)this.toURL(uri));
        if (urls == null) {
            return null;
        }
        URI[] uris = new URI[urls.length];
        int i = 0;
        while (i < urls.length) {
            uris[i] = URIFactory.newURI((URL)urls[i]);
            ++i;
        }
        return uris;
    }

    public URI[] listRoots() {
        URL[] urls = URLFileSystem.listRoots();
        URI[] uris = new URI[urls.length];
        int i = 0;
        while (i < urls.length) {
            uris[i] = URIFactory.newURI((URL)urls[i]);
            ++i;
        }
        return uris;
    }

    public boolean mkdir(URI uri) {
        return URLFileSystem.mkdir((URL)this.toURL(uri));
    }

    public boolean mkdirs(URI uri) {
        return URLFileSystem.mkdirs((URL)this.toURL(uri));
    }

    public URI createTempFile(String prefix, String suffix, URI directory) throws IOException {
        URL url = URLFileSystem.createTempFile((String)prefix, (String)suffix, directory == null ? null : this.toURL(directory));
        return URIFactory.newURI((URL)url);
    }

    public InputStream openInputStream(URI uri) throws IOException {
        URL url = this.toURL(uri);
        return URLFileSystem.openInputStream((URL)url);
    }

    public OutputStream openOutputStream(URI uri) throws IOException {
        URL url = this.toURL(uri);
        return URLFileSystem.openOutputStream((URL)url);
    }

    public boolean renameTo(URI oldURI, URI newURI) {
        return URLFileSystem.renameTo((URL)this.toURL(oldURI), (URL)this.toURL(newURI));
    }

    public boolean setLastModified(URI uri, long time) {
        return URLFileSystem.setLastModified((URL)this.toURL(uri), (long)time);
    }

    public boolean setReadOnly(URI uri, boolean readOnly) {
        return URLFileSystem.setReadOnly((URL)this.toURL(uri), (boolean)readOnly);
    }

    public String toRelativeSpec(URI uri, URI base, boolean mustConsumeBase) {
        return URLFileSystem.toRelativeSpec((URL)this.toURL(uri), (URL)this.toURL(base), (boolean)mustConsumeBase);
    }

    public URI getBaseParent(URI uri, String relativeSpec) {
        URL url = URLFileSystem.getBaseParent((URL)this.toURL(uri), (String)relativeSpec);
        return URIFactory.newURI((URL)url);
    }

    public URL toURL(URI uri) {
        return TheVirtualFileSystem.fixedToURL(uri);
    }

    VirtualFileSystemHelperImpl() {
    }
}

