/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ide.model.spi.TextDocumentImpl;
import javax.ide.model.text.TextModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.ide.model.TextNode;
import oracle.ideimpl.jsr198.model.NodeBridge;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public class TextNodeBridge
extends NodeBridge
implements TextDocumentImpl {
    private static final Map _textBufferListeners = new HashMap();

    public TextNodeBridge(URI uri) {
        super(uri);
    }

    private final TextNode getIdeTextNode() {
        return (TextNode)this.getIdeElement();
    }

    public TextModel getTextModel() {
        return new OracleTextModel(null);
    }

    public Reader getReader() throws IOException {
        return this.getIdeTextNode().getReader();
    }

    static TextNode mav$getIdeTextNode(TextNodeBridge textNodeBridge) {
        return textNodeBridge.getIdeTextNode();
    }

    static Map ra$_textBufferListeners() {
        return _textBufferListeners;
    }

    private class OracleTextModel
    implements TextModel,
    Document {
        private TextBuffer _currentBuffer;

        public synchronized Document getDocument() {
            return this;
        }

        public synchronized void beginEdit() {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            this._currentBuffer.beginEdit();
        }

        public synchronized UndoableEdit commitEdit() {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            return this._currentBuffer.endEdit();
        }

        public synchronized void rollbackEdit() {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing");
            }
            this._currentBuffer.endEdit().undo();
        }

        public synchronized void read(Runnable runnable) {
            if (this._currentBuffer != null) {
                throw new IllegalStateException("Cannot read while writing.");
            }
            this._currentBuffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
            try {
                this._currentBuffer.readLock();
                try {
                    runnable.run();
                }
                finally {
                    this._currentBuffer.readUnlock();
                }
            }
            finally {
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
                this._currentBuffer = null;
            }
        }

        public synchronized void write(Runnable runnable) {
            if (this._currentBuffer != null) {
                throw new IllegalStateException("Cannot write while writing");
            }
            this._currentBuffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
            try {
                this._currentBuffer.writeLock();
                try {
                    runnable.run();
                }
                finally {
                    this._currentBuffer.writeUnlock();
                }
            }
            finally {
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
                this._currentBuffer = null;
            }
        }

        public int getLength() {
            TextBuffer buffer = null;
            try {
                buffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
                buffer.readLock();
                int n = buffer.getLength();
                return n;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (buffer != null) {
                    buffer.readUnlock();
                }
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
            }
        }

        public void remove(int offs, int len) {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            this._currentBuffer.remove(offs, len);
        }

        public void render(Runnable r) {
            throw new UnsupportedOperationException();
        }

        public String getText(int offset, int length) {
            TextBuffer buffer = null;
            try {
                buffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
                buffer.readLock();
                String string = buffer.getString(offset, length);
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                buffer.readUnlock();
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
            }
        }

        public void addDocumentListener(DocumentListener listener) {
            try {
                TextBuffer buffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
                DocumentListenerAdapter tbl = new DocumentListenerAdapter(this, listener);
                TextNodeBridge.ra$_textBufferListeners().put(listener, tbl);
                buffer.addTextBufferListener((TextBufferListener)tbl);
            }
            finally {
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
            }
        }

        public void removeDocumentListener(DocumentListener listener) {
            TextBufferListener tbl = (TextBufferListener)TextNodeBridge.ra$_textBufferListeners().get(listener);
            if (tbl == null) {
                throw new IllegalArgumentException("Unknown listener");
            }
            try {
                TextBuffer buffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
                TextNodeBridge.ra$_textBufferListeners().remove(listener);
                buffer.removeTextBufferListener(tbl);
            }
            finally {
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
            }
        }

        public void addUndoableEditListener(UndoableEditListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeUndoableEditListener(UndoableEditListener listener) {
            throw new UnsupportedOperationException();
        }

        public Element getDefaultRootElement() {
            throw new UnsupportedOperationException();
        }

        public Element[] getRootElements() {
            throw new UnsupportedOperationException();
        }

        public Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        public Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        public Position createPosition(int offs) {
            throw new UnsupportedOperationException();
        }

        public void getText(int offset, int length, Segment txt) {
            TextBuffer buffer = null;
            try {
                buffer = TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).acquireTextBuffer();
                buffer.readLock();
                buffer.getText(offset, length, txt);
            }
            finally {
                buffer.readUnlock();
                TextNodeBridge.mav$getIdeTextNode(TextNodeBridge.this).releaseTextBuffer();
            }
        }

        public Object getProperty(Object key) {
            return null;
        }

        public void putProperty(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void insertString(int offset, String str, AttributeSet a) {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            this._currentBuffer.insert(offset, str.toCharArray());
        }

        private OracleTextModel() {
        }

        OracleTextModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class DocumentListenerAdapter
    implements TextBufferListener {
        private final DocumentListener _delegate;
        private final Document _document;

        DocumentListenerAdapter(Document document, DocumentListener dl) {
            this._document = document;
            this._delegate = dl;
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            1 de = new 1(this, offset, count);
            this._delegate.insertUpdate(de);
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removed) {
            2 de = new 2(this, offset, count);
            this._delegate.removeUpdate(de);
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        static Document ra$_document(DocumentListenerAdapter documentListenerAdapter) {
            return documentListenerAdapter._document;
        }

        final class 1
        implements DocumentEvent {
            private final /* synthetic */ int v$offset;
            private final /* synthetic */ int v$count;
            final /* synthetic */ DocumentListenerAdapter this$0;

            public int getOffset() {
                return this.v$offset;
            }

            public int getLength() {
                return this.v$count;
            }

            public Document getDocument() {
                return DocumentListenerAdapter.ra$_document(this.this$0);
            }

            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.INSERT;
            }

            public DocumentEvent.ElementChange getChange(Element elem) {
                throw new UnsupportedOperationException();
            }

            public 1(DocumentListenerAdapter documentListenerAdapter, int n, int n2) {
                this.v$count = n2;
                this.v$offset = n;
                this.this$0 = documentListenerAdapter;
            }
        }

        final class 2
        implements DocumentEvent {
            private final /* synthetic */ int v$offset;
            private final /* synthetic */ int v$count;
            final /* synthetic */ DocumentListenerAdapter this$0;

            public int getOffset() {
                return this.v$offset;
            }

            public int getLength() {
                return this.v$count;
            }

            public Document getDocument() {
                return DocumentListenerAdapter.ra$_document(this.this$0);
            }

            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.REMOVE;
            }

            public DocumentEvent.ElementChange getChange(Element elem) {
                throw new UnsupportedOperationException();
            }

            public 2(DocumentListenerAdapter documentListenerAdapter, int n, int n2) {
                this.v$count = n2;
                this.v$offset = n;
                this.this$0 = documentListenerAdapter;
            }
        }
    }
}

