/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.view;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.view.GUIPanel;
import javax.ide.view.URISelectionDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ideimpl.jsr198.model.ContextFactory;

final class OracleURIChooser
implements URISelectionDialog {
    private final String _title;
    private final GUIPanel _parent;
    private final Context _oideContext;
    private final javax.ide.command.Context _javaxContext;
    private URL _location;
    private URLChooser _delegate;
    private final boolean _directories;

    public OracleURIChooser(boolean directories, String title, URI location, javax.ide.command.Context context, GUIPanel parent) {
        this._directories = directories;
        this._title = title;
        this._parent = parent;
        this._javaxContext = context;
        this._oideContext = ContextFactory.createOracleContext(context);
        try {
            this._location = location == null ? null : VirtualFileSystem.getVirtualFileSystem().toURL(location);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            this._location = null;
        }
    }

    private void createDelegate(URISelectionDialog.Validator validator) {
        if (validator == null) {
            this._delegate = DialogUtil.newURLChooser((Context)this._oideContext, (URL)this._location);
        } else {
            this._delegate = new 1(this, this._location, validator);
            DialogUtil.initURLChooser((URLChooser)this._delegate, (Context)this._oideContext);
        }
        this._delegate.setSelectionScope(this._directories ? 1 : 2);
    }

    public int show() {
        return this.show(null);
    }

    public int show(URISelectionDialog.Validator validator) {
        this.createDelegate(validator);
        int result = this._delegate.showOpenDialog((Component)(this._parent == null ? Ide.getMainWindow() : (Component)this._parent.getRootComponent()), this._title);
        return result == 0 ? 0 : 3;
    }

    public URI[] getResults() {
        if (this._delegate == null) {
            throw new IllegalStateException("Dialog not yet shown.");
        }
        URL[] urlResults = this._delegate.getSelectedURLs();
        if (urlResults == null) {
            return null;
        }
        URI[] uriResults = new URI[urlResults.length];
        int i = 0;
        while (i < urlResults.length) {
            URL url = urlResults[i];
            uriResults[i] = URIFactory.newURI((URL)url);
            ++i;
        }
        return uriResults;
    }

    static javax.ide.command.Context ra$_javaxContext(OracleURIChooser oracleURIChooser) {
        return oracleURIChooser._javaxContext;
    }

    final class 1
    extends URLChooser {
        private final /* synthetic */ URISelectionDialog.Validator v$validator;
        final /* synthetic */ OracleURIChooser this$0;

        public boolean approveSelection() {
            if (super.approveSelection()) {
                return this.v$validator.validate(this.this$0.getResults(), OracleURIChooser.ra$_javaxContext(this.this$0));
            }
            return false;
        }

        public 1(OracleURIChooser oracleURIChooser, URL uRL, URISelectionDialog.Validator validator) {
            this.v$validator = validator;
            this.this$0 = oracleURIChooser;
            super(uRL);
        }
    }
}

