/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.ide.extension.Extension;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;

public final class MigrationDialog
extends JEWTDialog
implements VetoableChangeListener {
    private static final String HELP_TOPIC_BROWSE_DLG = "f1_migbrowse_html";
    private static final String EXTENSION = "Migrator";
    private ArrayList result;
    private boolean isManual;
    private final JPanel mainPanel;
    private final JMultiLineLabel prompt;
    private final JPanel centerPanel;
    private final JLabel versionLabel;
    private final JTextField versionField;
    private final JButton browseButton;
    private BorderLayout dialogBorderLayout;
    private GridBagLayout centerPanelLayout;
    private URL selection;
    private boolean vetoed;

    private void $init$() {
        this.result = new ArrayList();
        this.mainPanel = new JPanel();
        this.prompt = new JMultiLineLabel();
        this.centerPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.versionField = new JTextField();
        this.browseButton = new JButton();
        this.dialogBorderLayout = new BorderLayout(0, 8);
        this.centerPanelLayout = new GridBagLayout();
        this.selection = URLFactory.newDirURL((String)Ide.getSystemDirectory());
    }

    public MigrationDialog(Frame parent) {
        super(parent, IdeArb.getString((int)107), 3);
        this.$init$();
        try {
            this.jbInit();
            this.setContent(this.mainPanel);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.addVetoableChangeListener(this);
        this.mainPanel.setLayout(this.dialogBorderLayout);
        this.prompt.setText(IdeArb.format((int)269, (Object[])new String[]{IdeArb.getString((int)377)}));
        this.prompt.setPreferredColumns(60);
        ResourceUtils.resLabel((JLabel)this.versionLabel, (Component)this.versionField, (String)IdeArb.getString((int)213));
        this.versionField.setText(Ide.getSystemDirectory());
        ResourceUtils.resButton((AbstractButton)this.browseButton, (String)IdeArb.getString((int)156));
        this.browseButton.addActionListener(new 1());
        this.centerPanel.setLayout(this.centerPanelLayout);
        this.centerPanel.add((Component)this.versionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.versionField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 8, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.prompt, "North");
        this.mainPanel.add((Component)this.centerPanel, "Center");
    }

    public void setManualMigration(boolean flag) {
        this.isManual = flag;
        this.prompt.setText(flag ? IdeArb.getString((int)269) : IdeArb.getString((int)223));
    }

    public File getSource() {
        return new File(this.selection.getPath());
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (this.vetoed) {
            this.vetoed = false;
            return;
        }
        if (!(URLFileSystem.exists((URL)this.selection) && URLFileSystem.isDirectory((URL)this.selection) && URLFileSystem.getFileName((URL)this.selection).startsWith("system"))) {
            String msg = IdeArb.format((int)73, (Object)URLFileSystem.getPlatformPathName((URL)this.selection));
            JOptionPane.showMessageDialog((Component)((Object)this), msg, IdeArb.getString((int)207), 2);
            this.vetoed = true;
            throw new PropertyVetoException(msg, e);
        }
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            ExtensionRegistry reg = ExtensionRegistry.getOracleRegistry();
            Collection extensions = reg.getExtensions();
            for (Extension extension : extensions) {
                if (!this.isManual && !reg.isNewlyInstalled(extension.getID())) continue;
                this.result.add(extension);
            }
            this.selection = URLFactory.newDirURL((String)this.versionField.getText());
        }
        super.dismissDialog(cancelled);
    }

    public Collection getSelectedExtensions() {
        return Collections.unmodifiableCollection(this.result);
    }

    private void browse(ActionEvent e) {
        URL location = this.selection;
        URL suggested = URLFactory.newDirURL((String)this.versionField.getText());
        if (suggested != null && URLFileSystem.isValid((URL)suggested)) {
            location = suggested;
        }
        URLChooser chooser = DialogUtil.newURLChooser((URL)location);
        chooser.setShowJarsAsDirs(false);
        chooser.setSelectionScope(1);
        chooser.setHelpID(null);
        if (chooser.showOpenDialog((Component)((Object)this), IdeArb.getString((int)11)) == 0) {
            this.selection = chooser.getSelectedURL();
            this.versionField.setText(URLFileSystem.getPlatformPathName((URL)this.selection));
        }
    }

    static void mav$browse(MigrationDialog migrationDialog, ActionEvent actionEvent) {
        migrationDialog.browse(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MigrationDialog.mav$browse(MigrationDialog.this, e);
        }
    }
}

