/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.ide.util.Version;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSystemMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.migration.MigrationDialog;
import oracle.ideimpl.migration.MigratorsHook;
import oracle.javatools.controls.SplashScreen;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class MigrationManagerImpl
extends MigrationManager {
    private ArrayList _registrations;
    private ArrayList _migrators;
    private HashMap _map;
    private File _srcDir;
    private boolean _migrate;
    private boolean _done;
    private static MigrationManager _instance;

    private void $init$() {
        this._registrations = new ArrayList();
        this._map = new HashMap();
    }

    public static synchronized MigrationManager getInstance() {
        if (_instance == null) {
            _instance = new MigrationManagerImpl();
        }
        return _instance;
    }

    private ArrayList getMigrators(Extension descriptor) {
        this.getMigrators();
        return (ArrayList)this._map.get(descriptor);
    }

    public synchronized List getMigrators() {
        if (this._migrators == null) {
            this.registerHookMigrators();
            int count = this._registrations.size();
            if (count <= 0) {
                this._migrators = new ArrayList();
            } else {
                this._migrators = new ArrayList();
                int i = 0;
                while (i < count) {
                    String clsName = this._registrations.get(i).toString();
                    Migrator migrator = this.buildMigrator(clsName);
                    if (migrator != null) {
                        Extension desc = (Extension)this._registrations.get(i + 1);
                        ArrayList<Migrator> list = this.getMigrators(desc);
                        if (list == null) {
                            list = new ArrayList<Migrator>();
                            this._map.put(desc, list);
                        }
                        list.add(migrator);
                        this._migrators.add(migrator);
                    }
                    i += 2;
                }
            }
        }
        return this._migrators;
    }

    private void registerHookMigrators() {
        ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
        MigratorsHook migHook = (MigratorsHook)reg.getHook(MigratorsHook.ELEMENT);
        if (migHook != null) {
            for (Map.Entry<Extension, Collection<String>> entry : migHook.getMigratorClassesByExtension().entrySet()) {
                Extension ext = entry.getKey();
                Collection<String> migClasses = entry.getValue();
                for (String className : migClasses) {
                    this.registerMigrator(className, ext);
                }
            }
        }
    }

    private Migrator buildMigrator(String clsName) {
        Migrator migrator = null;
        try {
            Class<?> cls = Class.forName(clsName);
            migrator = (Migrator)cls.newInstance();
        }
        catch (Exception e) {
            Assert.println((String)("Failed trying to load migrator: " + clsName));
        }
        return migrator;
    }

    public Migrator getMigrator(Class cls) {
        List migrators = this.getMigrators();
        for (Migrator migrator : migrators) {
            if (cls != migrator.getClass()) continue;
            return migrator;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getOracleHomeDirectory(File systemDir) {
        File file;
        try {
            String path = Ide.getInstallDirectory((File)systemDir);
            if (path != null && ModelUtil.hasLength((String)path)) {
                File jDevBinDir = new File(path);
                return jDevBinDir.getParentFile().getParentFile();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedInputStream in = null;
        try {
            File paletteXmlFile = new File(systemDir, "palette.xml");
            if (!paletteXmlFile.exists()) return null;
            in = new BufferedInputStream(new FileInputStream(paletteXmlFile));
            DOMParser domParser = new DOMParser();
            domParser.parse((InputStream)in);
            XMLDocument doc = domParser.getDocument();
            XMLElement rootElem = (XMLElement)doc.getDocumentElement();
            1 xmlns = new 1(this, rootElem);
            NodeList bc4jTaglibs = rootElem.selectNodes("a:jsplibrary[a:prefix='jbo' or a:prefix='bc4juix' or a:prefix='uix']/a:location/text()", (NSResolver)xmlns);
            File oracleHome = MigrationManagerImpl.findOracleHome(bc4jTaglibs, 3);
            if (oracleHome != null) {
                file = oracleHome;
                return file;
            }
            NodeList ojspTaglibs = rootElem.selectNodes("a:jsplibrary[a:prefix='email' or a:prefix='fileaccess' or a:prefix='JESI' or a:prefix='jwcache' or a:prefix='database' or a:prefix='util' or a:prefix='XML' or a:prefix='EJB']/a:location/text()", (NSResolver)xmlns);
            File file2 = MigrationManagerImpl.findOracleHome(ojspTaglibs, 4);
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (in == null) return file;
            try {
                in.close();
                return file;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static File findOracleHome(NodeList nodes, int levelsUp) {
        int n = nodes.getLength();
        int i = 0;
        while (i < n) {
            org.w3c.dom.Node node = nodes.item(i);
            String dirStr = node.getNodeValue();
            if (ModelUtil.hasLength((String)dirStr)) {
                File dir = new File(dirStr);
                int j = 0;
                while (j < levelsUp) {
                    if (dir == null) break;
                    dir = dir.getParentFile();
                    ++j;
                }
                if (dir != null) {
                    return dir;
                }
            }
            ++i;
        }
        return null;
    }

    public synchronized void registerMigrator(String name, Extension desc) {
        Migrator migrator;
        if (name == null || desc == null) {
            return;
        }
        if (!this._registrations.contains(name)) {
            this._registrations.add(name);
            this._registrations.add(desc);
        }
        if (this._migrators != null && (migrator = this.buildMigrator(name)) != null) {
            this._migrators.add(migrator);
            ArrayList<Migrator> list = this.getMigrators(desc);
            if (list == null) {
                list = new ArrayList<Migrator>();
                this._map.put(desc, list);
            }
            list.add(migrator);
        }
    }

    public void migrate() {
        boolean noMigrate;
        boolean migrateFlag;
        IdeArgs args = Ide.getIdeArgs();
        this._migrate = migrateFlag = args.isMigrate();
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        for (Extension extension : extReg.getExtensions()) {
            if (!extReg.isNewlyInstalled(extension.getID())) continue;
            this._migrate = true;
            break;
        }
        boolean bl = noMigrate = System.getProperty("nomigrate", null) != null || args.hasArg("-nonag");
        if (!migrateFlag && noMigrate) {
            this._migrate = false;
        }
        if (this._migrate && args.getCreateUI()) {
            this.migrate(migrateFlag, extReg.getExtensions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMigration() {
        block10: {
            try {
                XMLMigrator migrator;
                XMLMigrator xMLMigrator = migrator = this._migrate ? (XMLMigrator)this.getMigrator(IdeSystemMigrator.class) : null;
                if (migrator == null || !migrator.isSelected(0)) break block10;
                MigrationManagerImpl migrationManagerImpl = this;
                synchronized (migrationManagerImpl) {
                    SwingUtilities.invokeLater(new WorkspacesMigrator(this));
                    while (!this._done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                        }
                        catch (Throwable t) {
                            if (!(t instanceof ThreadDeath)) break;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            }
            finally {
                MigrationManagerImpl.setMigrationManager(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrate(boolean flag, Collection extensions) {
        List migrators = this.getMigrators();
        if (migrators == null || migrators.isEmpty()) {
            return true;
        }
        boolean ok = true;
        boolean splashHidden = false;
        if (this._srcDir == null) {
            if (!flag) {
                Object lock;
                if (PlatformUtils.isLinux()) {
                    SwingUtilities.invokeLater(new 2());
                    splashHidden = true;
                }
                Object object = lock = new Object();
                synchronized (object) {
                    boolean[] ret = new boolean[]{false};
                    SwingUtilities.invokeLater(new 3(this, lock, ret));
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ok = ret[0];
                }
            }
            if (ok) {
                boolean[] ret = new boolean[]{false};
                MigrationDialog dlg = new MigrationDialog(SwingUtils.getToplevelWindow());
                try {
                    SwingUtilities.invokeAndWait(new 4(this, dlg, flag, ret));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ok = ret[0];
                if (ok) {
                    this._srcDir = dlg.getSource();
                    extensions = dlg.getSelectedExtensions();
                }
                dlg.dispose();
            }
        }
        if (ok) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            StringBuilder buf = new StringBuilder();
            String productID = ProductInformation.getProductID();
            boolean isSameSystemDirectoryAsBefore = new File(Ide.getSystemDirectory()).equals(this._srcDir);
            for (Extension extension : extensions) {
                File preferencesFileSrc;
                Iterator iter;
                URL srcUrl = MigrationManagerImpl.findNewestSystemDir(URLFactory.newFileURL((File)this._srcDir), extension, isSameSystemDirectoryAsBefore);
                File src = new File(URLFileSystem.getPlatformPathName((URL)srcUrl));
                URL url = extReg.getSystemDirectory(extension.getID());
                File dest = new File(url.getPath());
                if (src == null || dest == null || src.equals(dest)) continue;
                ArrayList list = this.getMigrators(extension);
                Iterator iterator = iter = list != null ? list.iterator() : null;
                if (iter != null) {
                    while (iter.hasNext()) {
                        Migrator migrator = (Migrator)iter.next();
                        int[] categories = migrator.getMigrationCategories();
                        int index = 0;
                        while (index < categories.length) {
                            int category = categories[index];
                            migrator.setSelected(category, migrator.canMigrate(category, src));
                            ++index;
                        }
                        String[] errors = null;
                        try {
                            errors = migrator.migrate(src, dest);
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            FeedbackManager.reportException((Throwable)t);
                        }
                        if (errors == null || errors.length <= 0) continue;
                        int j = 0;
                        while (j < errors.length) {
                            buf.append(errors[j]);
                            buf.append("\n");
                            ++j;
                        }
                        buf.append("\n");
                    }
                }
                if (productID.equals(extension.getID())) {
                    File productPrefsSrc = new File(src, "product-preferences.xml");
                    HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/hash", "ide:preferences");
                    try {
                        Preferences prefs = Preferences.getPreferences();
                        io.open(URLFactory.newFileURL((File)productPrefsSrc), (Object)prefs.getProperties());
                        prefs.save();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                if (!(preferencesFileSrc = new File(src, "preferences.xml")).isFile() || !preferencesFileSrc.canRead()) continue;
                File preferencesFileDest = new File(dest, "preferences.xml");
                try {
                    URLFileSystem.copy((URL)URLFactory.newFileURL((File)preferencesFileSrc), (URL)URLFactory.newFileURL((File)preferencesFileDest));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (buf.length() > 0) {
                JMultiLineLabel jMultiLabel = new JMultiLineLabel(buf.toString());
                JScrollPane jScrollPane = new JScrollPane((Component)jMultiLabel);
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                JOptionPane jOptionPane = new JOptionPane(jScrollPane, 2);
                JDialog jDlg = jOptionPane.createDialog(SwingUtils.getToplevelWindow(), IdeArb.getString((int)107));
                jDlg.setResizable(true);
                jDlg.pack();
                if (jDlg.getWidth() > size.width / 3 || jDlg.getHeight() > size.height / 3) {
                    jDlg.setBounds(size.width / 3, size.height / 3, size.width / 3, size.height / 3);
                }
                jDlg.setVisible(true);
                jDlg.dispose();
            }
        }
        if (splashHidden) {
            SwingUtilities.invokeLater(new 5());
        }
        return ok;
    }

    private static String expandExtensionId(String name) {
        if (name != null && name.startsWith("o.") && name.length() > "o.".length()) {
            return "oracle." + name.substring("o.".length());
        }
        return name;
    }

    private static boolean hasPrefix(String text, String prefix) {
        return text.startsWith(prefix) && text.length() > prefix.length();
    }

    private static String removePrefix(String text, String prefix) {
        return text.substring(prefix.length());
    }

    private static boolean isNewerThan(Version one, Version two) {
        return one.compareTo(two) > 0;
    }

    private static boolean isOlderThan(Version one, Version two) {
        return one.compareTo(two) < 0;
    }

    private static Version versionOrNull(String version) {
        try {
            Version version2 = new Version(version);
            return version2;
        }
        catch (NumberFormatException nfe) {
            Version version3 = null;
            return version3;
        }
    }

    static URL findNewestSystemDir(URL root, Extension extension, boolean isSameSystemDirectoryAsBefore) {
        URL[] subdirs = URLFileSystem.list((URL)root);
        if (subdirs == null) {
            return root;
        }
        String extensionId = extension.getID();
        Version extensionVersion = extension.getVersion();
        Version productVersion = null;
        String rootName = URLFileSystem.getFileName((URL)root);
        if (MigrationManagerImpl.hasPrefix(rootName, "system")) {
            productVersion = MigrationManagerImpl.versionOrNull(MigrationManagerImpl.removePrefix(rootName, "system"));
        }
        Version latestVersion = null;
        URL latestUrl = null;
        URL[] uRLArray = subdirs;
        int n = 0;
        while (n < uRLArray.length) {
            URL dir = uRLArray[n];
            if (URLFileSystem.isDirectory((URL)dir)) {
                String name = MigrationManagerImpl.expandExtensionId(URLFileSystem.getFileName((URL)dir));
                Version candidateVersion = null;
                if (productVersion != null && name.equals(extensionId)) {
                    candidateVersion = productVersion;
                } else if (MigrationManagerImpl.hasPrefix(name, extensionId + ".")) {
                    candidateVersion = MigrationManagerImpl.versionOrNull(MigrationManagerImpl.removePrefix(name, extensionId + "."));
                }
                if (candidateVersion != null) {
                    if (!isSameSystemDirectoryAsBefore && candidateVersion.equals((Object)extensionVersion)) {
                        latestVersion = candidateVersion;
                        latestUrl = dir;
                    }
                    if (MigrationManagerImpl.isOlderThan(candidateVersion, extensionVersion) && (latestVersion == null || MigrationManagerImpl.isNewerThan(candidateVersion, latestVersion))) {
                        latestVersion = candidateVersion;
                        latestUrl = dir;
                    }
                }
            }
            ++n;
        }
        if (latestUrl == null) {
            return root;
        }
        return latestUrl;
    }

    public MigrationManagerImpl() {
        this.$init$();
    }

    static void wa$_done(MigrationManagerImpl migrationManagerImpl, boolean bl) {
        migrationManagerImpl._done = bl;
    }

    final class 1
    implements NSResolver {
        private final /* synthetic */ XMLElement v$rootElem;
        private final String uri;
        final /* synthetic */ MigrationManagerImpl this$0;

        private void $init$() {
            this.uri = this.v$rootElem.getNamespaceURI();
        }

        public String resolveNamespacePrefix(String prefix) {
            return "a".equals(prefix) ? this.uri : null;
        }

        public 1(MigrationManagerImpl migrationManagerImpl, XMLElement xMLElement) {
            this.v$rootElem = xMLElement;
            this.this$0 = migrationManagerImpl;
            this.$init$();
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            SplashScreen.setVisible((boolean)false);
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Object v$lock;
        private final /* synthetic */ boolean[] v$ret;
        final /* synthetic */ MigrationManagerImpl this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.v$lock;
            synchronized (object) {
                try {
                    this.v$ret[0] = MessageDialog.confirm((Component)SwingUtils.getToplevelWindow(), (Object)IdeArb.getString((int)210), (String)IdeArb.getString((int)107), null);
                }
                finally {
                    this.v$lock.notifyAll();
                }
            }
        }

        public 3(MigrationManagerImpl migrationManagerImpl, Object object, boolean[] blArray) {
            this.v$ret = blArray;
            this.v$lock = object;
            this.this$0 = migrationManagerImpl;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ MigrationDialog v$dlg;
        private final /* synthetic */ boolean v$flag;
        private final /* synthetic */ boolean[] v$ret;
        final /* synthetic */ MigrationManagerImpl this$0;

        public void run() {
            this.v$dlg.setManualMigration(this.v$flag);
            this.v$dlg.pack();
            this.v$ret[0] = this.v$dlg.runDialog();
        }

        public 4(MigrationManagerImpl migrationManagerImpl, MigrationDialog migrationDialog, boolean bl, boolean[] blArray) {
            this.v$ret = blArray;
            this.v$flag = bl;
            this.v$dlg = migrationDialog;
            this.this$0 = migrationManagerImpl;
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            SplashScreen.setVisible((boolean)true);
        }
    }

    private static final class WorkspacesMigrator
    implements Runnable {
        MigrationManagerImpl _manager;

        WorkspacesMigrator(MigrationManagerImpl manager) {
            this._manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            MigrationManagerImpl migrationManagerImpl = this._manager;
            synchronized (migrationManagerImpl) {
                block23: {
                    try {
                        try {
                            Node[] workspaceNodes;
                            MigrationInfo[] minfos;
                            Workspaces workspacesToMigrate = null;
                            Iterator iter = Ide.getSystem().getChildren();
                            if (iter != null) {
                                while (iter.hasNext()) {
                                    Object o = iter.next();
                                    if (!(o instanceof Workspaces)) continue;
                                    workspacesToMigrate = (Workspaces)o;
                                    break;
                                }
                            }
                            if (workspacesToMigrate == null) {
                                return;
                            }
                            ArrayList list = new ArrayList();
                            iter = workspacesToMigrate.getChildren();
                            if (iter != null) {
                                while (iter.hasNext()) {
                                    Object wo = iter.next();
                                    if (!(wo instanceof Workspace)) continue;
                                    list.add(wo);
                                }
                            }
                            if (list.size() == 0) {
                            }
                            NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator((String)NodeMigrator.getLookupKey((Node)((Node)list.get(0))));
                            if (nodeMigrator == null || nodeMigrator.checkVersions(minfos = nodeMigrator.getMigrationInfos(workspaceNodes = list.toArray(new Node[list.size()]))) != MigrationInfo.MIGRATION_PENDING) break block23;
                            MigrationInfo[] resultInfo = nodeMigrator.migrate(minfos);
                            ArrayList<Node> nodes = null;
                            int i = 0;
                            while (i < resultInfo.length) {
                                if (resultInfo[i].getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
                                    Node toRemove = resultInfo[i].getNode();
                                    workspacesToMigrate.remove((Element)toRemove);
                                    if (nodes == null) {
                                        nodes = new ArrayList<Node>();
                                    }
                                    nodes.add(toRemove);
                                }
                                ++i;
                            }
                            if (nodes != null && nodes.size() > 0) {
                                UpdateMessage.fireChildrenRemoved((Subject)workspacesToMigrate, (Collection)nodes);
                            }
                        }
                        finally {
                            MigrationManagerImpl.wa$_done(this._manager, true);
                            this._manager.notifyAll();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    Ide.getDefaultProject().save();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }
}

