/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import java.net.URLStreamHandlerFactory;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public final class URLFileSystemHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem";
    private static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "urlfilesystem-hook");
    private static final ElementName STREAMFACTORY = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "streamfactory");
    private static final ElementName FSHELPER = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "fshelper");
    private final ElementVisitor _streamFactoryHandler;
    private final ElementVisitor _helperHandler;

    private void $init$() {
        this._streamFactoryHandler = new StreamFactoryHandler(null);
        this._helperHandler = new HelperHandler(null);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(STREAMFACTORY, this._streamFactoryHandler);
        context.registerChildVisitor(FSHELPER, this._helperHandler);
    }

    public URLFileSystemHook() {
        this.$init$();
    }

    private class StreamFactoryHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null) {
                context.getLogger().severe("Missing required attribute 'class'");
                return;
            }
            try {
                Class<?> cls = Class.forName(className);
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)cls.newInstance();
                URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)factory);
            }
            catch (Exception e) {
                context.getLogger().severe("Failed to create stream factory class " + className);
            }
        }

        private StreamFactoryHandler() {
        }

        StreamFactoryHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HelperHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String protocol = context.getAttributeValue("protocol");
            String className = context.getAttributeValue("class");
            if (protocol == null) {
                context.getLogger().severe("Required attribute protocol missing from helper");
                return;
            }
            if (className == null) {
                context.getLogger().severe("Required attribute class missing from helper");
                return;
            }
            try {
                Class<?> cls = Class.forName(className);
                URLFileSystemHelper helper = (URLFileSystemHelper)cls.newInstance();
                URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)helper);
            }
            catch (Exception e) {
                context.getLogger().severe("Failed to create helper class " + className);
            }
        }

        private HelperHandler() {
        }

        HelperHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

