/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.ide.nulls.NullIcon;

final class WindowsMenuItemUIHelper {
    static final Icon BLANK_ICON = new NullIcon();
    PropertyChangeListener _propertyChangeListener;

    WindowsMenuItemUIHelper() {
    }

    void installDefaults(JMenuItem menuItem) {
        if (menuItem.getIcon() == null) {
            menuItem.setIcon(BLANK_ICON);
        }
        if (menuItem.getDisabledIcon() == null) {
            menuItem.setDisabledIcon(BLANK_ICON);
        }
        if (menuItem.getPressedIcon() == null) {
            menuItem.setPressedIcon(BLANK_ICON);
        }
    }

    void installListeners(JMenuItem menuItem) {
        this._propertyChangeListener = this.createPropertyChangeListener(menuItem);
        if (this._propertyChangeListener != null) {
            menuItem.addPropertyChangeListener(this._propertyChangeListener);
        }
    }

    void uninstallDefaults(JMenuItem menuItem) {
        if (menuItem.getIcon() == BLANK_ICON) {
            menuItem.setIcon(null);
        }
        if (menuItem.getDisabledIcon() == BLANK_ICON) {
            menuItem.setDisabledIcon(null);
        }
        if (menuItem.getPressedIcon() == BLANK_ICON) {
            menuItem.setPressedIcon(null);
        }
    }

    void uninstallListeners(JMenuItem menuItem) {
        if (this._propertyChangeListener != null) {
            menuItem.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
    }

    PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    static class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if (name.equals("icon")) {
                if (e.getNewValue() == null) {
                    menuItem.setIcon(BLANK_ICON);
                }
            } else if (name.equals("disabledIcon")) {
                if (e.getNewValue() == null) {
                    menuItem.setDisabledIcon(BLANK_ICON);
                }
            } else if (name.equals("pressedIcon") && e.getNewValue() == null) {
                menuItem.setPressedIcon(BLANK_ICON);
            }
        }

        PropertyChangeHandler() {
        }
    }
}

