/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.util.JDK;
import oracle.ideimpl.plaf.DefaultTreeCellRendererFocusFix;
import oracle.ideimpl.plaf.TreeUIHelper;

public class WindowsTreeUI
extends BasicTreeUI {
    protected TreeUIHelper helper;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsTreeUI();
    }

    public void installUI(JComponent c) {
        this.helper = new TreeUIHelper((JTree)c);
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.helper = null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.helper.installKeyboardActionsHook();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        if (JDK.HAS_BUG_4674205) {
            return new DefaultTreeCellRendererFocusFix();
        }
        return super.createDefaultCellRenderer();
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        this.drawDashedHorizontalLine(g, y, left, right);
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        this.drawDashedVerticalLine(g, x, top, bottom);
    }

    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        if (this.tree != null && beginRow >= 0 && endRow < this.getRowCount(this.tree)) {
            Rectangle visRect = this.tree.getVisibleRect();
            if (beginRow == endRow) {
                Rectangle scrollBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (scrollBounds != null) {
                    scrollBounds.x = visRect.x;
                    scrollBounds.width = visRect.width;
                    this.tree.scrollRectToVisible(scrollBounds);
                }
            } else {
                Rectangle beginRect;
                Rectangle testRect = beginRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                int beginY = beginRect.y;
                int maxY = beginY + visRect.height;
                int counter = beginRow + 1;
                while (counter <= endRow) {
                    testRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, counter));
                    if (testRect.y + testRect.height > maxY) {
                        counter = endRow;
                    }
                    ++counter;
                }
                this.tree.scrollRectToVisible(new Rectangle(visRect.x, beginY, 1, testRect.y + testRect.height - beginY));
            }
        }
    }

    static JTree ra$tree(WindowsTreeUI windowsTreeUI) {
        return windowsTreeUI.tree;
    }

    static void mav$selectPathForEvent(WindowsTreeUI windowsTreeUI, TreePath treePath, MouseEvent mouseEvent) {
        windowsTreeUI.selectPathForEvent(treePath, mouseEvent);
    }

    static void mav$checkForClickInExpandControl(WindowsTreeUI windowsTreeUI, TreePath treePath, int n, int n2) {
        windowsTreeUI.checkForClickInExpandControl(treePath, n, n2);
    }

    static boolean mav$startEditing(WindowsTreeUI windowsTreeUI, TreePath treePath, MouseEvent mouseEvent) {
        return windowsTreeUI.startEditing(treePath, mouseEvent);
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath;

        private void $init$() {
            this.lastSelectedPath = null;
        }

        public void mousePressed(MouseEvent event) {
            if (WindowsTreeUI.ra$tree(WindowsTreeUI.this) != null && WindowsTreeUI.ra$tree(WindowsTreeUI.this).isEnabled() && !event.isConsumed()) {
                if (JDK.HAS_BUG_MENU_RESTORES_WRONG_FOCUS) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
                WindowsTreeUI.ra$tree(WindowsTreeUI.this).requestFocus();
                TreePath path = WindowsTreeUI.this.getClosestPathForLocation(WindowsTreeUI.ra$tree(WindowsTreeUI.this), event.getX(), event.getY());
                if (path != null) {
                    int x;
                    Rectangle bounds = WindowsTreeUI.this.getPathBounds(WindowsTreeUI.ra$tree(WindowsTreeUI.this), path);
                    if (event.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        WindowsTreeUI.mav$checkForClickInExpandControl(WindowsTreeUI.this, path, event.getX(), event.getY());
                    }
                    if ((x = event.getX()) > bounds.x && x <= bounds.x + bounds.width && !WindowsTreeUI.mav$startEditing(WindowsTreeUI.this, path, event)) {
                        if (WindowsTreeUI.ra$tree(WindowsTreeUI.this).isPathSelected(path)) {
                            this.lastSelectedPath = path;
                        } else {
                            this.lastSelectedPath = null;
                            WindowsTreeUI.mav$selectPathForEvent(WindowsTreeUI.this, path, event);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
            TreePath path;
            if (WindowsTreeUI.ra$tree(WindowsTreeUI.this) != null && WindowsTreeUI.ra$tree(WindowsTreeUI.this).isEnabled() && !event.isConsumed() && (path = WindowsTreeUI.this.getClosestPathForLocation(WindowsTreeUI.ra$tree(WindowsTreeUI.this), event.getX(), event.getY())) != null) {
                Rectangle bounds = WindowsTreeUI.this.getPathBounds(WindowsTreeUI.ra$tree(WindowsTreeUI.this), path);
                if (event.getY() > bounds.y + bounds.height) {
                    return;
                }
                int x = event.getX();
                if (x > bounds.x && x <= bounds.x + bounds.width && path.equals(this.lastSelectedPath)) {
                    WindowsTreeUI.mav$selectPathForEvent(WindowsTreeUI.this, path, event);
                }
            }
            this.lastSelectedPath = null;
        }

        private MouseHandler() {
            this.$init$();
        }

        MouseHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

