/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.Component;
import java.util.ArrayList;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.print.ComponentPageableFactory;

final class FactoryRegistry {
    private ArrayList _pageableFactories;
    private ArrayList _documentPrintFactories;
    public static int INSERT_START = 0;
    public static int INSERT_BEFORE = 1;
    public static int INSERT_AFTER = 2;
    private static int EXACT_MATCH = 1;
    private static int ASSIGNABLE_FROM_MATCH = 2;
    private static int RETURN_PAGEABLE_FACTORY_CLASS = 1;
    private static int RETURN_SOURCE_CLASS = 2;

    private void $init$() {
        this._pageableFactories = new ArrayList(3);
        this._documentPrintFactories = new ArrayList(3);
    }

    FactoryRegistry() {
        this.$init$();
        this.registerPageableFactory(Component.class, ComponentPageableFactory.class);
    }

    public boolean registerPageableFactory(Class pageableSourceClass, Class pageableFactoryClass) {
        return this.registerPageableFactory(pageableSourceClass, pageableFactoryClass, pageableSourceClass, INSERT_BEFORE);
    }

    public boolean registerPageableFactory(String pageableSourceClassString, String pageableFactoryClassString) {
        return this.registerPageableFactory(pageableSourceClassString, pageableFactoryClassString, pageableSourceClassString, INSERT_BEFORE);
    }

    public boolean registerPageableFactory(String pageableSourceClassString, String pageableFactoryClassString, String targetSourceClassString, int insertLocation) {
        Class<?> sourceClass = null;
        Class<?> factoryClass = null;
        Class<?> targetSourceClass = null;
        try {
            sourceClass = Class.forName(pageableSourceClassString);
            factoryClass = Class.forName(pageableFactoryClassString);
            boolean isPageableFactory = false;
            Class<?>[] interfaceList = factoryClass.getInterfaces();
            int i = 0;
            while (i < interfaceList.length) {
                if (interfaceList[i] == PageableFactory.class) {
                    isPageableFactory = true;
                    break;
                }
                ++i;
            }
            if (!isPageableFactory) {
                boolean bl = false;
                return bl;
            }
            if (ModelUtil.hasLength((String)targetSourceClassString)) {
                targetSourceClass = Class.forName(targetSourceClassString);
            }
        }
        catch (ClassNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        return this.registerPageableFactory(sourceClass, factoryClass, targetSourceClass, insertLocation);
    }

    public boolean registerPageableFactory(Class pageableSourceClass, Class pageableFactoryClass, Class targetSourceClass, int insertLocation) {
        if (this.findFactoryClassPairForClass(pageableSourceClass, this._pageableFactories, EXACT_MATCH) == -1) {
            int insertAtPosition = INSERT_START;
            if (targetSourceClass != null && insertLocation != INSERT_START) {
                insertAtPosition = this.findFactoryClassPairForClass(targetSourceClass, this._pageableFactories, ASSIGNABLE_FROM_MATCH);
                if (insertLocation != INSERT_BEFORE || insertAtPosition == -1) {
                    insertAtPosition = insertLocation == INSERT_AFTER && insertAtPosition != -1 ? ++insertAtPosition : this._pageableFactories.size();
                }
            }
            this.registerFactory(pageableSourceClass, pageableFactoryClass, this._pageableFactories, insertAtPosition);
        }
        return true;
    }

    public void unregisterPageableFactory(String pageableSourceClassString) {
        this.unregisterFactory(pageableSourceClassString, this._pageableFactories);
    }

    public void unregisterPageableFactory(Class pageableSourceClass) {
        this.unregisterFactory(pageableSourceClass, this._pageableFactories);
    }

    public Class getPageableFactoryClassForClass(String sourceClassString) {
        Class<?> sourceClass = null;
        try {
            sourceClass = Class.forName(sourceClassString);
        }
        catch (ClassNotFoundException ex) {
            Class clazz = null;
            return clazz;
        }
        return this.getClassForClass(sourceClass, this._pageableFactories, RETURN_PAGEABLE_FACTORY_CLASS);
    }

    public Class getPageableFactoryClassForClass(Class sourceClass) {
        return this.getClassForClass(sourceClass, this._pageableFactories, RETURN_PAGEABLE_FACTORY_CLASS);
    }

    public Class getRegisteredAssignableClass(String sourceClassString) {
        Class<?> sourceClass = null;
        try {
            sourceClass = Class.forName(sourceClassString);
        }
        catch (ClassNotFoundException ex) {
            Class clazz = null;
            return clazz;
        }
        return this.getClassForClass(sourceClass, this._pageableFactories, RETURN_SOURCE_CLASS);
    }

    public Class getRegisteredAssignableClass(Class sourceClass) {
        return this.getClassForClass(sourceClass, this._pageableFactories, RETURN_SOURCE_CLASS);
    }

    public PageableFactory getPageableFactory(Object object) {
        int position = this.findFactoryClassPairForClass(object.getClass(), this._pageableFactories, ASSIGNABLE_FROM_MATCH);
        if (position != -1) {
            FactoryClassPair factoryClassPair = (FactoryClassPair)this._pageableFactories.get(position);
            try {
                PageableFactory pageableFactory;
                Class pageableFactoryClass = factoryClassPair.getFactoryClass();
                PageableFactory pageableFactory2 = pageableFactory = (PageableFactory)pageableFactoryClass.newInstance();
                return pageableFactory2;
            }
            catch (IllegalAccessException ex) {
            }
            catch (InstantiationException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean registerDocumentPrintFactory(String viewClassString, String documentPrintFactoryClassString) {
        Class<?> sourceClass = null;
        Class<?> factoryClass = null;
        try {
            sourceClass = Class.forName(viewClassString);
            factoryClass = Class.forName(documentPrintFactoryClassString);
            if (factoryClass.getSuperclass() != DocumentPrintFactory.class) {
                boolean bl = false;
                return bl;
            }
        }
        catch (ClassNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        return this.registerDocumentPrintFactory(sourceClass, factoryClass);
    }

    public boolean registerDocumentPrintFactory(Class viewClass, Class documentPrintFactoryClass) {
        if (this.findFactoryClassPairForClass(viewClass, this._documentPrintFactories, EXACT_MATCH) == -1) {
            this.registerFactory(viewClass, documentPrintFactoryClass, this._documentPrintFactories);
        }
        return true;
    }

    public void unregisterDocumentPrintFactory(String viewClassString) {
        this.unregisterFactory(viewClassString, this._documentPrintFactories);
    }

    public void unregisterDocumentPrintFactory(Class viewClass) {
        this.unregisterFactory(viewClass, this._documentPrintFactories);
    }

    public DocumentPrintFactory getDocumentPrintFactory(Class viewClass) {
        int position = this.findFactoryClassPairForClass(viewClass, this._documentPrintFactories, ASSIGNABLE_FROM_MATCH);
        if (position != -1) {
            FactoryClassPair factoryClassPair = (FactoryClassPair)this._documentPrintFactories.get(position);
            try {
                DocumentPrintFactory documentPrintFactory;
                Class documentPrintFactoryClass = factoryClassPair.getFactoryClass();
                DocumentPrintFactory documentPrintFactory2 = documentPrintFactory = (DocumentPrintFactory)documentPrintFactoryClass.newInstance();
                return documentPrintFactory2;
            }
            catch (IllegalAccessException ex) {
            }
            catch (InstantiationException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFactory(Class sourceClass, Class factoryClass, ArrayList searchList, int insertAtPosition) {
        FactoryClassPair factoryClassPair = new FactoryClassPair(sourceClass, factoryClass);
        if (insertAtPosition < 0) {
            insertAtPosition = 0;
        }
        if (insertAtPosition < searchList.size()) {
            ArrayList arrayList = searchList;
            synchronized (arrayList) {
                searchList.add(insertAtPosition, factoryClassPair);
            }
        }
        ArrayList arrayList = searchList;
        synchronized (arrayList) {
            searchList.add(factoryClassPair);
        }
    }

    private void registerFactory(Class sourceClass, Class factoryClass, ArrayList searchList) {
        this.registerFactory(sourceClass, factoryClass, searchList, INSERT_START);
    }

    private void unregisterFactory(String sourceClassString, ArrayList searchList) {
        Class<?> sourceClass = null;
        try {
            sourceClass = Class.forName(sourceClassString);
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        this.unregisterFactory(sourceClass, searchList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFactory(Class sourceClass, ArrayList searchList) {
        int position = this.findFactoryClassPairForClass(sourceClass, searchList, EXACT_MATCH);
        if (position != -1) {
            ArrayList arrayList = searchList;
            synchronized (arrayList) {
                searchList.remove(position);
            }
        }
    }

    private int findFactoryClassPairForClass(Class objectClass, ArrayList searchList, int matchType) {
        int i = 0;
        while (i < searchList.size()) {
            FactoryClassPair factoryClassPair = (FactoryClassPair)searchList.get(i);
            Class sourceClass = factoryClassPair.getSourceClass();
            if (matchType == EXACT_MATCH) {
                if (sourceClass == objectClass) {
                    return i;
                }
            } else if (matchType == ASSIGNABLE_FROM_MATCH) {
                if (sourceClass.isAssignableFrom(objectClass)) {
                    return i;
                }
            } else {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    private Class getClassForClass(Class sourceClass, ArrayList searchList, int returnClassId) {
        int position = this.findFactoryClassPairForClass(sourceClass, searchList, ASSIGNABLE_FROM_MATCH);
        if (position == -1) {
            return null;
        }
        FactoryClassPair factoryClassPair = (FactoryClassPair)searchList.get(position);
        if (returnClassId == RETURN_PAGEABLE_FACTORY_CLASS) {
            return factoryClassPair.getFactoryClass();
        }
        if (returnClassId == RETURN_SOURCE_CLASS) {
            return factoryClassPair.getSourceClass();
        }
        return null;
    }

    public class FactoryClassPair {
        private Class _sourceClass;
        private Class _factoryClass;

        public FactoryClassPair(Class sourceClass, Class factoryClass) {
            this._sourceClass = sourceClass;
            this._factoryClass = factoryClass;
        }

        public Class getSourceClass() {
            return this._sourceClass;
        }

        public Class getFactoryClass() {
            return this._factoryClass;
        }
    }
}

