/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.print.FactoryRegistry;
import oracle.ideimpl.print.PrintThread;

public class PrintManagerImpl
extends PrintManager
implements Controller,
Addin {
    private PageFormat mPageFormat;
    private int mPrintThreadCount;
    private FactoryRegistry mFactoryRegistry;
    private PrinterJob mPrinterJob;
    private Printable mPrintable;
    private Pageable mPageable;
    private Pageable[] mPageables;
    private PrintRequestAttributeSet mPrintRequestAttributeSet;

    private void $init$() {
        this.mPageFormat = new PageFormat();
        this.mPrintThreadCount = 0;
        this.mFactoryRegistry = new FactoryRegistry();
    }

    public PrintManagerImpl() {
        this.$init$();
        this.mFactoryRegistry.registerPageableFactory("oracle.ide.model.TextNode", "oracle.ide.ceditor.EditorPageableFactory");
    }

    public void initialize() {
        PrintManager.setPrintManager((PrintManager)this);
        Menubar menuMgr = Ide.getMenubar();
        JMenu fileMenu = MenuManager.getJMenu((String)"File");
        menuMgr.add((Component)this.createPrinterSetupMenuItem(), fileMenu, MenuConstants.SECTION_FILE_PRINT);
        menuMgr.add((Component)this.createPrinterMenuItem(), fileMenu, MenuConstants.SECTION_FILE_PRINT);
    }

    private JMenuItem createPrinterSetupMenuItem() {
        return IdeMenus.createMenuItem(this, 15, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString((int)363), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger((int)345), IdeArb.getInstance(), 434, null, true, MenuConstants.WEIGHT_FILE_PAGE_SETUP);
    }

    private JMenuItem createPrinterMenuItem() {
        return IdeMenus.createMenuItem(this, 16, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString((int)400), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger((int)412), IdeArb.getInstance(), 69, null, false, MenuConstants.WEIGHT_FILE_PRINT);
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.mPrintable = printable;
        this.mPageFormat = pageFormat;
    }

    public void setPageable(Pageable pageable) {
        this.mPageable = pageable;
    }

    public void setPageables(Pageable[] pageables) {
        this.mPageables = pageables;
    }

    public boolean registerDocumentPrintFactory(Class viewClass, Class documentPrintFactoryClass) {
        return this.mFactoryRegistry.registerDocumentPrintFactory(viewClass, documentPrintFactoryClass);
    }

    public void unregisterDocumentPrintFactory(Class viewClass) {
        this.mFactoryRegistry.unregisterDocumentPrintFactory(viewClass);
    }

    public Pageable createPageableForObject(Object object) {
        PageableFactory pageableFactory = this.mFactoryRegistry.getPageableFactory(object);
        if (pageableFactory != null) {
            Pageable pageable = pageableFactory.create(object, this.mPageFormat);
            pageableFactory = null;
            return pageable;
        }
        return null;
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public void setPageFormat(PageFormat parPageFormat) {
        this.mPageFormat = parPageFormat;
    }

    void incrementPrintThread() {
        ++this.mPrintThreadCount;
    }

    void decrementPrintThread() {
        --this.mPrintThreadCount;
    }

    private void showPageDialog() {
        if (!this.hasPrintServices()) {
            return;
        }
        if (this.mPrinterJob == null) {
            this.mPrinterJob = PrinterJob.getPrinterJob();
        }
        if (this.mPrintRequestAttributeSet == null) {
            this.mPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        this.mPageFormat = this.mPrinterJob.pageDialog(this.mPrintRequestAttributeSet);
    }

    private boolean hasPrintServices() {
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        if (printServices == null || printServices.length == 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), IdeArb.getString((int)203), IdeArb.getString((int)64), 0);
            return false;
        }
        return true;
    }

    private void print(Context context) {
        if (!this.hasPrintServices()) {
            return;
        }
        1 worker = new 1(this, context);
        worker.start();
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            boolean enabled = false;
            if (context == null) {
                enabled = false;
            } else {
                DocumentPrintFactory documentPrintFactory = this.mFactoryRegistry.getDocumentPrintFactory(context.getView().getClass());
                if (documentPrintFactory == null) {
                    enabled = false;
                } else if (documentPrintFactory.isPrintingEnabled(context)) {
                    enabled = true;
                    documentPrintFactory = null;
                } else {
                    enabled = false;
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 15) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            this.print(context);
            return true;
        }
        if (cmdId == 15) {
            WaitCursor wc = Ide.getWaitCursor();
            2 worker = new 2(this, wc, context);
            worker.start();
            return true;
        }
        return false;
    }

    static void mav$showPageDialog(PrintManagerImpl printManagerImpl) {
        printManagerImpl.showPageDialog();
    }

    static PrinterJob ra$mPrinterJob(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPrinterJob;
    }

    static void wa$mPrinterJob(PrintManagerImpl printManagerImpl, PrinterJob printerJob) {
        printManagerImpl.mPrinterJob = printerJob;
    }

    static void wa$mPrintable(PrintManagerImpl printManagerImpl, Printable printable) {
        printManagerImpl.mPrintable = printable;
    }

    static void wa$mPageable(PrintManagerImpl printManagerImpl, Pageable pageable) {
        printManagerImpl.mPageable = pageable;
    }

    static void wa$mPageables(PrintManagerImpl printManagerImpl, Pageable[] pageableArray) {
        printManagerImpl.mPageables = pageableArray;
    }

    static FactoryRegistry ra$mFactoryRegistry(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mFactoryRegistry;
    }

    static Printable ra$mPrintable(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPrintable;
    }

    static Pageable ra$mPageable(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPageable;
    }

    static Pageable[] ra$mPageables(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPageables;
    }

    static PageFormat ra$mPageFormat(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPageFormat;
    }

    static PrintRequestAttributeSet ra$mPrintRequestAttributeSet(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPrintRequestAttributeSet;
    }

    static void wa$mPrintRequestAttributeSet(PrintManagerImpl printManagerImpl, PrintRequestAttributeSet printRequestAttributeSet) {
        printManagerImpl.mPrintRequestAttributeSet = printRequestAttributeSet;
    }

    static void wa$mPageFormat(PrintManagerImpl printManagerImpl, PageFormat pageFormat) {
        printManagerImpl.mPageFormat = pageFormat;
    }

    final class 1
    extends SwingWorker {
        private final /* synthetic */ Context v$context;
        final /* synthetic */ PrintManagerImpl this$0;

        public Object construct() {
            DocumentPrintFactory documentPrintFactory;
            if (PrintManagerImpl.ra$mPrinterJob(this.this$0) == null) {
                PrintManagerImpl.wa$mPrinterJob(this.this$0, PrinterJob.getPrinterJob());
            }
            PrintManagerImpl.wa$mPrintable(this.this$0, null);
            PrintManagerImpl.wa$mPageable(this.this$0, null);
            PrintManagerImpl.wa$mPageables(this.this$0, null);
            Node locatable = this.v$context.getNode();
            if (locatable != null) {
                PrintManagerImpl.ra$mPrinterJob(this.this$0).setJobName(URLFileSystem.getPlatformPathName((URL)locatable.getURL()));
            }
            if ((documentPrintFactory = PrintManagerImpl.ra$mFactoryRegistry(this.this$0).getDocumentPrintFactory(this.v$context.getView().getClass())) == null) {
                return null;
            }
            documentPrintFactory.create(this.v$context);
            if (PrintManagerImpl.ra$mPrintable(this.this$0) != null || PrintManagerImpl.ra$mPageable(this.this$0) != null || PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                if (PrintManagerImpl.ra$mPrintable(this.this$0) != null) {
                    PrintManagerImpl.ra$mPrinterJob(this.this$0).setPrintable(PrintManagerImpl.ra$mPrintable(this.this$0), PrintManagerImpl.ra$mPageFormat(this.this$0));
                } else if (PrintManagerImpl.ra$mPageable(this.this$0) != null) {
                    PrintManagerImpl.ra$mPrinterJob(this.this$0).setPageable(PrintManagerImpl.ra$mPageable(this.this$0));
                } else if (PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                    PrintManagerImpl.ra$mPrinterJob(this.this$0).setPageable(PrintManagerImpl.ra$mPageables(this.this$0)[0]);
                }
            }
            if (PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0) == null) {
                PrintManagerImpl.wa$mPrintRequestAttributeSet(this.this$0, new HashPrintRequestAttributeSet());
            }
            if (PrintManagerImpl.ra$mPrinterJob(this.this$0).printDialog(PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0))) {
                if (PrintManagerImpl.ra$mPageFormat(this.this$0) == null) {
                    PrintManagerImpl.wa$mPageFormat(this.this$0, new PageFormat());
                }
                int beginOrientation = PrintManagerImpl.ra$mPageFormat(this.this$0).getOrientation();
                OrientationRequested req = (OrientationRequested)PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0).get(OrientationRequested.class);
                if (req != null) {
                    if (req == OrientationRequested.LANDSCAPE && beginOrientation != 0) {
                        PrintManagerImpl.ra$mPageFormat(this.this$0).setOrientation(0);
                        documentPrintFactory.create(this.v$context);
                    } else if ((req == OrientationRequested.PORTRAIT || req == OrientationRequested.REVERSE_PORTRAIT) && beginOrientation != 1) {
                        PrintManagerImpl.ra$mPageFormat(this.this$0).setOrientation(1);
                        documentPrintFactory.create(this.v$context);
                    } else if (req == OrientationRequested.REVERSE_LANDSCAPE && beginOrientation != 2) {
                        PrintManagerImpl.ra$mPageFormat(this.this$0).setOrientation(2);
                        documentPrintFactory.create(this.v$context);
                    }
                }
                if (PrintManagerImpl.ra$mPrintable(this.this$0) != null || PrintManagerImpl.ra$mPageable(this.this$0) != null || PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                    Thread printThread = null;
                    if (PrintManagerImpl.ra$mPrintable(this.this$0) != null) {
                        printThread = new PrintThread(PrintManagerImpl.ra$mPrintable(this.this$0), PrintManagerImpl.ra$mPrinterJob(this.this$0), PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0));
                    } else if (PrintManagerImpl.ra$mPageable(this.this$0) != null) {
                        printThread = new PrintThread(PrintManagerImpl.ra$mPageable(this.this$0), PrintManagerImpl.ra$mPrinterJob(this.this$0), PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0));
                    } else if (PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                        printThread = new PrintThread(PrintManagerImpl.ra$mPageables(this.this$0), PrintManagerImpl.ra$mPrinterJob(this.this$0), PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0));
                    }
                    printThread.setPriority(printThread.getPriority() - 1);
                    printThread.start();
                }
            } else {
                PrintManagerImpl.wa$mPrintable(this.this$0, null);
                PrintManagerImpl.wa$mPageable(this.this$0, null);
                PrintManagerImpl.wa$mPageables(this.this$0, null);
            }
            return null;
        }

        public void finished() {
            View aView = this.v$context.getView();
            if (aView != null) {
                aView.getGUI().requestFocusInWindow();
            }
        }

        public 1(PrintManagerImpl printManagerImpl, Context context) {
            this.v$context = context;
            this.this$0 = printManagerImpl;
        }
    }

    final class 2
    extends SwingWorker {
        private final /* synthetic */ WaitCursor v$wc;
        private final /* synthetic */ Context v$context;
        final /* synthetic */ PrintManagerImpl this$0;

        public Object construct() {
            this.v$wc.show(400);
            PrintManagerImpl.mav$showPageDialog(this.this$0);
            return this;
        }

        public void finished() {
            View aView;
            this.v$wc.hide();
            if (this.v$context != null && (aView = this.v$context.getView()) != null) {
                aView.getGUI().requestFocusInWindow();
            }
        }

        public 2(PrintManagerImpl printManagerImpl, WaitCursor waitCursor, Context context) {
            this.v$context = context;
            this.v$wc = waitCursor;
            this.this$0 = printManagerImpl;
        }
    }
}

