/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.shell;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.config.FileAssociations;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.shell.ConfigureFileAssociationsDialog;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellIntegration
implements Addin {
    private static final String OPEN_COMMAND = "Open\\(\\(?\"(.*)\"\\)\\)?";
    private static boolean isMainWindowOpen;
    private static LinkedList commandQueue;
    private static Registry registry;

    public static void runCommand(String command) {
        SwingUtilities.invokeLater(new 1(command));
    }

    public void initialize() {
        if (Ide.getIdeArgs().getCreateUI() && System.getProperty("ide.shell.enableFileTypeAssociation") != null) {
            Ide.addIdeListener((IdeListener)new 2());
        }
    }

    private void showConfigurationDialog(String productName, ArrayList<String> suffixes, ArrayList<String> labels) {
        if (System.getProperty("ide.shell.enableFileTypeAssociation") != null && ShellIntegration.getCurrentUserKey() != null && productName != null && !this.isFileTypeDefined(productName, suffixes.get(0))) {
            this.addFileTypeKeys(productName, suffixes);
            if (!Ide.getIdeArgs().hasArg("-nonag")) {
                new ConfigureFileAssociationsDialog(productName, suffixes, labels);
            }
        }
    }

    private boolean isFileTypeDefined(String productName, String suffix) {
        if (PlatformUtils.isAtLeastWindowsVista()) {
            return FileAssociations.isAssociated((String)suffix);
        }
        String keyName = productName + suffix + "File";
        try {
            RegistryKey root = registry.getClassesRootKey();
            RegistryKey key = root.openKey(keyName, 983103L);
            if (key != null) {
                key.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (RegistryException e) {
            // empty catch block
        }
        return false;
    }

    private void addFileTypeKeys(String productName, ArrayList<String> suffixes) {
        String data = "\"" + FileAssociations.getExePathName() + "\"";
        try {
            RegistryKey lroot = registry.getLocalMachineKey();
            RegistryKey croot = registry.getClassesRootKey();
            int i = 0;
            while (i < suffixes.size()) {
                String prefix = "SOFTWARE\\Classes\\";
                String keyName = productName + suffixes.get(i) + "File\\Shell\\Open\\Command";
                RegistryKey key = lroot.createKey(prefix + keyName, false, 131078L);
                if (key != null) {
                    key.setExpandedStringValue("", data);
                    key.close();
                }
                if ((key = croot.createKey(keyName, false, 131078L)) != null) {
                    key.setExpandedStringValue("", data);
                    key.close();
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static RegistryKey getCurrentUserKey() {
        try {
            registry = new Registry();
            RegistryKey registryKey = registry.getCurrentUserKey();
            return registryKey;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return null;
    }

    private void processQueue() {
        isMainWindowOpen = true;
        for (String command : commandQueue) {
            ShellIntegration.processCommand(command);
        }
        commandQueue.clear();
    }

    private static void processCommand(String command) {
        Pattern pattern = Pattern.compile(OPEN_COMMAND);
        Matcher matcher = pattern.matcher(command);
        if (matcher.matches()) {
            ShellIntegration.openFile(matcher.group(1));
        }
    }

    private static void openFile(String file) {
        IdeMainWindow mw = Ide.getMainWindow();
        int state = mw.getExtendedState();
        if ((state & 1) != 0) {
            mw.setExtendedState(state & 0xFFFFFFFE);
        }
        mw.toFront();
        URL url = URLFactory.newFileURL((String)file);
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            OpenCommand cmd = new OpenCommand();
            cmd.setContext(Context.newIdeContext((Node)node));
            cmd.openURL(url);
        }
        catch (Exception e) {
            Logger.getLogger(ShellIntegration.class.getName()).log(Level.SEVERE, "", e);
        }
    }

    static {
        commandQueue = new LinkedList();
    }

    static void mav$showConfigurationDialog(ShellIntegration shellIntegration, String string, ArrayList arrayList, ArrayList arrayList2) {
        shellIntegration.showConfigurationDialog(string, arrayList, arrayList2);
    }

    static void mav$processQueue(ShellIntegration shellIntegration) {
        shellIntegration.processQueue();
    }

    static boolean ra$isMainWindowOpen() {
        return isMainWindowOpen;
    }

    static void maS$processCommand(String string) {
        ShellIntegration.processCommand(string);
    }

    static LinkedList ra$commandQueue() {
        return commandQueue;
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ String v$command;

        public void run() {
            if (ShellIntegration.ra$isMainWindowOpen()) {
                ShellIntegration.maS$processCommand(this.v$command);
            } else {
                ShellIntegration.ra$commandQueue().add(this.v$command);
            }
        }

        public 1(String string) {
            this.v$command = string;
        }
    }

    final class 2
    implements IdeListener {
        public void addinsLoaded(IdeEvent e) {
        }

        public void mainWindowOpened(IdeEvent e) {
            ProductInformation productInfo = ProductInformation.getProductInformation();
            String productName = productInfo.getShortName();
            ArrayList<String> suffixes = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            List fileAssocs = productInfo.getHashStructure().getAsList("file-association");
            if (fileAssocs != null && fileAssocs.size() > 0) {
                for (HashStructure hash : fileAssocs) {
                    suffixes.add(hash.getString("suffix"));
                    labels.add(hash.getString("label"));
                }
            }
            if (suffixes.size() > 0) {
                ShellIntegration.mav$showConfigurationDialog(ShellIntegration.this, productName, suffixes, labels);
            }
            ShellIntegration.mav$processQueue(ShellIntegration.this);
        }

        public void mainWindowClosing(IdeEvent e) {
        }
    }
}

