/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideimpl.window.WindowFlatWindows;
import oracle.ideri.util.Product;

public final class WindowManagerImpl
implements MenuListener,
Controller,
Addin {
    public static final float WEIGHT_WINDOW_MENU = MenuConstants.WEIGHT_TOOLS_MENU + 1.0f;
    public static final float SECTION_WINDOW_SPLITS = 1.0f;
    public static final float SECTION_WINDOW_GOTO = 2.0f;
    public static final float SECTION_WINDOW_ADDINS = 3.0f;
    public static final float SECTION_WINDOW_WINDOW_LIST = 4.0f;
    public static final float SECTION_WINDOW_WINDOWS = 5.0f;

    public void initialize() {
        this.createActions();
        if (!Product.isRaptor()) {
            Menubar menuMgr = Ide.getMenubar();
            JMenu windowMenu = menuMgr.createMenu(IdeArb.getString((int)421), IdeArb.getInteger((int)6), WEIGHT_WINDOW_MENU, 3.0f);
            windowMenu.addMenuListener(this);
            menuMgr.add((Component)windowMenu);
            MenuManager.putJMenu((String)"Window", (JMenu)windowMenu);
        }
    }

    private void createActions() {
        AddinManager addMgr = AddinManager.getAddinManager();
        IdeAction actionNextWindow = IdeAction.get((int)42, (String)addMgr.getCommand(42, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)396), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)IdeArb.getInteger((int)149), (ArrayResourceBundle)IdeArb.getInstance(), (int)338, null, (boolean)false);
        actionNextWindow.addController((Controller)this);
        IdeAction actionPrevWindow = IdeAction.get((int)43, (String)addMgr.getCommand(43, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)305), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)IdeArb.getInteger((int)316), (ArrayResourceBundle)IdeArb.getInstance(), (int)347, null, (boolean)false);
        actionPrevWindow.addController((Controller)this);
        IdeAction actionWindowsDotDotDot = IdeAction.get((int)61, (String)addMgr.getCommand(61, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)477), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)IdeArb.getInteger((int)410), null, null, (boolean)false);
        actionWindowsDotDotDot.addController((Controller)this);
        actionWindowsDotDotDot.setEnabled(true);
    }

    private Controller getController(Context context) {
        View view = context.getView();
        Component c = view.getGUI();
        if (SwingUtilities.getAncestorOfClass(TitledPanel.class, c) != null) {
            return DockStation.getDockStation();
        }
        return EditorManager.getEditorManager();
    }

    private void whenWindowsDotDotDot() {
        WindowFlatWindows.runDialog((Frame)Ide.getMainWindow());
        EditorManager.getEditorManager().activateCurrentEditorFrame();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: 
            case 43: {
                this.getController(context).handleEvent(action, context);
                break;
            }
            case 61: {
                this.whenWindowsDotDotDot();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: 
            case 43: {
                this.getController(context).update(action, context);
                break;
            }
            case 61: {
                Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                boolean hasEditorOpen = currentEditor != null;
                action.setEnabled(hasEditorOpen);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void fillWindowMenu(JMenu windowMenu) {
        Menubar menuMgr = Ide.getMenubar();
        windowMenu.removeAll();
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID)), windowMenu, 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.UNSPLIT_DOCUMENT_CMD_ID)), windowMenu, 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.DETACH_DOCUMENT_CMD_ID)), windowMenu, 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID)), windowMenu, 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.SYSTEM_MENU_CMD_ID)), windowMenu, 2.0f);
        JMenu menuGoTo = this.fillGoToMenu(menuMgr);
        menuMgr.add((Component)menuGoTo, windowMenu, 2.0f);
        JMenu menuAssign = this.fillAssignMenu(menuMgr);
        menuMgr.add((Component)menuAssign, windowMenu, 2.0f);
        EditorManagerImpl em = (EditorManagerImpl)EditorManager.getEditorManager();
        List windowList = em.getWindowList();
        int n = windowList.size();
        if (n != 0) {
            int i = 0;
            while (i < n) {
                JMenuItem item = (JMenuItem)windowList.get(i);
                menuMgr.add((Component)item, windowMenu, 4.0f);
                ++i;
            }
        }
        IdeAction windowDotDotDotAction = IdeAction.find((int)61);
        JMenuItem menuWindowsDotDotDot = menuMgr.createMenuItem((ToggleAction)windowDotDotDotAction);
        menuMgr.add((Component)menuWindowsDotDotDot, windowMenu, 5.0f);
    }

    private JMenu fillGoToMenu(Menubar menuMgr) {
        float section = 1.0f;
        String gotoString = IdeImplArb.getString(27);
        String gotoLabel = StringUtils.stripMnemonic((String)gotoString);
        Integer gotoMnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)gotoString));
        JMenu menuGoTo = menuMgr.createSubMenu(gotoLabel, gotoMnemonic);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID)), menuGoTo, section);
        JMenuItem nextEditorFrameMenuItem = menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)42));
        menuMgr.add((Component)nextEditorFrameMenuItem, menuGoTo, section += 1.0f);
        JMenuItem prevEditorFrameMenuItem = menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)43));
        menuMgr.add((Component)prevEditorFrameMenuItem, menuGoTo, section);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)70)), menuGoTo, section += 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)71)), menuGoTo, section);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.NEXT_PANE_CMD_ID)), menuGoTo, section += 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.PREV_PANE_CMD_ID)), menuGoTo, section);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)41)), menuGoTo, section += 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)40)), menuGoTo, section);
        return menuGoTo;
    }

    private JMenu fillAssignMenu(Menubar menuMgr) {
        float section = 1.0f;
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        String assignString = IdeImplArb.getString(23);
        String assignLabel = StringUtils.stripMnemonic((String)assignString);
        Integer mnemonic = StringUtils.getMnemonicKeyCode((String)assignString);
        JMenu menuAssign = menuMgr.createSubMenu(assignLabel, mnemonic);
        int i = 0;
        while (i < 9) {
            int assignCmdId = editorManager.getAssignCmdId(i);
            IdeAction action = IdeAction.find((int)assignCmdId);
            JMenuItem assignMenuItem = menuMgr.createMenuItem((ToggleAction)action);
            menuMgr.add((Component)assignMenuItem, menuAssign, section);
            ++i;
        }
        return menuAssign;
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        this.fillWindowMenu(MenuManager.getJMenu((String)"Window"));
    }
}

