/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ide.model.Displayable;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableHeaderRenderer;

public abstract class WindowSelector {
    private static final KeyModifierTracker KEY_MODIFIER_TRACKER;
    private SelectionWindow _selectionWindow;
    private EventHandler _eventHandler;
    private Displayable[] _displayables;
    private int _selectedIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected WindowSelector() {
    }

    protected abstract Displayable[] getDisplayables();

    protected abstract void activateSelectedWindow();

    protected void selectNextItem() {
        if (this._displayables == null) {
            this._selectedIndex = 0;
            this._displayables = this.getDisplayables();
        }
        ++this._selectedIndex;
        if (this._selectedIndex >= this._displayables.length) {
            this._selectedIndex = 0;
        }
        this.updateSelection();
    }

    protected void selectPreviousItem() {
        if (this._displayables == null) {
            this._selectedIndex = 0;
            this._displayables = this.getDisplayables();
        }
        --this._selectedIndex;
        if (this._selectedIndex < 0) {
            this._selectedIndex = this._displayables.length - 1;
        }
        this.updateSelection();
    }

    protected void dispose() {
        this._displayables = null;
        if (this._selectionWindow != null) {
            Window owner = this._selectionWindow.getOwner();
            this._selectionWindow.dispose();
            this._selectionWindow = null;
            owner.removeComponentListener(this._eventHandler);
            owner.removeWindowListener(this._eventHandler);
            owner.removeWindowFocusListener(this._eventHandler);
            owner.removeWindowStateListener(this._eventHandler);
            GlobalMouseDispatcher.getInstance().removeMouseListener((MouseListener)this._eventHandler);
            this._eventHandler = null;
        }
    }

    protected int getSelectedIndex() {
        return this._selectedIndex;
    }

    protected int getKeyModifiers() {
        return KEY_MODIFIER_TRACKER.getModifiers();
    }

    static {
        $assertionsDisabled = WindowSelector.class.desiredAssertionStatus() ^ true;
        KEY_MODIFIER_TRACKER = KeyModifierTracker.getInstance();
    }

    private SelectionWindow getSelectionWindow() {
        if (this._selectionWindow == null) {
            if (!$assertionsDisabled && this._displayables == null) {
                throw new AssertionError();
            }
            IdeMainWindow mainWindow = Ide.getMainWindow();
            this._eventHandler = new EventHandler(this);
            mainWindow.addComponentListener(this._eventHandler);
            mainWindow.addWindowListener(this._eventHandler);
            mainWindow.addWindowFocusListener(this._eventHandler);
            mainWindow.addWindowStateListener(this._eventHandler);
            GlobalMouseDispatcher.getInstance().addMouseListener((MouseListener)this._eventHandler);
            this._selectionWindow = SelectionWindow.createWindow((JFrame)mainWindow, this._displayables);
            this._selectionWindow.setVisible(true);
            this._selectionWindow.getContentPane().repaint();
            KEY_MODIFIER_TRACKER.setPostProcessor(this._eventHandler);
        }
        return this._selectionWindow;
    }

    private void updateSelection() {
        if (this.getKeyModifiers() == 0) {
            this.activateSelectedWindow();
        } else {
            this.getSelectionWindow().setSelectedIndex(this._selectedIndex);
        }
    }

    private void selectWindow(MouseEvent e) {
        if (this._selectionWindow != null) {
            this._selectedIndex = this._selectionWindow.getSelectedIndex(e);
            if (this._selectedIndex >= 0) {
                this.activateSelectedWindow();
            }
        }
    }

    static void mav$selectWindow(WindowSelector windowSelector, MouseEvent mouseEvent) {
        windowSelector.selectWindow(mouseEvent);
    }

    private static final class KeyModifierTracker
    implements AWTEventListener {
        private static final KeyModifierTracker INSTANCE = new KeyModifierTracker();
        private static final int MODIFIER_MASK = 910;
        private Runnable _postProcessor;
        private int _keyModifiers;

        private KeyModifierTracker() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addAWTEventListener(this, 8);
        }

        public static KeyModifierTracker getInstance() {
            return INSTANCE;
        }

        public int getModifiers() {
            return this._keyModifiers;
        }

        public void setPostProcessor(Runnable postProcessor) {
            this._postProcessor = postProcessor;
        }

        public void eventDispatched(AWTEvent e) {
            KeyEvent keyEvent = (KeyEvent)e;
            int eventID = keyEvent.getID();
            if (eventID == 401 || eventID == 402) {
                this._keyModifiers = keyEvent.getModifiers() & 0x38E;
                if (this._keyModifiers == 0 && this._postProcessor != null) {
                    SwingUtilities.invokeLater(this._postProcessor);
                    this._postProcessor = null;
                }
            }
        }
    }

    private static final class EventHandler
    implements Runnable,
    ComponentListener,
    MouseListener,
    WindowListener,
    WindowFocusListener,
    WindowStateListener {
        private final WindowSelector _windowSelector;

        EventHandler(WindowSelector windowSelector) {
            this._windowSelector = windowSelector;
        }

        public void run() {
            this._windowSelector.activateSelectedWindow();
        }

        public void componentHidden(ComponentEvent e) {
            this.dispose();
        }

        public void componentMoved(ComponentEvent e) {
            this.dispose();
        }

        public void componentResized(ComponentEvent e) {
            this.dispose();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            WindowSelector.mav$selectWindow(this._windowSelector, e);
            this.dispose();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            this.dispose();
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
            this.dispose();
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowStateChanged(WindowEvent e) {
            this.dispose();
        }

        private void dispose() {
            this._windowSelector.dispose();
        }
    }

    private static final class SelectionWindow
    extends JWindow {
        private static final Border CELL_BORDER;
        private final NiceTable _table;
        static final /* synthetic */ boolean $assertionsDisabled;

        public static SelectionWindow createWindow(JFrame owner, Displayable[] displayables) {
            SelectionWindow window = new SelectionWindow(owner, displayables);
            window.pack();
            GraphicsUtils.centerWindowOnComponent((Window)window, (Component)owner);
            return window;
        }

        static {
            $assertionsDisabled = SelectionWindow.class.desiredAssertionStatus() ^ true;
            CELL_BORDER = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        }

        private SelectionWindow(JFrame owner, Displayable[] displayables) {
            super(owner);
            if (!$assertionsDisabled && owner == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && displayables.length <= 1) {
                throw new AssertionError();
            }
            SelectionTableModel model = new SelectionTableModel(displayables);
            DisplayableCellRenderer cellRenderer = new DisplayableCellRenderer(null);
            HeaderRenderer headerRenderer = new HeaderRenderer(null);
            this._table = new NiceTable((TableModel)model);
            this._table.setShowGrid(true);
            this._table.setFont(this._table.getFont().deriveFont(1));
            this._table.setDefaultRenderer(Displayable.class, (TableCellRenderer)cellRenderer);
            this._table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)headerRenderer));
            this._table.setRowHeight(this.measureRowHeight(cellRenderer, displayables));
            this._table.autoSizeColumnsToFit();
            Dimension dim = this._table.getPreferredSize();
            this._table.setPreferredScrollableViewportSize(dim);
            JPanel contentPanel = new JPanel(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane((Component)this._table);
            scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
            contentPanel.add((Component)scrollPane, "Center");
            this.setFocusableWindowState(false);
            this.setContentPane(contentPanel);
        }

        void setSelectedIndex(int selectedIndex) {
            this._table.changeSelection(selectedIndex, 0, false, false);
        }

        int getSelectedIndex() {
            return this._table.getSelectedRow();
        }

        int getSelectedIndex(MouseEvent e) {
            int row = e.getComponent() == this._table ? this._table.rowAtPoint(e.getPoint()) : -1;
            this.setSelectedIndex(row);
            return row;
        }

        private int measureRowHeight(TableCellRenderer tcr, Displayable[] displayables) {
            int maxHeight = 0;
            int i = displayables.length;
            while (i-- > 0) {
                Displayable displayable = displayables[i];
                String label = displayable.getShortLabel();
                Component c = tcr.getTableCellRendererComponent((JTable)this._table, displayable, false, false, i, 0);
                int height = (int)c.getPreferredSize().getHeight();
                maxHeight = Math.max(maxHeight, height);
            }
            return maxHeight;
        }

        static Border ra$CELL_BORDER() {
            return CELL_BORDER;
        }

        private static final class SelectionTableModel
        extends AbstractTableModel {
            private static final String[] columns = new String[]{IdeImplArb.getString(1)};
            private final Displayable[] _displayables;

            public SelectionTableModel(Displayable[] displayables) {
                this._displayables = displayables;
            }

            public int getColumnCount() {
                return columns.length;
            }

            public String getColumnName(int col) {
                return columns[col];
            }

            public int getRowCount() {
                return this._displayables != null ? this._displayables.length : 0;
            }

            public Object getValueAt(int row, int col) {
                return this._displayables[row];
            }

            public Class getColumnClass(int col) {
                return Displayable.class;
            }
        }

        private static final class HeaderRenderer
        extends NiceTableHeaderRenderer {
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBorder(SelectionWindow.ra$CELL_BORDER());
                return this;
            }

            private HeaderRenderer() {
            }

            HeaderRenderer(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }

        private static final class DisplayableCellRenderer
        extends DefaultTableCellRenderer {
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Displayable) {
                    Displayable d = (Displayable)value;
                    this.setIcon(d.getIcon());
                    this.setText(d.getShortLabel());
                    this.setToolTipText(d.getLongLabel());
                }
                this.setBorder(SelectionWindow.ra$CELL_BORDER());
                return this;
            }

            private DisplayableCellRenderer() {
            }

            DisplayableCellRenderer(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

