/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el;

import com.sun.el.lang.ELSupport;
import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;

public class MethodExpressionLiteral
extends MethodExpression
implements Externalizable {
    private Class expectedType;
    private String expr;
    private Class[] paramTypes;

    public MethodExpressionLiteral() {
    }

    public MethodExpressionLiteral(String string, Class clazz, Class[] classArray) {
        this.expr = string;
        this.expectedType = clazz;
        this.paramTypes = classArray;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) throws ELException {
        return new MethodInfo(this.expr, this.expectedType, this.paramTypes);
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) throws ELException {
        if (this.expectedType != null) {
            return ELSupport.coerceToType(this.expr, this.expectedType);
        }
        return this.expr;
    }

    public String getExpressionString() {
        return this.expr;
    }

    public boolean equals(Object object) {
        return object instanceof MethodExpressionLiteral && this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public boolean isLiteralText() {
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.expr = objectInput.readUTF();
        String string = objectInput.readUTF();
        if (!"".equals(string)) {
            this.expectedType = ReflectionUtil.forName(string);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])objectInput.readObject());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.expr);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        objectOutput.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
    }
}

