/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el;

import com.sun.el.lang.ELSupport;
import com.sun.el.util.MessageFactory;
import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

public final class ValueExpressionLiteral
extends ValueExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Object value;
    private Class expectedType;

    public ValueExpressionLiteral() {
    }

    public ValueExpressionLiteral(Object object, Class clazz) {
        this.value = object;
        this.expectedType = clazz;
    }

    public Object getValue(ELContext eLContext) {
        if (this.expectedType != null) {
            return ELSupport.coerceToType(this.value, this.expectedType);
        }
        return this.value;
    }

    public void setValue(ELContext eLContext, Object object) {
        throw new PropertyNotWritableException(MessageFactory.get("error.value.literal.write", this.value));
    }

    public boolean isReadOnly(ELContext eLContext) {
        return true;
    }

    public Class getType(ELContext eLContext) {
        return this.value != null ? this.value.getClass() : null;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.value != null ? this.value.toString() : null;
    }

    public boolean equals(Object object) {
        return object instanceof ValueExpressionLiteral && this.equals((ValueExpressionLiteral)object);
    }

    public boolean equals(ValueExpressionLiteral valueExpressionLiteral) {
        return valueExpressionLiteral != null && this.value != null && valueExpressionLiteral.value != null && (this.value == valueExpressionLiteral.value || this.value.equals(valueExpressionLiteral.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean isLiteralText() {
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.value);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = objectInput.readObject();
        String string = objectInput.readUTF();
        if (!"".equals(string)) {
            this.expectedType = ReflectionUtil.forName(string);
        }
    }
}

