/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.lang;

import com.sun.el.lang.ELSupport;
import com.sun.el.util.MessageFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ELArithmetic {
    public static final BigDecimalDelegate BIGDECIMAL = new BigDecimalDelegate();
    public static final BigIntegerDelegate BIGINTEGER = new BigIntegerDelegate();
    public static final DoubleDelegate DOUBLE = new DoubleDelegate();
    public static final LongDelegate LONG = new LongDelegate();
    private static final Long ZERO = new Long(0L);

    public static final Number add(Object object, Object object2) {
        if (object == null && object2 == null) {
            return new Long(0L);
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? DOUBLE : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return eLArithmetic.add(number, number2);
    }

    public static final Number mod(Object object, Object object2) {
        if (object == null && object2 == null) {
            return new Long(0L);
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? DOUBLE : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return eLArithmetic.mod(number, number2);
    }

    public static final Number subtract(Object object, Object object2) {
        if (object == null && object2 == null) {
            return new Long(0L);
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? DOUBLE : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return eLArithmetic.subtract(number, number2);
    }

    public static final Number divide(Object object, Object object2) {
        if (object == null && object2 == null) {
            return ZERO;
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (BIGINTEGER.matches(object, object2) ? BIGDECIMAL : DOUBLE);
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return eLArithmetic.divide(number, number2);
    }

    public static final Number multiply(Object object, Object object2) {
        if (object == null && object2 == null) {
            return new Long(0L);
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? DOUBLE : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return eLArithmetic.multiply(number, number2);
    }

    public static final boolean isNumber(Object object) {
        return object != null && ELArithmetic.isNumberType(object.getClass());
    }

    public static final boolean isNumberType(Class clazz) {
        return clazz == Long.class || clazz == Long.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Byte.class || clazz == Byte.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    protected ELArithmetic() {
    }

    protected abstract Number add(Number var1, Number var2);

    protected abstract Number multiply(Number var1, Number var2);

    protected abstract Number subtract(Number var1, Number var2);

    protected abstract Number mod(Number var1, Number var2);

    protected abstract Number coerce(Number var1);

    protected final Number coerce(Object object) {
        if (ELArithmetic.isNumber(object)) {
            return this.coerce((Number)object);
        }
        if (object instanceof String) {
            return this.coerce((String)object);
        }
        if (object == null || "".equals(object)) {
            return this.coerce(ZERO);
        }
        Class<?> clazz = object.getClass();
        if (Character.class.equals(clazz) || Character.TYPE == clazz) {
            return this.coerce(new Short((short)((Character)object).charValue()));
        }
        throw new IllegalArgumentException(MessageFactory.get("el.convert", object, clazz));
    }

    protected abstract Number coerce(String var1);

    protected abstract Number divide(Number var1, Number var2);

    protected abstract boolean matches(Object var1, Object var2);

    public static final class LongDelegate
    extends ELArithmetic {
        protected Number add(Number number, Number number2) {
            return new Long(number.longValue() + number2.longValue());
        }

        protected Number coerce(Number number) {
            if (number instanceof Long) {
                return number;
            }
            return new Long(number.longValue());
        }

        protected Number coerce(String string) {
            return new Long(string);
        }

        protected Number divide(Number number, Number number2) {
            return new Long(number.longValue() / number2.longValue());
        }

        protected Number mod(Number number, Number number2) {
            return new Long(number.longValue() % number2.longValue());
        }

        protected Number subtract(Number number, Number number2) {
            return new Long(number.longValue() - number2.longValue());
        }

        protected Number multiply(Number number, Number number2) {
            return new Long(number.longValue() * number2.longValue());
        }

        public boolean matches(Object object, Object object2) {
            return object instanceof Long || object2 instanceof Long;
        }
    }

    public static final class DoubleDelegate
    extends ELArithmetic {
        protected Number add(Number number, Number number2) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).add(new BigDecimal(number2.doubleValue()));
            }
            if (number2 instanceof BigDecimal) {
                return new BigDecimal(number.doubleValue()).add((BigDecimal)number2);
            }
            return new Double(number.doubleValue() + number2.doubleValue());
        }

        protected Number coerce(Number number) {
            if (number instanceof Double) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new Double(number.doubleValue());
        }

        protected Number coerce(String string) {
            return new Double(string);
        }

        protected Number divide(Number number, Number number2) {
            return new Double(number.doubleValue() / number2.doubleValue());
        }

        protected Number mod(Number number, Number number2) {
            return new Double(number.doubleValue() % number2.doubleValue());
        }

        protected Number subtract(Number number, Number number2) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).subtract(new BigDecimal(number2.doubleValue()));
            }
            if (number2 instanceof BigDecimal) {
                return new BigDecimal(number.doubleValue()).subtract((BigDecimal)number2);
            }
            return new Double(number.doubleValue() - number2.doubleValue());
        }

        protected Number multiply(Number number, Number number2) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).multiply(new BigDecimal(number2.doubleValue()));
            }
            if (number2 instanceof BigDecimal) {
                return new BigDecimal(number.doubleValue()).multiply((BigDecimal)number2);
            }
            return new Double(number.doubleValue() * number2.doubleValue());
        }

        public boolean matches(Object object, Object object2) {
            return object instanceof Double || object2 instanceof Double || object instanceof Float || object2 instanceof Float || object != null && (Double.TYPE == object.getClass() || Float.TYPE == object.getClass()) || object2 != null && (Double.TYPE == object2.getClass() || Float.TYPE == object2.getClass()) || object instanceof String && ELSupport.isStringFloat((String)object) || object2 instanceof String && ELSupport.isStringFloat((String)object2);
        }
    }

    public static final class BigIntegerDelegate
    extends ELArithmetic {
        protected Number add(Number number, Number number2) {
            return ((BigInteger)number).add((BigInteger)number2);
        }

        protected Number coerce(Number number) {
            if (number instanceof BigInteger) {
                return number;
            }
            return new BigInteger(number.toString());
        }

        protected Number coerce(String string) {
            return new BigInteger(string);
        }

        protected Number divide(Number number, Number number2) {
            return new BigDecimal((BigInteger)number).divide(new BigDecimal((BigInteger)number2), 4);
        }

        protected Number multiply(Number number, Number number2) {
            return ((BigInteger)number).multiply((BigInteger)number2);
        }

        protected Number mod(Number number, Number number2) {
            return ((BigInteger)number).mod((BigInteger)number2);
        }

        protected Number subtract(Number number, Number number2) {
            return ((BigInteger)number).subtract((BigInteger)number2);
        }

        public boolean matches(Object object, Object object2) {
            return object instanceof BigInteger || object2 instanceof BigInteger;
        }
    }

    public static final class BigDecimalDelegate
    extends ELArithmetic {
        protected Number add(Number number, Number number2) {
            return ((BigDecimal)number).add((BigDecimal)number2);
        }

        protected Number coerce(Number number) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }

        protected Number coerce(String string) {
            return new BigDecimal(string);
        }

        protected Number divide(Number number, Number number2) {
            return ((BigDecimal)number).divide((BigDecimal)number2, 4);
        }

        protected Number subtract(Number number, Number number2) {
            return ((BigDecimal)number).subtract((BigDecimal)number2);
        }

        protected Number mod(Number number, Number number2) {
            return new Double(number.doubleValue() % number2.doubleValue());
        }

        protected Number multiply(Number number, Number number2) {
            return ((BigDecimal)number).multiply((BigDecimal)number2);
        }

        public boolean matches(Object object, Object object2) {
            return object instanceof BigDecimal || object2 instanceof BigDecimal;
        }
    }
}

