/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.lang;

import com.sun.el.lang.ELArithmetic;
import com.sun.el.util.MessageFactory;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;

public class ELSupport {
    private static final ELSupport REF = new ELSupport();
    private static final Long ZERO = new Long(0L);

    public static final void throwUnhandled(Object object, Object object2) throws ELException {
        if (object == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", object2));
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", object.getClass(), object2));
    }

    public static final int compare(Object object, Object object2) throws ELException {
        if (object == object2 || ELSupport.equals(object, object2)) {
            return 0;
        }
        if (ELSupport.isBigDecimalOp(object, object2)) {
            BigDecimal bigDecimal = (BigDecimal)ELSupport.coerceToNumber(object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)ELSupport.coerceToNumber(object2, BigDecimal.class);
            return bigDecimal.compareTo(bigDecimal2);
        }
        if (ELSupport.isDoubleOp(object, object2)) {
            Double d = (Double)ELSupport.coerceToNumber(object, Double.class);
            Double d2 = (Double)ELSupport.coerceToNumber(object2, Double.class);
            return d.compareTo(d2);
        }
        if (ELSupport.isBigIntegerOp(object, object2)) {
            BigInteger bigInteger = (BigInteger)ELSupport.coerceToNumber(object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)ELSupport.coerceToNumber(object2, BigInteger.class);
            return bigInteger.compareTo(bigInteger2);
        }
        if (ELSupport.isLongOp(object, object2)) {
            Long l = (Long)ELSupport.coerceToNumber(object, Long.class);
            Long l2 = (Long)ELSupport.coerceToNumber(object2, Long.class);
            return l.compareTo(l2);
        }
        if (object instanceof String || object2 instanceof String) {
            return ELSupport.coerceToString(object).compareTo(ELSupport.coerceToString(object2));
        }
        if (object instanceof Comparable) {
            return object2 != null ? ((Comparable)object).compareTo(object2) : 1;
        }
        if (object2 instanceof Comparable) {
            return object != null ? -((Comparable)object2).compareTo(object) : -1;
        }
        throw new ELException(MessageFactory.get("error.compare", object, object2));
    }

    public static final boolean equals(Object object, Object object2) throws ELException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return ELSupport.coerceToBoolean(object).equals(ELSupport.coerceToBoolean(object2));
        }
        if (object.getClass().isEnum()) {
            return object.equals(ELSupport.coerceToEnum(object2, object.getClass()));
        }
        if (object2.getClass().isEnum()) {
            return object2.equals(ELSupport.coerceToEnum(object, object2.getClass()));
        }
        if (object instanceof String || object2 instanceof String) {
            return ELSupport.coerceToString(object).equals(ELSupport.coerceToString(object2));
        }
        if (ELSupport.isBigDecimalOp(object, object2)) {
            BigDecimal bigDecimal = (BigDecimal)ELSupport.coerceToNumber(object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)ELSupport.coerceToNumber(object2, BigDecimal.class);
            return bigDecimal.equals(bigDecimal2);
        }
        if (ELSupport.isDoubleOp(object, object2)) {
            Double d = (Double)ELSupport.coerceToNumber(object, Double.class);
            Double d2 = (Double)ELSupport.coerceToNumber(object2, Double.class);
            return d.equals(d2);
        }
        if (ELSupport.isBigIntegerOp(object, object2)) {
            BigInteger bigInteger = (BigInteger)ELSupport.coerceToNumber(object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)ELSupport.coerceToNumber(object2, BigInteger.class);
            return bigInteger.equals(bigInteger2);
        }
        if (ELSupport.isLongOp(object, object2)) {
            Long l = (Long)ELSupport.coerceToNumber(object, Long.class);
            Long l2 = (Long)ELSupport.coerceToNumber(object2, Long.class);
            return l.equals(l2);
        }
        return object.equals(object2);
    }

    public static final Boolean coerceToBoolean(Object object) throws IllegalArgumentException {
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean || object.getClass() == Boolean.TYPE) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", object, object.getClass(), Boolean.class));
    }

    public static final Enum coerceToEnum(Object object, Class clazz) throws IllegalArgumentException {
        if (object == null || "".equals(object)) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (Enum)object;
        }
        if (object instanceof String) {
            return Enum.valueOf(clazz, (String)object);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
    }

    public static final Character coerceToCharacter(Object object) throws IllegalArgumentException {
        if (object == null || "".equals(object)) {
            return new Character('\u0000');
        }
        if (object instanceof String) {
            return new Character(((String)object).charAt(0));
        }
        if (ELArithmetic.isNumber(object)) {
            return new Character((char)((Number)object).shortValue());
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Character || clazz == Character.TYPE) {
            return (Character)object;
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", object, clazz, Character.class));
    }

    public static final Number coerceToNumber(Object object) {
        if (object == null) {
            return ZERO;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        String string = ELSupport.coerceToString(object);
        if (ELSupport.isStringFloat(string)) {
            return ELSupport.toFloat(string);
        }
        return ELSupport.toNumber(string);
    }

    protected static final Number coerceToNumber(Number number, Class clazz) throws IllegalArgumentException {
        if (Long.TYPE == clazz || Long.class.equals((Object)clazz)) {
            return new Long(number.longValue());
        }
        if (Double.TYPE == clazz || Double.class.equals((Object)clazz)) {
            return new Double(number.doubleValue());
        }
        if (Integer.TYPE == clazz || Integer.class.equals((Object)clazz)) {
            return new Integer(number.intValue());
        }
        if (BigInteger.class.equals((Object)clazz)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (Byte.TYPE == clazz || Byte.class.equals((Object)clazz)) {
            return new Byte(number.byteValue());
        }
        if (Short.TYPE == clazz || Short.class.equals((Object)clazz)) {
            return new Short(number.shortValue());
        }
        if (Float.TYPE == clazz || Float.class.equals((Object)clazz)) {
            return new Float(number.floatValue());
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", number, number.getClass(), clazz));
    }

    public static final Number coerceToNumber(Object object, Class clazz) throws IllegalArgumentException {
        if (object == null || "".equals(object)) {
            return ELSupport.coerceToNumber(ZERO, clazz);
        }
        if (object instanceof String) {
            return ELSupport.coerceToNumber((String)object, clazz);
        }
        if (ELArithmetic.isNumber(object)) {
            return ELSupport.coerceToNumber((Number)object, clazz);
        }
        Class<?> clazz2 = object.getClass();
        if (Character.class.equals(clazz2) || Character.TYPE == clazz2) {
            return ELSupport.coerceToNumber(new Short((short)((Character)object).charValue()), clazz);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", object, clazz2, clazz));
    }

    protected static final Number coerceToNumber(String string, Class clazz) throws IllegalArgumentException {
        if (Long.TYPE == clazz || Long.class.equals((Object)clazz)) {
            return Long.valueOf(string);
        }
        if (Integer.TYPE == clazz || Integer.class.equals((Object)clazz)) {
            return Integer.valueOf(string);
        }
        if (Double.TYPE == clazz || Double.class.equals((Object)clazz)) {
            return Double.valueOf(string);
        }
        if (BigInteger.class.equals((Object)clazz)) {
            return new BigInteger(string);
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            return new BigDecimal(string);
        }
        if (Byte.TYPE == clazz || Byte.class.equals((Object)clazz)) {
            return Byte.valueOf(string);
        }
        if (Short.TYPE == clazz || Short.class.equals((Object)clazz)) {
            return Short.valueOf(string);
        }
        if (Float.TYPE == clazz || Float.class.equals((Object)clazz)) {
            return Float.valueOf(string);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", string, String.class, clazz));
    }

    public static final String coerceToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        return object.toString();
    }

    public static final Object coerceToType(Object object, Class clazz) throws IllegalArgumentException {
        if (clazz == null || Object.class.equals((Object)clazz)) {
            return object;
        }
        if (String.class.equals((Object)clazz)) {
            return ELSupport.coerceToString(object);
        }
        if (ELArithmetic.isNumberType(clazz)) {
            return ELSupport.coerceToNumber(object, clazz);
        }
        if (Character.class.equals((Object)clazz) || Character.TYPE == clazz) {
            return ELSupport.coerceToCharacter(object);
        }
        if (Boolean.class.equals((Object)clazz) || Boolean.TYPE == clazz) {
            return ELSupport.coerceToBoolean(object);
        }
        if (clazz.isEnum()) {
            return ELSupport.coerceToEnum(object, clazz);
        }
        if (object != null && clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            if ("".equals(object)) {
                return null;
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            if (propertyEditor != null) {
                propertyEditor.setAsText((String)object);
                return propertyEditor.getValue();
            }
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
    }

    public static final boolean containsNulls(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[0] != null) continue;
            return true;
        }
        return false;
    }

    public static final boolean isBigDecimalOp(Object object, Object object2) {
        return object instanceof BigDecimal || object2 instanceof BigDecimal;
    }

    public static final boolean isBigIntegerOp(Object object, Object object2) {
        return object instanceof BigInteger || object2 instanceof BigInteger;
    }

    public static final boolean isDoubleOp(Object object, Object object2) {
        return object instanceof Double || object2 instanceof Double || object instanceof Float || object2 instanceof Float || object != null && (Double.TYPE == object.getClass() || Float.TYPE == object.getClass()) || object2 != null && (Double.TYPE == object2.getClass() || Float.TYPE == object2.getClass());
    }

    public static final boolean isDoubleStringOp(Object object, Object object2) {
        return ELSupport.isDoubleOp(object, object2) || object instanceof String && ELSupport.isStringFloat((String)object) || object2 instanceof String && ELSupport.isStringFloat((String)object2);
    }

    public static final boolean isLongOp(Object object, Object object2) {
        return object instanceof Long || object2 instanceof Long || object instanceof Integer || object2 instanceof Integer || object instanceof Character || object2 instanceof Character || object instanceof Short || object2 instanceof Short || object instanceof Byte || object2 instanceof Byte || object != null && (Long.TYPE == object.getClass() || Integer.TYPE == object.getClass() || Character.TYPE == object.getClass() || Short.TYPE == object.getClass() || Byte.TYPE == object.getClass()) || object != null && (Long.TYPE == object.getClass() || Integer.TYPE == object.getClass() || Character.TYPE == object.getClass() || Short.TYPE == object.getClass() || Byte.TYPE == object.getClass());
    }

    public static final boolean isStringFloat(String string) {
        int n = string.length();
        if (n > 1) {
            char c = '\u0000';
            for (int i = 0; i < n; ++i) {
                c = string.charAt(i);
                switch (c) {
                    case 'E': {
                        return true;
                    }
                    case 'e': {
                        return true;
                    }
                    case '.': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static final Number toFloat(String string) {
        try {
            if (Double.parseDouble(string) > Double.MAX_VALUE) {
                return new BigDecimal(string);
            }
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigDecimal(string);
        }
    }

    public static final Number toNumber(String string) {
        try {
            return new Integer(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Long(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException2) {
                return new BigInteger(string);
            }
        }
    }
}

