/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.lang;

import com.sun.el.MethodExpressionImpl;
import com.sun.el.MethodExpressionLiteral;
import com.sun.el.ValueExpressionImpl;
import com.sun.el.lang.FunctionMapperFactory;
import com.sun.el.lang.VariableMapperFactory;
import com.sun.el.parser.AstCompositeExpression;
import com.sun.el.parser.AstDeferredExpression;
import com.sun.el.parser.AstDynamicExpression;
import com.sun.el.parser.AstFunction;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstLiteralExpression;
import com.sun.el.parser.AstValue;
import com.sun.el.parser.ELParser;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import com.sun.el.parser.ParseException;
import com.sun.el.util.MessageFactory;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public final class ExpressionBuilder
implements NodeVisitor {
    private static final int SIZE = 5000;
    private static final Map cache = new ConcurrentHashMap(5000);
    private static final Map cache2 = new ConcurrentHashMap(5000);
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private String expression;

    public ExpressionBuilder(String string, ELContext eLContext) throws ELException {
        this.expression = string;
        FunctionMapper functionMapper = eLContext.getFunctionMapper();
        VariableMapper variableMapper = eLContext.getVariableMapper();
        if (functionMapper != null) {
            this.fnMapper = new FunctionMapperFactory(functionMapper);
        }
        if (variableMapper != null) {
            this.varMapper = new VariableMapperFactory(variableMapper);
        }
    }

    public static final Node createNode(String string) throws ELException {
        Node node = ExpressionBuilder.createNodeInternal(string);
        return node;
    }

    private static final Node createNodeInternal(String string) throws ELException {
        if (string == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }
        Node node = (Node)cache.get(string);
        if (node == null && (node = (Node)cache2.get(string)) == null) {
            try {
                node = new ELParser(new StringReader(string)).CompositeExpression();
                if (node instanceof AstCompositeExpression) {
                    int n = node.jjtGetNumChildren();
                    if (n == 1) {
                        node = node.jjtGetChild(0);
                    } else {
                        Class<?> clazz = null;
                        Node node2 = null;
                        for (int i = 0; i < n; ++i) {
                            node2 = node.jjtGetChild(i);
                            if (node2 instanceof AstLiteralExpression) continue;
                            if (clazz == null) {
                                clazz = node2.getClass();
                                continue;
                            }
                            if (clazz.equals(node2.getClass())) continue;
                            throw new ELException(MessageFactory.get("error.mixed", string));
                        }
                    }
                }
                if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
                    node = node.jjtGetChild(0);
                }
                if (cache.size() > 5000) {
                    cache2.clear();
                    cache2.putAll(cache);
                    cache.clear();
                }
                cache.put(string, node);
            }
            catch (ParseException parseException) {
                throw new ELException("Error Parsing: " + string, (Throwable)parseException);
            }
        }
        return node;
    }

    private void prepare(Node node) throws ELException {
        node.accept(this);
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory)this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory)this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node node = ExpressionBuilder.createNodeInternal(this.expression);
        this.prepare(node);
        if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
            node = node.jjtGetChild(0);
        }
        return node;
    }

    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {
            AstFunction astFunction = (AstFunction)node;
            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            Method method = this.fnMapper.resolveFunction(astFunction.getPrefix(), astFunction.getLocalName());
            if (method == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.method", astFunction.getOutputName()));
            }
            int n = method.getParameterTypes().length;
            if (node.jjtGetNumChildren() != n) {
                throw new ELException(MessageFactory.get("error.fnMapper.paramcount", astFunction.getOutputName(), "" + n, "" + node.jjtGetNumChildren()));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String string = ((AstIdentifier)node).getImage();
            this.varMapper.resolveVariable(string);
        }
    }

    public ValueExpression createValueExpression(Class clazz) throws ELException {
        Node node = this.build();
        return new ValueExpressionImpl(this.expression, node, this.fnMapper, this.varMapper, clazz);
    }

    public MethodExpression createMethodExpression(Class clazz, Class[] classArray) throws ELException {
        Node node = this.build();
        if (node instanceof AstValue || node instanceof AstIdentifier) {
            return new MethodExpressionImpl(this.expression, node, this.fnMapper, this.varMapper, clazz, classArray);
        }
        if (node instanceof AstLiteralExpression) {
            return new MethodExpressionLiteral(this.expression, clazz, classArray);
        }
        throw new ELException("Not a Valid Method Expression: " + this.expression);
    }
}

