/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.lang;

import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;

public class FunctionMapperImpl
extends FunctionMapper
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected Map functions = null;

    public Method resolveFunction(String string, String string2) {
        if (this.functions != null) {
            Function function = (Function)this.functions.get(string + ":" + string2);
            return function.getMethod();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(String string, String string2, Method method) {
        if (this.functions == null) {
            this.functions = new HashMap();
        }
        Function function = new Function(string, string2, method);
        FunctionMapperImpl functionMapperImpl = this;
        synchronized (functionMapperImpl) {
            this.functions.put(string + ":" + string2, function);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.functions);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.functions = (Map)objectInput.readObject();
    }

    public static class Function
    implements Externalizable {
        protected transient Method m;
        protected String owner;
        protected String name;
        protected String[] types;
        protected String prefix;
        protected String localName;

        public Function(String string, String string2, Method method) {
            if (string2 == null) {
                throw new NullPointerException("LocalName cannot be null");
            }
            if (method == null) {
                throw new NullPointerException("Method cannot be null");
            }
            this.prefix = string;
            this.localName = string2;
            this.m = method;
        }

        public Function() {
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.prefix != null ? this.prefix : "");
            objectOutput.writeUTF(this.localName);
            if (this.owner != null) {
                objectOutput.writeUTF(this.owner);
            } else {
                objectOutput.writeUTF(this.m.getDeclaringClass().getName());
            }
            if (this.name != null) {
                objectOutput.writeUTF(this.name);
            } else {
                objectOutput.writeUTF(this.m.getName());
            }
            if (this.types != null) {
                objectOutput.writeObject(this.types);
            } else {
                objectOutput.writeObject(ReflectionUtil.toTypeNameArray(this.m.getParameterTypes()));
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.prefix = objectInput.readUTF();
            if ("".equals(this.prefix)) {
                this.prefix = null;
            }
            this.localName = objectInput.readUTF();
            this.owner = objectInput.readUTF();
            this.name = objectInput.readUTF();
            this.types = (String[])objectInput.readObject();
        }

        public Method getMethod() {
            if (this.m == null) {
                try {
                    Class<?> clazz = Class.forName(this.owner);
                    Class[] classArray = ReflectionUtil.toTypeArray(this.types);
                    this.m = clazz.getMethod(this.name, classArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.m;
        }

        public boolean matches(String string, String string2) {
            if (this.prefix != null) {
                if (string == null) {
                    return false;
                }
                if (!this.prefix.equals(string)) {
                    return false;
                }
            }
            return this.localName.equals(string2);
        }

        public boolean equals(Object object) {
            if (object instanceof Function) {
                return this.hashCode() == object.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return (this.prefix + this.localName).hashCode();
        }
    }
}

