/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.parser;

import com.sun.el.lang.EvaluationContext;
import com.sun.el.parser.SimpleNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int n) {
        super(n);
    }

    public Class getType(EvaluationContext evaluationContext) throws ELException {
        return Number.class;
    }

    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object object = this.children[0].getValue(evaluationContext);
        if (object == null) {
            return new Long(0L);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).negate();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).negate();
        }
        if (object instanceof String) {
            if (AstNegative.isStringFloat((String)object)) {
                return new Double(-Double.parseDouble((String)object));
            }
            return new Long(-Long.parseLong((String)object));
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Long || Long.TYPE == clazz) {
            return new Long(-((Long)object).longValue());
        }
        if (object instanceof Double || Double.TYPE == clazz) {
            return new Double(-((Double)object).doubleValue());
        }
        if (object instanceof Integer || Integer.TYPE == clazz) {
            return new Integer(-((Integer)object).intValue());
        }
        if (object instanceof Float || Float.TYPE == clazz) {
            return new Float(-((Float)object).floatValue());
        }
        if (object instanceof Short || Short.TYPE == clazz) {
            return new Short(-((Short)object).shortValue());
        }
        if (object instanceof Byte || Byte.TYPE == clazz) {
            return new Byte(-((Byte)object).byteValue());
        }
        Long l = (Long)AstNegative.coerceToNumber(object, Long.class);
        return new Long(-l.longValue());
    }
}

