/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;

public class DirectoryExcludeFilterPanel
extends JPanel {
    private JLabel _otherLbl;
    private JTextField _otherFld;
    private JRadioButton _selectedDirRB;
    private JRadioButton _allDirRB;
    private ButtonGroup _buttonGroup;
    private JCheckBox _recurseCB;
    private static final String HELP_TOPIC = "f1_ideddirectoriestoexclude_html";

    private void $init$() {
        this._otherLbl = new JLabel();
        this._otherFld = new JTextField();
        this._selectedDirRB = new JRadioButton();
        this._allDirRB = new JRadioButton();
        this._buttonGroup = new ButtonGroup();
        this._recurseCB = new JCheckBox();
    }

    public DirectoryExcludeFilterPanel() {
        this.$init$();
        this.initPanel();
    }

    protected void initPanel() {
        ResourceUtils.resButton((AbstractButton)this._allDirRB, (String)DialogsArb.getString((int)13));
        ResourceUtils.resLabel((JLabel)this._otherLbl, (Component)this._otherFld, (String)DialogsArb.getString((int)7));
        ResourceUtils.resButton((AbstractButton)this._recurseCB, (String)DialogsArb.getString((int)33));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._otherLbl, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._otherFld, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._buttonGroup.add(this._selectedDirRB);
        this._buttonGroup.add(this._allDirRB);
        this._allDirRB.setSelected(true);
        this.add((Component)this._allDirRB, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this._recurseCB.setSelected(true);
        this.add((Component)this._selectedDirRB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._recurseCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
    }

    public boolean showDialog(Component parent, DirectoryExcludeFilter filter, String selectedDir) {
        if (filter == null) {
            filter = new DirectoryExcludeFilter();
        }
        ResourceUtils.resButton((AbstractButton)this._selectedDirRB, (String)DialogsArb.format((int)28, (Object)selectedDir));
        this.loadFrom((FileFilter)filter);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (dialog == null) {
            return false;
        }
        dialog.setCenterOver(parent);
        dialog.setContent((Component)this);
        dialog.setInitialFocus((Component)this._otherFld);
        dialog.setTitle(DialogsArb.getString((int)32));
        dialog.setButtonMask(7);
        dialog.setResizable(true);
        dialog.setPreferredSize(350, 250);
        if (dialog.runDialog()) {
            this.commitTo((FileFilter)filter);
            return true;
        }
        return false;
    }

    protected void loadFrom(FileFilter filter) {
        this._recurseCB.setSelected(filter.getRecurseDirectories());
        if (filter.getApplyToDirectory() == 1) {
            this._selectedDirRB.setSelected(true);
            this._allDirRB.setSelected(false);
        } else {
            this._selectedDirRB.setSelected(false);
            this._allDirRB.setSelected(true);
        }
        String exclusions = filter.getUserDefinedExclusions();
        if (ModelUtil.hasLength((String)exclusions)) {
            this._otherFld.setText(exclusions);
        }
    }

    protected void commitTo(FileFilter filter) {
        filter.setRecurseDirectories(this._recurseCB.isSelected());
        if (this._selectedDirRB.isSelected()) {
            filter.setApplyToDirectory(1);
        } else {
            filter.setApplyToDirectory(0);
        }
        filter.setUserDefinedExclusions(this._otherFld.getText());
    }
}

