/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.DirectoryExcludeFilterPanel;
import oracle.ide.dialogs.filter.ExcludeFilterSettings;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilterPanel;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.resource.DirOptionsArb;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class DirectoryOptionsPanel
extends DefaultTraversablePanel
implements Runnable,
TreeExpansionListener,
TreeSelectionListener {
    private ArrayList _inputDirectories;
    private ArrayList _expandedFiles;
    private ArrayList _jdevFiles;
    private ProgressBar _progressBar;
    private Context _context;
    private JMutableTreeNode _rootNode;
    private DefaultTreeModel _treeModel;
    private CustomJTree _tree;
    private JScrollPane _scrollPane;
    private JButton _addBtn;
    private JButton _removeBtn;
    private JButton _fileTypeBtn;
    private JButton _dirFilterBtn;
    private JCheckBox _copyCheckBox;
    private URLTextField _copyLocationFld;
    private JButton _browseBtn;
    private int _runOption;
    private List _selectedFiles;
    private List _copiedFiles;
    private URL _lastURLDirectory;
    private boolean _addToProject;
    private boolean _enableFileTypeBtn;
    private boolean _jwsOnly;
    private boolean _jwsExcluded;
    private boolean _jprOnly;
    private boolean _jprExcluded;
    private static final String ICON_KEY_DIRECTORY = "FileView.directoryIcon";
    private static final String ICON_KEY_FILE = "FileView.fileIcon";
    private static final String HELP_TOPIC = "f1_idedrefinefileselection_html";
    private static final int EXPAND_ALL_DIRECTORIES = 0;
    private static final int COPY_FILES = 1;
    private static final int INCLUDE_LIST = 0;
    private static final int EXCLUDE_LIST = 1;
    private static final String WORKSPACE_FILE_EXT = ".jws";
    private static final String PROJECT_FILE_EXT = ".jpr";

    private void $init$() {
        this._inputDirectories = new ArrayList();
        this._expandedFiles = new ArrayList();
        this._jdevFiles = new ArrayList();
        this._addBtn = new JButton();
        this._removeBtn = new JButton();
        this._fileTypeBtn = new JButton();
        this._dirFilterBtn = new JButton();
        this._copyCheckBox = new JCheckBox();
        this._copyLocationFld = new URLTextField();
        this._browseBtn = new JButton();
        this._enableFileTypeBtn = true;
    }

    public DirectoryOptionsPanel(URL[] selectedURLs, boolean showAddButton, boolean showRemoveButton, boolean addingToProject, Context context) {
        this.$init$();
        this._addToProject = addingToProject;
        this._context = context;
        this.initData(selectedURLs, addingToProject);
        this.initUI(showAddButton, showRemoveButton, addingToProject);
    }

    public DirectoryOptionsPanel(URL[] selectedURLs, boolean showAddButton, boolean addingToProject) {
        this(selectedURLs, showAddButton, false, addingToProject, null);
    }

    public DirectoryOptionsPanel(URL[] selectedURLs, boolean showAddButton, boolean showRemoveButton, boolean addingToProject) {
        this(selectedURLs, showAddButton, showRemoveButton, addingToProject, null);
    }

    public void setProject(Project project) {
        if (this._context == null) {
            this._context = Context.newIdeContext();
        }
        this._context.setProject(project);
    }

    public void setContext(Context context) {
        this._context = context;
        this.setJDevFilesSettings();
    }

    public boolean showDialog(Component parent) {
        JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (dialog == null) {
            return false;
        }
        dialog.setCenterOver(parent);
        dialog.setContent((Component)((Object)this));
        dialog.setInitialFocus((Component)this.getTree());
        if (this._jwsOnly) {
            dialog.setTitle(DirOptionsArb.getString((int)13));
        } else if (this._jprOnly) {
            dialog.setTitle(DirOptionsArb.getString((int)24));
        } else {
            dialog.setTitle(DirOptionsArb.getString((int)15));
        }
        dialog.setButtonMask(7);
        dialog.setResizable(true);
        dialog.setPreferredSize(new Dimension(500, 500));
        boolean retval = dialog.runDialog();
        dialog.dispose();
        return retval;
    }

    public URL getProjectDirectory() {
        return this._copyLocationFld.getURL();
    }

    public void setProjectDirectory(URL projectDirectory) {
        URL projectURL = null;
        if (projectDirectory != null) {
            projectURL = projectDirectory;
        } else {
            if (Ide.getActiveProject() == null) {
                return;
            }
            projectDirectory = Ide.getActiveProject().getURL();
        }
        String projectString = URLFileSystem.getPath((URL)projectDirectory);
        projectString = projectString.substring(0, projectString.lastIndexOf("/") + 1);
        this._copyLocationFld.setURL(URLFactory.newDirURL((String)(projectString + "src/")));
    }

    public boolean getCopyFiles() {
        return this._copyCheckBox.isSelected();
    }

    public URL getCopyLocationURL() {
        return this._copyLocationFld.getURL();
    }

    public static boolean containsDirectory(URL[] selectedURLs) {
        int i = 0;
        while (i < selectedURLs.length) {
            if (URLFileSystem.isDirectory((URL)selectedURLs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void populateTree(URL[] selectedURLs) {
        int i = 0;
        while (i < selectedURLs.length) {
            this.addChild(selectedURLs[i]);
            ++i;
        }
        if (selectedURLs.length < 2) {
            this.getTree().expandRow(0);
        }
    }

    public JMutableTreeNode getRootNode() {
        return this._rootNode;
    }

    public CustomJTree getTree() {
        return this._tree;
    }

    public ArrayList getInputDirectories() {
        return this._inputDirectories;
    }

    public int expandDirectories(Component parent) {
        this._runOption = 0;
        this._progressBar = new ProgressBar(parent, DirOptionsArb.getString((int)7), (Runnable)this, true);
        this._progressBar.start(DirOptionsArb.getString((int)30), null);
        this._progressBar.waitUntilDone();
        if (this._progressBar.hasUserCancelled()) {
            this._expandedFiles.clear();
            return 0;
        }
        return this._expandedFiles.size();
    }

    private void initData(URL[] selectedURLs, boolean addingToProject) {
        JTreeCellData treeCellData = new JTreeCellData(null, null, true, TriStateBoolean.TRUE);
        this._rootNode = new JMutableTreeNode(treeCellData);
        NodeData rootNodeData = new NodeData(null);
        this._rootNode.setUserObject((Object)rootNodeData);
        this._treeModel = new DefaultTreeModel((TreeNode)this._rootNode);
        this._tree = new CustomJTree((TreeModel)this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setScrollsOnExpand(true);
        this._tree.addTreeExpansionListener((TreeExpansionListener)this);
        this._tree.addTreeSelectionListener((TreeSelectionListener)this);
        if (selectedURLs != null) {
            this.populateTree(selectedURLs);
            this._tree.setSelectionRow(0);
            this._fileTypeBtn.setEnabled(true);
            this._dirFilterBtn.setEnabled(true);
        }
        if (addingToProject) {
            this.setProjectDirectory(null);
        }
        this.setJDevFilesSettings();
    }

    private void setJDevFilesSettings() {
        if (this._addToProject && this._context != null) {
            if (this._context.getWorkspace() == null) {
                this._enableFileTypeBtn = false;
                this._jwsOnly = true;
            } else if (this._context.getProject() == null) {
                this._enableFileTypeBtn = false;
                this._jprOnly = true;
            } else {
                this._jwsExcluded = true;
                this._jprExcluded = true;
            }
        }
    }

    private void initUI(boolean showAddButton, boolean showRemoveButton, boolean addingToProject) {
        this.setLayout(new GridBagLayout());
        this.setHelpID(HELP_TOPIC);
        HelpUtils.setHelpID((JComponent)((Object)this), (String)HELP_TOPIC);
        this._scrollPane = new JScrollPane((Component)this._tree);
        ResourceUtils.resButton((AbstractButton)this._copyCheckBox, (String)DirOptionsArb.getString((int)5));
        this._copyCheckBox.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this._browseBtn, (String)DirOptionsArb.getString((int)17));
        this._browseBtn.addActionListener((ActionListener)this._copyLocationFld);
        ButtonsLayoutManager buttonMgr = new ButtonsLayoutManager();
        buttonMgr.setGap(5);
        JPanel buttonPanel = new JPanel((LayoutManager)buttonMgr);
        JLabel treeLabel = new JLabel();
        String labelText = null;
        labelText = showAddButton ? DirOptionsArb.getString((int)16) : DirOptionsArb.getString((int)9);
        ResourceUtils.resLabel((JLabel)treeLabel, (Component)this._tree, (String)labelText);
        this.add(treeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._scrollPane, new GridBagConstraints(0, 1, 4, 5, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (addingToProject && !this._jwsOnly && !this._jprOnly) {
            this.add(this._copyCheckBox, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)this._copyLocationFld, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 15, 0, 0), 0, 0));
            this.add(this._browseBtn, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this._copyCheckBox, new Component[]{this._copyLocationFld, this._browseBtn});
        }
        ResourceUtils.resButton((AbstractButton)this._dirFilterBtn, (String)DirOptionsArb.getString((int)22));
        this._dirFilterBtn.addActionListener(new 1());
        int btnCounter = 1;
        buttonPanel.add((Component)this._dirFilterBtn, new Integer(btnCounter++));
        ResourceUtils.resButton((AbstractButton)this._fileTypeBtn, (String)DirOptionsArb.getString((int)29));
        this._fileTypeBtn.addActionListener(new 2());
        if (this._enableFileTypeBtn) {
            buttonPanel.add((Component)this._fileTypeBtn, new Integer(btnCounter++));
        }
        if (this._tree.getSelectionCount() == 0) {
            this._fileTypeBtn.setEnabled(false);
            this._dirFilterBtn.setEnabled(false);
        }
        if (showRemoveButton) {
            ResourceUtils.resButton((AbstractButton)this._removeBtn, (String)DirOptionsArb.getString((int)19));
            this._removeBtn.addActionListener(new 3());
            buttonPanel.add((Component)this._removeBtn, new Integer(btnCounter++));
            this._removeBtn.setEnabled(false);
        }
        if (showAddButton) {
            ResourceUtils.resButton((AbstractButton)this._addBtn, (String)DirOptionsArb.getString((int)6));
            this._addBtn.addActionListener(new 4());
            buttonPanel.add((Component)this._addBtn, new Integer(btnCounter++));
        }
    }

    public void run() {
        if (this._runOption == 0) {
            this.expandAllDirectories();
        } else if (this._runOption == 1) {
            this.copyFiles();
        }
    }

    private void expandAllDirectories() {
        ArrayList<URL> _directoryList = new ArrayList<URL>();
        if (this._progressBar.hasUserCancelled()) {
            return;
        }
        int w = 0;
        while (w < this._inputDirectories.size()) {
            List subdirExcludeList;
            NodeData nodeData = (NodeData)this._inputDirectories.get(w);
            DirectoryExcludeFilter directoryFilter = nodeData.getDirectoryFilter();
            FileTypeIncludeFilter fileTypeFilter = nodeData.getFileTypeFilter();
            List fileIncludeList = fileTypeFilter == null ? null : fileTypeFilter.getList();
            List list = subdirExcludeList = directoryFilter == null ? null : directoryFilter.getList();
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(DirOptionsArb.getString((int)21), URLFileSystem.getPlatformPathName((URL)nodeData.getURL()));
            URL[] urlFileList = URLFileSystem.list((URL)nodeData.getURL());
            int i = 0;
            while (i < urlFileList.length) {
                if (this._progressBar.hasUserCancelled()) {
                    return;
                }
                if (URLFileSystem.isDirectory((URL)urlFileList[i])) {
                    if (this.canFileBeAddedToList(urlFileList[i], subdirExcludeList, 1)) {
                        _directoryList.add(urlFileList[i]);
                    }
                    this._progressBar.updateProgress(DirOptionsArb.getString((int)28), URLFileSystem.getPlatformPathName((URL)urlFileList[i]));
                } else if (!this.isURLAlreadyInProject(urlFileList[i])) {
                    if (this.canFileBeAddedToList(urlFileList[i], fileIncludeList, 0)) {
                        this.handleFile(urlFileList[i], this._expandedFiles);
                    }
                    this._progressBar.updateProgress(DirOptionsArb.getString((int)11), URLFileSystem.getPlatformPathName((URL)urlFileList[i]));
                }
                ++i;
            }
            urlFileList = null;
            int j = 0;
            while (j < _directoryList.size()) {
                if (this._progressBar.hasUserCancelled()) {
                    return;
                }
                urlFileList = URLFileSystem.list((URL)((URL)_directoryList.get(j)));
                _directoryList.remove(j);
                int k = 0;
                while (k < urlFileList.length) {
                    this._progressBar.sleepForUIToRepaint();
                    if (URLFileSystem.isDirectory((URL)urlFileList[k])) {
                        if (this.canFileBeAddedToList(urlFileList[k], subdirExcludeList, 1)) {
                            _directoryList.add(j, urlFileList[k]);
                            this._progressBar.updateProgress(DirOptionsArb.getString((int)28), URLFileSystem.getPlatformPathName((URL)urlFileList[k]));
                        }
                    } else if (this.canFileBeAddedToList(urlFileList[k], fileIncludeList, 0) && !this.isURLAlreadyInProject(urlFileList[k])) {
                        this.handleFile(urlFileList[k], this._expandedFiles);
                        this._progressBar.updateProgress(DirOptionsArb.getString((int)11), URLFileSystem.getPlatformPathName((URL)urlFileList[k]));
                    }
                    ++k;
                }
                --j;
                ++j;
            }
            ++w;
        }
        this._progressBar.setDoneStatus();
    }

    private void handleFile(URL url, List addList) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        if (this._jwsOnly) {
            if (suffix.equals(WORKSPACE_FILE_EXT)) {
                addList.add(url);
                return;
            }
            return;
        }
        if (this._jwsExcluded && suffix.equals(WORKSPACE_FILE_EXT)) {
            return;
        }
        if (this._jprOnly) {
            if (suffix.equals(PROJECT_FILE_EXT)) {
                addList.add(url);
                return;
            }
            return;
        }
        if (this._jprExcluded && suffix.equals(PROJECT_FILE_EXT)) {
            return;
        }
        if (suffix.equals(WORKSPACE_FILE_EXT) || suffix.equals(PROJECT_FILE_EXT)) {
            this._jdevFiles.add(url);
        } else {
            addList.add(url);
        }
    }

    public URL getNewFileNameFor(URL originalFile) {
        List parentDirectories = this.getTopLevelUserSelections();
        URL baseDirectory = this._copyLocationFld.getURL();
        URL parentURL = this.findParentURLInList(originalFile, parentDirectories);
        URL copyToURL = null;
        if (parentURL == null) {
            copyToURL = URLFactory.newURL((URL)baseDirectory, (String)URLFileSystem.getFileName((URL)originalFile));
        } else {
            String fileSpec = originalFile.toExternalForm().substring(parentURL.toExternalForm().length());
            copyToURL = URLFactory.newURL((URL)baseDirectory, (String)fileSpec);
        }
        return copyToURL;
    }

    private void copyFiles() {
        List parentDirectories = this.getTopLevelUserSelections();
        URL baseDirectory = this._copyLocationFld.getURL();
        if (this._selectedFiles == null || this._selectedFiles.size() == 0) {
            return;
        }
        Iterator iterator = this._selectedFiles.iterator();
        while (iterator.hasNext()) {
            URL fileToAdd = (URL)iterator.next();
            URL parentURL = this.findParentURLInList(fileToAdd, parentDirectories);
            URL copyToURL = null;
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(DirOptionsArb.getString((int)23), URLFileSystem.getPlatformPathName((URL)fileToAdd));
            if (parentURL == null) {
                String fname = null;
                if (!URLFileSystem.isDirectory((URL)fileToAdd) && URLFileSystem.hasSuffix((URL)fileToAdd, (String)".java")) {
                    String pkgDirStruct = this.getPackage(fileToAdd);
                    if (pkgDirStruct != null) {
                        fname = pkgDirStruct + URLFileSystem.getFileName((URL)fileToAdd);
                    }
                } else {
                    fname = URLFileSystem.getFileName((URL)fileToAdd);
                }
                copyToURL = URLFactory.newURL((URL)baseDirectory, (String)fname);
            } else {
                String pkgDirStruct;
                String fileSpec = fileToAdd.toExternalForm().substring(parentURL.toExternalForm().length());
                if (fileSpec.equals(URLFileSystem.getFileName((URL)fileToAdd)) && URLFileSystem.getSuffix((URL)fileToAdd).equals(".java") && (pkgDirStruct = this.getPackage(fileToAdd)) != null) {
                    fileSpec = pkgDirStruct + fileSpec;
                }
                copyToURL = URLFactory.newURL((URL)baseDirectory, (String)fileSpec);
            }
            try {
                if (!URLFileSystem.equals((URL)fileToAdd, (URL)copyToURL)) {
                    URLFileSystem.copy((URL)fileToAdd, (URL)copyToURL);
                    this._copiedFiles.add(copyToURL);
                }
                iterator.remove();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this._progressBar.setDoneStatus();
    }

    private boolean canFileBeAddedToList(URL urlToTest, List testList, int listType) {
        if (testList == null) {
            return true;
        }
        int i = 0;
        while (i < testList.size()) {
            URLFilter filter = (URLFilter)testList.get(i);
            if (filter.accept(urlToTest)) {
                return listType == 0;
            }
            ++i;
        }
        return listType != 0;
    }

    private boolean isURLAlreadyInProject(URL urlToTest) {
        if (this._context.getProject() != null) {
            try {
                if (this._context.getProject().containsChild((Element)NodeFactory.findOrCreate((URL)urlToTest))) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void addChild(URL urlToAdd) {
        if (this.isParentURLInTree(urlToAdd)) {
            JOptionPane.showMessageDialog((Component)((Object)this), DirOptionsArb.format((int)25, (Object)URLFileSystem.getPlatformPathName((URL)urlToAdd)), DirOptionsArb.getString((int)18), 0);
            return;
        }
        DirectoryExcludeFilter directoryFilter = (DirectoryExcludeFilter)this.getOrCreateFilter(1);
        FileTypeIncludeFilter fileTypeFilter = (FileTypeIncludeFilter)this.getOrCreateFilter(0);
        JMutableTreeNode[] nodes = this.getChildURLsInTree(urlToAdd);
        if (nodes != null) {
            if (JOptionPane.showConfirmDialog((Component)((Object)this), DirOptionsArb.format((int)27, (Object)URLFileSystem.getPlatformPathName((URL)urlToAdd)), DirOptionsArb.getString((int)3), 0, 0) == 1) {
                return;
            }
            int i = 0;
            while (i < nodes.length) {
                nodes[i].removeFromParent();
                ++i;
            }
            JMutableTreeNode jnode = this.createAndAdd(this._rootNode, urlToAdd);
            if (jnode != null) {
                this.applyFilter(jnode, (FileFilter)directoryFilter, 1, true);
                this.applyFilter(jnode, (FileFilter)fileTypeFilter, 0, true);
                this._treeModel.reload((TreeNode)this._rootNode);
            }
        } else {
            JMutableTreeNode jnode = this.createAndAdd(this._rootNode, urlToAdd);
            if (jnode != null) {
                this.applyFilter(jnode, (FileFilter)directoryFilter, 1, true);
                this.applyFilter(jnode, (FileFilter)fileTypeFilter, 0, true);
                this._treeModel.reload((TreeNode)this._rootNode);
            }
        }
    }

    private boolean isParentURLInTree(URL urlToAdd) {
        Enumeration e = this._rootNode.children();
        while (e.hasMoreElements()) {
            JMutableTreeNode jnode = (JMutableTreeNode)e.nextElement();
            NodeData nodeData = (NodeData)jnode.getUserObject();
            URL nodeURL = nodeData.getURL();
            if (!URLFileSystem.isDirectoryPath((URL)nodeURL) || !URLFileSystem.isBaseURLFor((URL)nodeURL, (URL)urlToAdd)) continue;
            return true;
        }
        return false;
    }

    private JMutableTreeNode[] getChildURLsInTree(URL urlToAdd) {
        if (!URLFileSystem.isDirectoryPath((URL)urlToAdd)) {
            return null;
        }
        ArrayList<JMutableTreeNode> list = new ArrayList<JMutableTreeNode>();
        Enumeration e = this._rootNode.children();
        while (e.hasMoreElements()) {
            JMutableTreeNode jnode = (JMutableTreeNode)e.nextElement();
            NodeData nodeData = (NodeData)jnode.getUserObject();
            URL nodeURL = nodeData.getURL();
            if (!URLFileSystem.isBaseURLFor((URL)urlToAdd, (URL)nodeURL)) continue;
            list.add(jnode);
        }
        if (list.size() == 0) {
            return null;
        }
        int size = list.size();
        JMutableTreeNode[] nodes = list.toArray(new JMutableTreeNode[size]);
        return nodes;
    }

    private JMutableTreeNode createAndAdd(JMutableTreeNode parentNode, URL url) {
        if (this.isURLAlreadyInProject(url)) {
            return null;
        }
        Icon icon = null;
        String shortLabel = URLFileSystem.getFileName((URL)url);
        boolean isDirectory = URLFileSystem.isDirectoryPath((URL)url);
        icon = isDirectory ? UIManager.getIcon(ICON_KEY_DIRECTORY) : UIManager.getIcon(ICON_KEY_FILE);
        NodeData parentNodeData = (NodeData)parentNode.getUserObject();
        FileTypeIncludeFilter parentFileTypeFilter = parentNodeData.getFileTypeFilter();
        DirectoryExcludeFilter parentDirectoryFilter = parentNodeData.getDirectoryFilter();
        List testList = null;
        int listType = 0;
        if (isDirectory && parentDirectoryFilter != null) {
            testList = parentDirectoryFilter.getList();
            listType = 1;
        } else if (!isDirectory && parentFileTypeFilter != null) {
            testList = parentFileTypeFilter.getList();
            listType = 0;
        }
        JTreeCellData pcd = parentNode.getModel();
        TriStateBoolean fileAllowed = pcd.getCheckBoxState();
        if (fileAllowed.isTrue() && !this.canFileBeAddedToList(url, testList, listType)) {
            fileAllowed = TriStateBoolean.FALSE;
        }
        JTreeCellData treeCellData = new JTreeCellData(icon, shortLabel, true, fileAllowed);
        5 jnode = new 5(treeCellData, isDirectory);
        NodeData nodeData = null;
        nodeData = isDirectory ? new NodeData(url, parentFileTypeFilter, parentDirectoryFilter) : new NodeData(url, parentFileTypeFilter, parentDirectoryFilter);
        jnode.setUserObject(nodeData);
        int childCount = parentNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            JMutableTreeNode child = (JMutableTreeNode)parentNode.getChildAt(i);
            JTreeCellData childTreeCell = child.getModel();
            String label = childTreeCell.getText();
            if (shortLabel.compareTo(label) < 0) {
                childCount = i;
            }
            ++i;
        }
        this._treeModel.insertNodeInto((MutableTreeNode)((Object)jnode), (MutableTreeNode)parentNode, childCount);
        return jnode;
    }

    private void addChildrenFromFileSystem(JMutableTreeNode parent) {
        NodeData nodeData = (NodeData)parent.getUserObject();
        JMutableTreeNode newlyAddedChildNode = null;
        URL[] urlFileList = URLFileSystem.list((URL)nodeData.getURL());
        JMutableTreeNode representativeNode = null;
        int i = 0;
        while (i < urlFileList.length) {
            block7: {
                block6: {
                    if (URLFileSystem.isDirectory((URL)urlFileList[i])) break block6;
                    String suffix = URLFileSystem.getSuffix((URL)urlFileList[i]);
                    if (this._jwsOnly && !suffix.equals(WORKSPACE_FILE_EXT) || this._jwsExcluded && suffix.equals(WORKSPACE_FILE_EXT) || this._jprOnly && !suffix.equals(PROJECT_FILE_EXT) || this._jprExcluded && suffix.equals(PROJECT_FILE_EXT)) break block7;
                }
                if ((newlyAddedChildNode = this.createAndAdd(parent, urlFileList[i])) != null && representativeNode == null) {
                    representativeNode = newlyAddedChildNode;
                }
            }
            ++i;
        }
        if (representativeNode != null) {
            representativeNode.ascendingUpdateNodes();
            this._treeModel.reload((TreeNode)parent);
        }
    }

    public List getSelectedFileList(Component parent, boolean copyNow) {
        int retval;
        this._selectedFiles = new ArrayList();
        this.collectFileList(this._rootNode, this._selectedFiles);
        int selFileCount = this._selectedFiles.size();
        int i = 0;
        while (i < selFileCount) {
            this.handleFile((URL)this._selectedFiles.get(i), this._expandedFiles);
            ++i;
        }
        this._selectedFiles.clear();
        this._selectedFiles.addAll(this._expandedFiles);
        this._expandedFiles.clear();
        if (this._inputDirectories.size() > 0) {
            this.expandDirectories(parent);
        }
        if (this._jdevFiles.size() > 0 && (retval = JOptionPane.showConfirmDialog(parent, DirOptionsArb.getString((int)2), DirOptionsArb.getString((int)8), 0)) == 0) {
            this.resolveProjectsToWorkspaces(this._jdevFiles);
            this._selectedFiles.addAll(this._jdevFiles);
            this._jdevFiles.clear();
            this._expandedFiles.clear();
            this._inputDirectories.clear();
            return this._selectedFiles;
        }
        this._selectedFiles.addAll(this._expandedFiles);
        this._inputDirectories.clear();
        this._expandedFiles.clear();
        this._jdevFiles.clear();
        if (this._copyCheckBox.isSelected() && copyNow) {
            this.copyFilesToProject(parent);
            return this._copiedFiles;
        }
        return this._selectedFiles;
    }

    private void resolveProjectsToWorkspaces(ArrayList jdevFiles) {
        ArrayList<URL> workspFiles = new ArrayList<URL>();
        ArrayList<URL> projFiles = new ArrayList<URL>();
        int len = jdevFiles.size();
        String suffix = null;
        URL url = null;
        int i = 0;
        while (i < len) {
            url = (URL)jdevFiles.get(i);
            suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equalsIgnoreCase(WORKSPACE_FILE_EXT)) {
                workspFiles.add(url);
            } else {
                projFiles.add(url);
            }
            ++i;
        }
        len = workspFiles.size();
        Workspace workspace = null;
        URL workspaceURL = null;
        int i2 = 0;
        while (i2 < len) {
            workspaceURL = (URL)workspFiles.get(i2);
            try {
                Object2Dom o2d = Object2Dom.newInstance();
                workspace = (Workspace)o2d.toObject(workspaceURL);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            List childList = workspace.getListOfChildren();
            int childCount = childList.size();
            Reference ref = null;
            int k = 0;
            while (k < childCount) {
                ref = (Reference)childList.get(k);
                URL refURL = ref.getURL();
                int index = projFiles.indexOf(refURL);
                if (index != -1) {
                    projFiles.remove(index);
                }
                ++k;
            }
            jdevFiles.clear();
            jdevFiles.addAll(workspFiles);
            jdevFiles.addAll(projFiles);
            ++i2;
        }
    }

    private void collectFileList(JMutableTreeNode node, List output) {
        if (node.isLeaf()) {
            this.collectIfChecked(node, output);
        } else if (node.getChildCount() > 0) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                JMutableTreeNode child = (JMutableTreeNode)children.nextElement();
                this.collectFileList(child, output);
            }
        } else {
            JTreeCellData treeCellData = node.getModel();
            if (treeCellData.getHasCheckBox() && treeCellData.getCheckBoxState() == TriStateBoolean.TRUE) {
                NodeData nodeData = (NodeData)node.getUserObject();
                this._inputDirectories.add(nodeData);
            }
        }
    }

    private void collectIfChecked(JMutableTreeNode node, List output) {
        NodeData nodeData = (NodeData)node.getUserObject();
        JTreeCellData treeCellData = node.getModel();
        if (treeCellData.getHasCheckBox() && treeCellData.getCheckBoxState() == TriStateBoolean.TRUE) {
            output.add(nodeData.getURL());
        }
    }

    private List getTopLevelUserSelections() {
        ArrayList<URL> urlList = new ArrayList<URL>(this._rootNode.getChildCount());
        Enumeration e = this._rootNode.children();
        while (e.hasMoreElements()) {
            JMutableTreeNode jnode = (JMutableTreeNode)e.nextElement();
            NodeData nodeData = (NodeData)jnode.getUserObject();
            URL nodeURL = nodeData.getURL();
            URL parentDir = URLFileSystem.getParent((URL)nodeURL);
            if (parentDir == null || urlList.contains(parentDir)) continue;
            urlList.add(parentDir);
        }
        return urlList;
    }

    private void applyFilter(JMutableTreeNode node, FileFilter filter, int filterType, boolean processChildren) {
        NodeData nodeData = (NodeData)node.getUserObject();
        URL url = nodeData.getURL();
        if (url == null) {
            return;
        }
        JTreeCellData treeCellData = node.getModel();
        boolean checked = true;
        boolean isDirectory = URLFileSystem.isDirectory((URL)url);
        if (isDirectory && filterType == 1) {
            checked = this.canFileBeAddedToList(url, filter.getList(), 1);
            nodeData.setDirectoryFilter(filter);
            this.updateCheckBoxState(node, treeCellData, checked, isDirectory);
        } else if (isDirectory && filterType == 0) {
            nodeData.setFileTypeFilter(filter);
        } else if (!isDirectory && filterType == 0) {
            checked = this.canFileBeAddedToList(url, filter.getList(), 0);
            this.updateCheckBoxState(node, treeCellData, checked, isDirectory);
        } else if (!isDirectory && filterType == 1) {
            return;
        }
        if (!node.isLeaf() && processChildren && node.getChildCount() > 0) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                JMutableTreeNode child = (JMutableTreeNode)children.nextElement();
                NodeData childNodeData = (NodeData)child.getUserObject();
                URL childUrl = childNodeData.getURL();
                if (URLFileSystem.isDirectory((URL)childUrl)) {
                    if (filterType == 1 && !checked) {
                        return;
                    }
                    this.applyFilter(child, filter, filterType, filter.getRecurseDirectories());
                    continue;
                }
                if (filterType != 0) continue;
                this.applyFilter(child, filter, filterType, false);
            }
        }
    }

    private void updateCheckBoxState(JMutableTreeNode node, JTreeCellData treeCellData, boolean checked, boolean isDirectory) {
        TriStateBoolean tsBoolean = treeCellData.getCheckBoxState();
        if (isDirectory && checked && (tsBoolean.isTriState() || tsBoolean.isUndef())) {
            return;
        }
        if (isDirectory && checked && tsBoolean.isFalse() && node.getChildCount() > 0) {
            this.reapplyExistingFilters(node);
            JMutableTreeNode childNode = (JMutableTreeNode)node.getChildAt(0);
            childNode.ascendingUpdateNodes();
        } else if (tsBoolean.isTriState() || tsBoolean.isUndef() || tsBoolean.isTrue() && !checked || tsBoolean.isFalse() && checked) {
            treeCellData.setCheckBoxState(checked);
            DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
            treeModel.nodeChanged((TreeNode)node);
            node.selectDescendants(checked);
            node.updateNodes();
        }
    }

    private void reapplyExistingFilters(JMutableTreeNode node) {
        block4: {
            NodeData nodeData = (NodeData)node.getUserObject();
            URL url = nodeData.getURL();
            if (url == null) {
                return;
            }
            JTreeCellData treeCellData = node.getModel();
            if (!URLFileSystem.isDirectory((URL)url)) {
                return;
            }
            DirectoryExcludeFilter directoryFilter = nodeData.getDirectoryFilter();
            FileTypeIncludeFilter fileFilter = nodeData.getFileTypeFilter();
            if (node.getChildCount() <= 0) break block4;
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                JTreeCellData tcd;
                JMutableTreeNode child = (JMutableTreeNode)children.nextElement();
                NodeData childNodeData = (NodeData)child.getUserObject();
                URL childUrl = childNodeData.getURL();
                boolean isDirectory = URLFileSystem.isDirectory((URL)childUrl);
                boolean checked = true;
                if (isDirectory && directoryFilter != null) {
                    checked = this.canFileBeAddedToList(childUrl, directoryFilter.getList(), 1);
                    this.updateCheckBoxState(child, child.getModel(), checked, isDirectory);
                    this.reapplyExistingFilters(child);
                    if (child.getChildCount() <= 0) continue;
                    JMutableTreeNode childsChild = (JMutableTreeNode)child.getChildAt(0);
                    childsChild.ascendingUpdateNodes();
                    continue;
                }
                if (isDirectory || fileFilter == null || !(tcd = child.getModel()).isCheckBoxSelectable()) continue;
                checked = this.canFileBeAddedToList(childUrl, fileFilter.getList(), 0);
                this.updateCheckBoxState(child, child.getModel(), checked, isDirectory);
            }
            JMutableTreeNode cnode = (JMutableTreeNode)node.getChildAt(0);
            cnode.ascendingUpdateNodes();
        }
    }

    private void saveFilter(FileFilter filter, int filterType) {
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExts = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ExcludeFilterSettings excludeFilterSettings = documentExts.getExcludeFilterSettings();
        if (excludeFilterSettings == null) {
            excludeFilterSettings = new ExcludeFilterSettings();
            documentExts.setExcludeFilterSettings(excludeFilterSettings);
        }
        if (filterType == 0) {
            excludeFilterSettings.setFileTypeIncludeFilter((FileTypeIncludeFilter)filter);
        } else {
            excludeFilterSettings.setDirectoryExcludeFilter((DirectoryExcludeFilter)filter);
        }
    }

    private FileFilter getOrCreateFilter(int filterType) {
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExts = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ExcludeFilterSettings excludeFilterSettings = documentExts.getExcludeFilterSettings();
        Object settingsFilter = null;
        if (excludeFilterSettings != null) {
            settingsFilter = filterType == 0 ? excludeFilterSettings.getFileTypeIncludeFilter() : excludeFilterSettings.getDirectoryExcludeFilter();
        }
        if (settingsFilter == null) {
            settingsFilter = filterType == 0 ? new FileTypeIncludeFilter() : new DirectoryExcludeFilter();
        }
        return settingsFilter;
    }

    private JMutableTreeNode getNearestDirectory() {
        JMutableTreeNode curNode = (JMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (curNode.isLeaf()) {
            return (JMutableTreeNode)curNode.getParent();
        }
        return curNode;
    }

    private URL findParentURLInList(URL url, List list) {
        int i = 0;
        while (i < list.size()) {
            if (URLFileSystem.isBaseURLFor((URL)((URL)list.get(i)), (URL)url)) {
                return (URL)list.get(i);
            }
            ++i;
        }
        return null;
    }

    private void copyFilesToProject(Component parent) {
        this._runOption = 1;
        this._copiedFiles = new ArrayList(this._selectedFiles.size());
        this._progressBar = new ProgressBar(parent, DirOptionsArb.getString((int)26), (Runnable)this, true);
        this._progressBar.start(DirOptionsArb.getString((int)23), null);
        this._progressBar.waitUntilDone();
        boolean userCancelled = false;
        if (this._progressBar.hasUserCancelled()) {
            int retval = JOptionPane.showConfirmDialog(parent, DirOptionsArb.getString((int)10), DirOptionsArb.getString((int)14), 0);
            if (retval == 0) {
                Iterator iterator = this._copiedFiles.iterator();
                while (iterator.hasNext()) {
                    URLFileSystem.delete((URL)((URL)iterator.next()));
                    iterator.remove();
                }
            }
            userCancelled = true;
        }
        if (this._selectedFiles.size() > 0 && !userCancelled) {
            JOptionPane.showMessageDialog(parent, DirOptionsArb.getString((int)1), DirOptionsArb.getString((int)0), 0);
        }
    }

    public void _fileTypeBtn_actionPerformed(ActionEvent e) {
        FileTypeIncludeFilterPanel filterPanel;
        JMutableTreeNode dirNode = this.getNearestDirectory();
        String selectedDir = dirNode.getModel().getText();
        NodeData nodeData = (NodeData)dirNode.getUserObject();
        FileTypeIncludeFilter settingsFilter = nodeData.getFileTypeFilter();
        FileTypeIncludeFilter dialogFilter = new FileTypeIncludeFilter();
        if (settingsFilter != null) {
            settingsFilter.copyTo((Object)dialogFilter);
        }
        if ((filterPanel = new FileTypeIncludeFilterPanel(dialogFilter)).showDialog((Component)((Object)this), selectedDir) && (settingsFilter == null || !settingsFilter.equals((Object)dialogFilter))) {
            this.saveFilter((FileFilter)dialogFilter, 0);
            if (dialogFilter.getApplyToDirectory() == 0) {
                Enumeration e2 = this._rootNode.children();
                while (e2.hasMoreElements()) {
                    this.applyFilter((JMutableTreeNode)e2.nextElement(), (FileFilter)dialogFilter, 0, true);
                }
            } else {
                this.applyFilter(dirNode, (FileFilter)dialogFilter, 0, true);
            }
        }
    }

    public void _addBtn_actionPerformed(ActionEvent e) {
        URL[] selectedURLs;
        URLChooser chooser = null;
        if (this._lastURLDirectory == null) {
            chooser = DialogUtil.newURLChooser();
            DialogUtil.initURLChooser((URLChooser)chooser, (Context)this._context);
        } else {
            chooser = DialogUtil.newURLChooser((URL)this._lastURLDirectory);
        }
        chooser.setSelectionScope(2);
        int returnVal = chooser.showOpenDialog((Component)((Object)this), DirOptionsArb.getString((int)20));
        if (returnVal == 0 && (selectedURLs = chooser.getSelectedURLs()) != null) {
            this.populateTree(selectedURLs);
            this._fileTypeBtn.setEnabled(true);
            this._dirFilterBtn.setEnabled(true);
            this._removeBtn.setEnabled(true);
        }
        if (this._tree.getSelectionCount() == 0) {
            this._tree.setSelectionRow(0);
        }
    }

    public void _removeBtn_actionPerformed(ActionEvent e) {
        TreePath treePath = this._tree.getSelectionPath();
        JMutableTreeNode node = (JMutableTreeNode)treePath.getLastPathComponent();
        node.removeFromParent();
        this._treeModel.reload((TreeNode)this._rootNode);
        if (this._tree.getRowCount() == 0) {
            this._removeBtn.setEnabled(false);
        }
    }

    public void _dirFilterBtn_actionPerformed(ActionEvent e) {
        DirectoryExcludeFilterPanel filterPanel;
        JMutableTreeNode dirNode = this.getNearestDirectory();
        String selectedDir = dirNode.getModel().getText();
        NodeData nodeData = (NodeData)dirNode.getUserObject();
        DirectoryExcludeFilter settingsFilter = nodeData.getDirectoryFilter();
        DirectoryExcludeFilter dialogFilter = new DirectoryExcludeFilter();
        if (settingsFilter != null) {
            settingsFilter.copyTo((Object)dialogFilter);
        }
        if ((filterPanel = new DirectoryExcludeFilterPanel()).showDialog((Component)((Object)this), dialogFilter, selectedDir) && (settingsFilter == null || !settingsFilter.equals((Object)dialogFilter))) {
            this.saveFilter((FileFilter)dialogFilter, 1);
            if (dialogFilter.getApplyToDirectory() == 0) {
                Enumeration en = this._rootNode.children();
                while (en.hasMoreElements()) {
                    this.applyFilter((JMutableTreeNode)en.nextElement(), (FileFilter)dialogFilter, 1, true);
                }
            } else {
                this.applyFilter(dirNode, (FileFilter)dialogFilter, 1, true);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath treePath = event.getNewLeadSelectionPath();
        if (treePath == null) {
            this._fileTypeBtn.setEnabled(false);
            this._dirFilterBtn.setEnabled(false);
            this._removeBtn.setEnabled(false);
        } else {
            this._fileTypeBtn.setEnabled(true);
            this._dirFilterBtn.setEnabled(true);
            this._removeBtn.setEnabled(true);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        JMutableTreeNode node = (JMutableTreeNode)path.getLastPathComponent();
        if (!node.isLeaf()) {
            6 runnable = new 6(this, node);
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private String getPackage(URL url) {
        String pkg;
        block14: {
            pkg = "";
            try {
                TextNode textNode;
                TextBuffer txtBuf;
                Node node = NodeFactory.findOrCreate((URL)url);
                if (!(node instanceof TextNode) || (txtBuf = (textNode = (TextNode)node).acquireTextBuffer()) == null) break block14;
                txtBuf.readLock();
                try {
                    JavaLexer lexer = new JavaLexer();
                    lexer.setTextBuffer((ReadTextBuffer)txtBuf);
                    lexer.setPosition(0);
                    lexer.setSkipComments(true);
                    LexerToken lexTkn = lexer.createLexerToken();
                    int tkn = lexer.lex(lexTkn);
                    if (tkn == 125) {
                        FastStringBuffer buf = new FastStringBuffer();
                        boolean foundDot = false;
                        block10: while (true) {
                            switch (lexer.lex(lexTkn)) {
                                case 4: {
                                    if (foundDot) {
                                        buf.append('.');
                                        foundDot = false;
                                    }
                                    int start = lexTkn.getStartOffset();
                                    int len = lexTkn.getEndOffset() - start;
                                    buf.append(txtBuf.getChars(start, len));
                                    continue block10;
                                }
                                case 43: {
                                    foundDot = true;
                                    continue block10;
                                }
                            }
                            break;
                        }
                        buf.append("/");
                        pkg = buf.toString();
                    }
                }
                finally {
                    txtBuf.readUnlock();
                    textNode.releaseTextBuffer();
                }
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException iaex) {
                // empty catch block
            }
        }
        if (pkg.length() == 0) {
            return null;
        }
        return pkg.replace('.', '/');
    }

    static void mav$addChildrenFromFileSystem(DirectoryOptionsPanel directoryOptionsPanel, JMutableTreeNode jMutableTreeNode) {
        directoryOptionsPanel.addChildrenFromFileSystem(jMutableTreeNode);
    }

    static DefaultTreeModel ra$_treeModel(DirectoryOptionsPanel directoryOptionsPanel) {
        return directoryOptionsPanel._treeModel;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DirectoryOptionsPanel.this._dirFilterBtn_actionPerformed(e);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DirectoryOptionsPanel.this._fileTypeBtn_actionPerformed(e);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DirectoryOptionsPanel.this._removeBtn_actionPerformed(e);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DirectoryOptionsPanel.this._addBtn_actionPerformed(e);
        }
    }

    final class 5
    extends JMutableTreeNode {
        public boolean isLeaf() {
            return this.allowsChildren ^ true;
        }

        public 5(JTreeCellData jTreeCellData, boolean bl) {
            super(jTreeCellData, bl);
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ JMutableTreeNode v$node;
        final /* synthetic */ DirectoryOptionsPanel this$0;

        public void run() {
            Ide.getWaitCursor().show();
            try {
                if (this.v$node.getChildCount() == 0) {
                    DirectoryOptionsPanel.mav$addChildrenFromFileSystem(this.this$0, this.v$node);
                    DirectoryOptionsPanel.ra$_treeModel(this.this$0).reload((TreeNode)this.v$node);
                }
            }
            finally {
                Ide.getWaitCursor().hide();
            }
        }

        public 6(DirectoryOptionsPanel directoryOptionsPanel, JMutableTreeNode jMutableTreeNode) {
            this.v$node = jMutableTreeNode;
            this.this$0 = directoryOptionsPanel;
        }
    }

    private static class NodeData {
        private URL _url;
        private FileTypeIncludeFilter _fileTypeFilter;
        private DirectoryExcludeFilter _directoryFilter;

        public NodeData(URL url, FileTypeIncludeFilter fileTypeFilter, DirectoryExcludeFilter directoryFilter) {
            this._url = url;
            this._fileTypeFilter = fileTypeFilter;
            this._directoryFilter = directoryFilter;
        }

        public NodeData(URL url) {
            this(url, null, null);
        }

        public URL getURL() {
            return this._url;
        }

        public FileTypeIncludeFilter getFileTypeFilter() {
            return this._fileTypeFilter;
        }

        public void setFileTypeFilter(FileFilter fileTypeFilter) {
            this._fileTypeFilter = (FileTypeIncludeFilter)fileTypeFilter;
        }

        public DirectoryExcludeFilter getDirectoryFilter() {
            return this._directoryFilter;
        }

        public void setDirectoryFilter(FileFilter directoryFilter) {
            this._directoryFilter = (DirectoryExcludeFilter)directoryFilter;
        }
    }
}

