/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;

public class FileTypeIncludeFilterPanel
extends JPanel
implements ListSelectionListener {
    private JLabel _listPanelLbl;
    private CheckBoxListPanel _listPanel;
    private FileTypeIncludeFilter _filter;
    private JLabel _otherLbl;
    private JTextField _otherFld;
    private JRadioButton _selectedDirRB;
    private JRadioButton _allDirRB;
    private ButtonGroup _buttonGroup;
    private JCheckBox _recurseCB;
    private JButton _addToListBtn;
    private JButton _removeFromListBtn;
    private JRadioButton _allTypesRB;
    private JRadioButton _selectedTypesRB;
    private ButtonGroup _typeButtonGroup;
    private static final String HELP_TOPIC = "f1_idedfiletypestoexclude_html";

    private void $init$() {
        this._listPanelLbl = new JLabel();
        this._otherLbl = new JLabel();
        this._otherFld = new JTextField();
        this._selectedDirRB = new JRadioButton();
        this._allDirRB = new JRadioButton();
        this._buttonGroup = new ButtonGroup();
        this._recurseCB = new JCheckBox();
        this._addToListBtn = new JButton();
        this._removeFromListBtn = new JButton();
        this._allTypesRB = new JRadioButton();
        this._selectedTypesRB = new JRadioButton();
        this._typeButtonGroup = new ButtonGroup();
    }

    public FileTypeIncludeFilterPanel(FileTypeIncludeFilter filter) {
        this.$init$();
        this._filter = filter;
        this.initPanel(true);
    }

    public FileTypeIncludeFilterPanel(FileTypeIncludeFilter filter, boolean showDir) {
        this.$init$();
        this._filter = filter;
        this.initPanel(showDir);
    }

    private void initPanel(boolean showDirectory) {
        ResourceUtils.resButton((AbstractButton)this._allTypesRB, (String)DialogsArb.getString((int)3));
        ResourceUtils.resButton((AbstractButton)this._selectedTypesRB, (String)DialogsArb.getString((int)2));
        ResourceUtils.resButton((AbstractButton)this._allDirRB, (String)DialogsArb.getString((int)13));
        ResourceUtils.resLabel((JLabel)this._otherLbl, (Component)this._otherFld, (String)DialogsArb.getString((int)14));
        ResourceUtils.resButton((AbstractButton)this._recurseCB, (String)DialogsArb.getString((int)33));
        ResourceUtils.resButton((AbstractButton)this._addToListBtn, (String)DialogsArb.getString((int)19));
        this._addToListBtn.setEnabled(false);
        this._addToListBtn.addActionListener(new 1());
        ResourceUtils.resButton((AbstractButton)this._removeFromListBtn, (String)DialogsArb.getString((int)6));
        this._removeFromListBtn.setEnabled(false);
        this._removeFromListBtn.addActionListener(new 2());
        this._otherFld.getDocument().addDocumentListener(new 3());
        this._listPanel = new CheckBoxListPanel(this._filter.getListModel());
        this._listPanel.getScrollPane().getViewport().setViewSize(new Dimension(100, 200));
        ResourceUtils.resLabel((JLabel)this._listPanelLbl, (Component)this._listPanel.getList(), (String)DialogsArb.getString((int)10));
        this._listPanel.addButton(this._removeFromListBtn);
        this._listPanel.layoutButtons();
        this.setLayout(new GridBagLayout());
        this._typeButtonGroup.add(this._allTypesRB);
        this._typeButtonGroup.add(this._selectedTypesRB);
        this.add((Component)this._allTypesRB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._allTypesRB.setSelected(true);
        this.add((Component)this._selectedTypesRB, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this._selectedTypesRB, new Component[]{this._listPanel.getList(), this._listPanel.getSelectAllButton(), this._listPanel.getDeselectAllButton(), this._otherFld, this._recurseCB, this._allDirRB, this._selectedDirRB});
        this.add((Component)this._listPanelLbl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._listPanel, new GridBagConstraints(0, 3, 3, 4, 1.0, 1.0, 17, 1, new Insets(0, 5, 15, 0), 0, 0));
        this.add((Component)this._otherLbl, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._otherFld, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._addToListBtn, new GridBagConstraints(2, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        if (showDirectory) {
            this._buttonGroup.add(this._selectedDirRB);
            this._buttonGroup.add(this._allDirRB);
            this._allDirRB.setSelected(true);
            this.add((Component)this._allDirRB, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            this._recurseCB.setSelected(true);
            this.add((Component)this._selectedDirRB, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this._recurseCB, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        }
        this._listPanel.getList().addListSelectionListener((ListSelectionListener)this);
        this._listPanel.getList().setSelectionMode(0);
    }

    public boolean showDialog(Component parent, String selectedDir) {
        if (this._filter == null) {
            this._filter = new FileTypeIncludeFilter();
        }
        ResourceUtils.resButton((AbstractButton)this._selectedDirRB, (String)DialogsArb.format((int)28, (Object)selectedDir));
        JEWTDialog dialog = this.createDialog(parent);
        if (dialog == null) {
            return false;
        }
        if (dialog.runDialog()) {
            this.commitTo(this._filter);
            return true;
        }
        return false;
    }

    public boolean showDialog(Component parent) {
        JEWTDialog dialog = this.createDialog(parent);
        if (dialog == null) {
            return false;
        }
        if (dialog.runDialog()) {
            this.commitTo(this._filter);
            return true;
        }
        return false;
    }

    protected JEWTDialog createDialog(Component parent) {
        this._filter.clearAllSelectedFilters();
        this._filter.populateListModel();
        this.loadFrom(this._filter);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (dialog == null) {
            return null;
        }
        dialog.setCenterOver(parent);
        dialog.setContent((Component)this);
        dialog.setInitialFocus((Component)this._listPanel.getList());
        dialog.setTitle(DialogsArb.getString((int)9));
        dialog.setButtonMask(7);
        dialog.setResizable(true);
        dialog.setPreferredSize(new Dimension(400, 500));
        return dialog;
    }

    private void loadFrom(FileTypeIncludeFilter filter) {
        if (filter.getIncludeAllFiles()) {
            this._allTypesRB.setSelected(true);
        } else {
            this._selectedTypesRB.setSelected(true);
        }
        this._recurseCB.setSelected(filter.getRecurseDirectories());
        if (filter.getApplyToDirectory() == 1) {
            this._selectedDirRB.setSelected(true);
            this._allDirRB.setSelected(false);
        } else {
            this._selectedDirRB.setSelected(false);
            this._allDirRB.setSelected(true);
        }
        String exclusions = filter.getUserDefinedExclusions();
        if (ModelUtil.hasLength((String)exclusions)) {
            this._otherFld.setText(exclusions);
            this._addToListBtn.setEnabled(true);
        } else {
            this._addToListBtn.setEnabled(false);
        }
    }

    private void commitTo(FileTypeIncludeFilter filter) {
        filter.setIncludeAllFiles(this._allTypesRB.isSelected());
        filter.setRecurseDirectories(this._recurseCB.isSelected());
        int applyValue = this._selectedDirRB.isSelected() ? 1 : 0;
        filter.setApplyToDirectory(applyValue);
        filter.setUserDefinedExclusions(this._otherFld.getText());
        filter.setSelectedFilters();
    }

    private void _addToListBtn_actionPerformed(ActionEvent e) {
        StringTokenizer st = new StringTokenizer(this._otherFld.getText(), ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this._filter.addUserDefinedValueToList(token)) continue;
            JOptionPane.showMessageDialog(this, DialogsArb.format((int)8, (Object)token), DialogsArb.getString((int)0), 0);
        }
        this._otherFld.setText("");
        this._addToListBtn.setEnabled(false);
    }

    private void _removeFromListBtn_actionPerformed(ActionEvent e) {
        int selIndex = this._listPanel.getList().getSelectedIndex();
        this._filter.removeUserDefinedValueFromList(selIndex);
        selIndex = Math.min(selIndex, this._listPanel.getList().getModel().getSize() - 1);
        this._listPanel.getList().setSelectedIndex(selIndex);
        this._listPanel.getList().requestFocus();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int idx = this._listPanel.getList().getSelectedIndex();
        if (idx < 0 || idx > this._listPanel.getList().getModel().getSize() - 1) {
            return;
        }
        if (this._filter.isListElementLocked(idx)) {
            this._removeFromListBtn.setEnabled(false);
        } else {
            this._removeFromListBtn.setEnabled(true);
        }
    }

    static void mav$_addToListBtn_actionPerformed(FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel, ActionEvent actionEvent) {
        fileTypeIncludeFilterPanel._addToListBtn_actionPerformed(actionEvent);
    }

    static void mav$_removeFromListBtn_actionPerformed(FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel, ActionEvent actionEvent) {
        fileTypeIncludeFilterPanel._removeFromListBtn_actionPerformed(actionEvent);
    }

    static JButton ra$_addToListBtn(FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel) {
        return fileTypeIncludeFilterPanel._addToListBtn;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FileTypeIncludeFilterPanel.mav$_addToListBtn_actionPerformed(FileTypeIncludeFilterPanel.this, e);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FileTypeIncludeFilterPanel.mav$_removeFromListBtn_actionPerformed(FileTypeIncludeFilterPanel.this, e);
        }
    }

    final class 3
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            FileTypeIncludeFilterPanel.ra$_addToListBtn(FileTypeIncludeFilterPanel.this).setEnabled(e.getDocument().getLength() > 0);
        }

        public void removeUpdate(DocumentEvent e) {
            FileTypeIncludeFilterPanel.ra$_addToListBtn(FileTypeIncludeFilterPanel.this).setEnabled(e.getDocument().getLength() > 0);
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

