/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryReference;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.registry.AntRegistry;

public class AntRunConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = AntRunConfiguration.class.getName();
    public static final String ANT_HOME = "antHome";
    public static final String BUILDFILE_URL = "buildfileURL";
    public static final String TARGET_LIST = "targetList";
    public static final String JDK_VERSION = "jdkVersion";
    public static final String CLASSPATH = "classpath";
    public static final String PROPERTY_NAMES = "propertyNames";
    public static final String PROPERTY_VALUES = "propertyValues";
    public static final String PROPERTY_FILES = "propertyFiles";
    public static final String RUN_IN_PROCESS = "runInProcess";
    public static final String OUTPUT_LEVEL = "outputLevel";
    public static final String KEEP_GOING = "keepGoing";
    public static final String INPUT_FILE = "inputFile";
    public static final String USE_INPUT_FILE = "useInputFile";
    public static final String JAVA_ARGS = "javaArgs";
    public static final String WORKING_DIR = "workingDir";
    public static final String ENV_NAMES = "envNames";
    public static final String ENV_VALUES = "envValues";
    public static final String USER_JARS = "userJars";
    public static final String CLEAR_LOG = "clearLog";
    private static final String JDEV_ANT_JAR = "jdev.jar";
    private static final String USER_LIBDIR = ".ant/lib";
    private static final String SAX_PARSER_FACTORY = "META-INF/services/javax.xml.parsers.SAXParserFactory";
    private static final String DOCUMENT_BUILDER_FACTORY = "META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private static final String TRANSFORMER_FACTORY = "META-INF/services/javax.xml.transform.TransformerFactory";
    private static final String MIME_MAILER = "org.apache.tools.ant.taskdefs.email.MimeMailer";
    private static final String MESSAGING_EXCEPTION = "javax.mail.MessagingException";
    private static final String DATA_SOURCE = "javax.activation.DataSource";
    private JDK jdk;

    public AntRunConfiguration() {
        this(HashStructure.newInstance());
    }

    private AntRunConfiguration(HashStructure hash) {
        super(hash);
    }

    public static AntRunConfiguration getInstance(HashStructure hs) {
        return new AntRunConfiguration(hs);
    }

    public static AntRunConfiguration getInstance(PropertyStorage project) {
        return new AntRunConfiguration(project.getProperties().getOrCreateHashStructure(DATA_KEY));
    }

    public boolean isClearLogBeforeRun() {
        return this._hash.getBoolean(CLEAR_LOG, true);
    }

    public void setClearLogBeforeRun(boolean clearLogBeforeRun) {
        this._hash.putBoolean(CLEAR_LOG, clearLogBeforeRun);
    }

    public boolean isInProcess() {
        return this._hash.getBoolean(RUN_IN_PROCESS, true);
    }

    public void setInProcess(boolean inProcess) {
        this._hash.putBoolean(RUN_IN_PROCESS, inProcess);
    }

    public int getOutputLevel() {
        return this._hash.getInt(OUTPUT_LEVEL, 2);
    }

    public void setOutputLevel(int outputLevel) {
        this._hash.putInt(OUTPUT_LEVEL, outputLevel);
    }

    public boolean getKeepGoing() {
        return this._hash.getBoolean(KEEP_GOING, false);
    }

    public void setKeepGoing(boolean keepGoing) {
        this._hash.putBoolean(KEEP_GOING, keepGoing);
    }

    public boolean getUseInputFile() {
        return this._hash.getBoolean(USE_INPUT_FILE, false);
    }

    public void setUseInputFile(boolean useInputFile) {
        this._hash.putBoolean(USE_INPUT_FILE, useInputFile);
    }

    public URL getInputFile() {
        return this._hash.getURL(INPUT_FILE, null);
    }

    public void setInputFile(URL inputFile) {
        this._hash.putURL(INPUT_FILE, inputFile, true);
    }

    public URL getAntHome() {
        return this._hash.getURL(ANT_HOME, null);
    }

    public void setAntHome(URL antHome) {
        this._hash.putURL(ANT_HOME, antHome, true);
    }

    public void setJDKReference(LibraryReference ref) {
        if (ref != null) {
            HashStructure struct = this._hash.getOrCreateHashStructure(JDK_VERSION);
            LibraryReference copy = new LibraryReference(struct);
            ref.copyTo((Object)copy);
        } else {
            this._hash.remove(JDK_VERSION);
        }
    }

    public LibraryReference getJDKReference() {
        HashStructure struct = this._hash.getHashStructure(JDK_VERSION);
        if (struct != null) {
            return new LibraryReference(struct);
        }
        return null;
    }

    public void setJDK(JDK jdk) throws TransientMarker {
        this.jdk = jdk;
        if (jdk == null) {
            this._hash.remove(JDK_VERSION);
        } else {
            HashStructure struct = this._hash.getOrCreateHashStructure(JDK_VERSION);
            LibraryReference ref = new LibraryReference(struct);
            ref.setLibrary((Library)jdk);
        }
    }

    public JDK getJDK(Project project) throws TransientMarker {
        JDK jdk = this.jdk;
        if (jdk == null) {
            LibraryReference ref;
            HashStructure struct = this._hash.getHashStructure(JDK_VERSION);
            if (struct != null && (ref = new LibraryReference(struct)) != null) {
                if (project != null) {
                    JProjectLibraryList list = JProjectLibraries.getInstance((PropertyStorage)project).getProjectLibraryList();
                    JDK jDK = jdk = list != null ? list.findJDK(ref.getID()) : null;
                }
                if (jdk == null && ref.isJDK()) {
                    jdk = (JDK)ref.getLibrary();
                }
            }
            if (jdk == null) {
                jdk = project != null ? JProjectLibraries.getInstance((PropertyStorage)project).getJDK() : JLibraryManager.getDefaultJDK();
            }
        }
        return jdk;
    }

    public URL getBuildfile() {
        return this._hash.getURL(BUILDFILE_URL, null);
    }

    public void setBuildfile(URL buildfile) {
        this._hash.putURL(BUILDFILE_URL, buildfile, true);
    }

    public List getTargetList() {
        ListStructure list = this._hash.getListStructure(TARGET_LIST);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setTargetList(List targets) {
        if (targets == null) {
            this._hash.remove(TARGET_LIST);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(TARGET_LIST);
            list.mirror(targets);
        }
    }

    public void addTarget(String target) {
        ListStructure list = this._hash.getOrCreateListStructure(TARGET_LIST);
        if (!list.contains((Object)target)) {
            list.add((Object)target);
        }
    }

    public void removeTarget(String target) {
        ListStructure list = this._hash.getListStructure(TARGET_LIST);
        if (list != null) {
            list.remove((Object)target);
        }
    }

    public void setClassPath(URLPath classpath) {
        if (classpath == null || classpath.size() == 0) {
            this._hash.remove(CLASSPATH);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(CLASSPATH);
            list.mirror(classpath.asList());
        }
    }

    public URLPath getClassPath() {
        return new URLPath(this._hash.getListStructure(CLASSPATH));
    }

    public boolean getIncludeUserJars() {
        return this._hash.getBoolean(USER_JARS, true);
    }

    public void setIncludeUserJars(boolean includeUserJars) {
        this._hash.putBoolean(USER_JARS, includeUserJars);
    }

    public void addProperty(String name, String value) {
        ListStructure names = this._hash.getOrCreateListStructure(PROPERTY_NAMES);
        ListStructure values = this._hash.getOrCreateListStructure(PROPERTY_VALUES);
        int index = names.indexOf((Object)name);
        if (index > 0) {
            values.set(index, (Object)value);
        } else {
            names.add((Object)name);
            values.add((Object)value);
        }
    }

    public void removeProperty(String name) {
        ListStructure names = this._hash.getOrCreateListStructure(PROPERTY_NAMES);
        ListStructure values = this._hash.getOrCreateListStructure(PROPERTY_VALUES);
        int index = names.indexOf((Object)name);
        if (index > 0) {
            names.remove(index);
            values.remove(index);
        }
    }

    public List getPropertyNames() {
        ListStructure list = this._hash.getListStructure(PROPERTY_NAMES);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setPropertyNames(List names) {
        if (names == null) {
            this._hash.remove(PROPERTY_NAMES);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(PROPERTY_NAMES);
            list.mirror(names);
        }
    }

    public List getPropertyValues() {
        ListStructure list = this._hash.getListStructure(PROPERTY_VALUES);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setPropertyValues(List values) {
        if (values == null) {
            this._hash.remove(PROPERTY_VALUES);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(PROPERTY_VALUES);
            list.mirror(values);
        }
    }

    public void addPropertyFile(String file) {
        this._hash.getOrCreateListStructure(PROPERTY_FILES).add((Object)file);
    }

    public void removePropertyFile(String file) {
        int index;
        ListStructure files = this._hash.getListStructure(PROPERTY_FILES);
        if (files != null && (index = files.indexOf((Object)file)) > 0) {
            files.remove(index);
        }
    }

    public List getPropertyFiles() {
        ListStructure list = this._hash.getListStructure(PROPERTY_FILES);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setPropertyFiles(List files) {
        if (files == null) {
            this._hash.remove(PROPERTY_FILES);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(PROPERTY_FILES);
            list.mirror(files);
        }
    }

    public void setJavaArgs(String javaArgs) {
        this._hash.putString(JAVA_ARGS, javaArgs, true);
    }

    public String getJavaArgs() {
        return this._hash.getString(JAVA_ARGS, null);
    }

    public void setWorkingDirectory(URL workingDir) {
        this._hash.putURL(WORKING_DIR, workingDir, true);
    }

    public URL getWorkingDirectory() {
        return this._hash.getURL(WORKING_DIR, null);
    }

    public List getEnvironmentNames() {
        ListStructure list = this._hash.getListStructure(ENV_NAMES);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setEnvironmentNames(List names) {
        if (names == null) {
            this._hash.remove(ENV_NAMES);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(ENV_NAMES);
            list.mirror(names);
        }
    }

    public List getEnvironmentValues() {
        ListStructure list = this._hash.getListStructure(ENV_VALUES);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setEnvironmentValues(List values) {
        if (values == null) {
            this._hash.remove(ENV_VALUES);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(ENV_VALUES);
            list.mirror(values);
        }
    }

    public void setEnvironmentVariable(String name, String value) {
        ListStructure names = this._hash.getOrCreateListStructure(ENV_NAMES);
        ListStructure values = this._hash.getOrCreateListStructure(ENV_VALUES);
        int index = names.indexOf((Object)name);
        if (index > 0) {
            values.set(index, (Object)value);
        } else {
            names.add((Object)name);
            values.add((Object)value);
        }
    }

    public String getEnvironmentVariable(String name) {
        ListStructure names = this._hash.getOrCreateListStructure(ENV_NAMES);
        int index = names.indexOf((Object)name);
        if (index > 0) {
            ListStructure values = this._hash.getOrCreateListStructure(ENV_VALUES);
            return (String)values.get(index);
        }
        return null;
    }

    public ClassLoader getAntClassLoader(Project project) {
        URLPath classPath = this.getAntClassPath(project);
        return new 1(classPath.getEntries(), null);
    }

    public URLPath getAntClassPath(Project project) {
        URLPath classPath = new URLPath();
        classPath.add(this.getClassPath());
        if (this.getIncludeUserJars()) {
            classPath.add(this.getUserJars());
        }
        classPath.add(AntRegistry.getExtensionAntRegistry().getClassPath());
        URL jdevAntJar = URLFactory.newFileURL((File)new File(Ide.getLibDirectory(), JDEV_ANT_JAR));
        classPath.add(jdevAntJar);
        AntVersion version = null;
        URL antHome = this.getAntHome();
        if (antHome != null) {
            version = AntVersion.createAntVersion(antHome);
        }
        if (version == null) {
            version = AntVersion.getDefaultAntVersion();
        }
        classPath.add(version.getClassPath());
        this.jdk = this.getJDK(project);
        if (this.jdk == null) {
            this.jdk = JLibraryManager.getDefaultJDK();
        }
        classPath.add(this.getJDKToolsJar(this.jdk));
        return classPath;
    }

    private URLPath getUserJars() {
        URLPath path = new URLPath();
        String userHome = System.getProperty("user.home");
        File userLibDir = new File(userHome, USER_LIBDIR);
        if (userLibDir.isDirectory()) {
            File[] matches = userLibDir.listFiles(new 2());
            int i = 0;
            while (i < matches.length) {
                try {
                    path.add(matches[i].toURL());
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
                ++i;
            }
        }
        return path;
    }

    private URL getJDKToolsJar(JDK jdk) {
        URL sdkDir;
        URL toolsJar = null;
        URL sdkBinDir = jdk.getSDKBinDir();
        if (sdkBinDir != null && (sdkDir = URLFileSystem.getParent((URL)sdkBinDir)) != null) {
            URL sdkLibDir = URLFactory.newURL((URL)sdkDir, (String)"lib");
            toolsJar = URLFactory.newURL((URL)sdkLibDir, (String)"tools.jar");
        }
        return toolsJar;
    }

    public HashStructure getHashStructure() {
        return super.getHashStructure();
    }

    final class 1
    extends URLClassLoader {
        protected Class findClass(String name) throws ClassNotFoundException {
            if (AntRunConfiguration.MIME_MAILER.equals(name)) {
                this.findClass(AntRunConfiguration.MESSAGING_EXCEPTION);
                this.findClass(AntRunConfiguration.DATA_SOURCE);
            }
            return super.findClass(name);
        }

        public InputStream getResourceAsStream(String name) {
            InputStream stream = super.getResourceAsStream(name);
            if (stream == null && (AntRunConfiguration.SAX_PARSER_FACTORY.equals(name) || AntRunConfiguration.DOCUMENT_BUILDER_FACTORY.equals(name) || AntRunConfiguration.TRANSFORMER_FACTORY.equals(name))) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return stream;
        }

        public 1(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }
    }

    final class 2
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

