/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.appresources;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractFolder
implements Folder,
Subject {
    protected final ArrayList _children;
    private final Subject _subject;

    private void $init$() {
        this._children = new ArrayList();
        this._subject = new IdeSubject();
    }

    public AbstractFolder() {
        this.$init$();
    }

    protected abstract void prepareChildren();

    public boolean canAdd(Element element) {
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element) {
        if (element != null) {
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                this.prepareChildren();
                if (!this._children.contains(element)) {
                    boolean bl = this._children.add(element);
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean canRemove(Element element) {
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element) {
        if (element != null) {
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                this.prepareChildren();
                if (this._children.contains(element)) {
                    boolean bl = this._children.remove(element);
                    return bl;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChild(Element child) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this.prepareChildren();
            boolean bl = this._children.contains(child);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this.prepareChildren();
            int n = this._children.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this.prepareChildren();
            this._children.clear();
        }
    }

    public void attach(Observer observer) {
        this._subject.attach(observer);
    }

    public void detach(Observer observer) {
        this._subject.detach(observer);
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        this._subject.notifyObservers(subject, change);
    }

    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this.prepareChildren();
            ArrayList copyOfChildArray = new ArrayList(this._children);
            Iterator iterator = copyOfChildArray.iterator();
            return iterator;
        }
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public Object getData() {
        return this;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }
}

