/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.appresources;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.jdeveloper.appresources.ApplicationResourcesNavigatorManager;
import oracle.jdeveloper.appresources.ApplicationResourcesNode;
import oracle.jdeveloper.resource.ApplicationResourcesArb;

public final class ApplicationResourcesWindow
extends DefaultNavigatorWindow
implements ApplicationChangeListener {
    private static final String VIEW_TYPE = "oracle-jdevimpl-deploy-ApplicationResourcesWindow-VIEW_TYPE";
    private static final String VIEW_NAME = "oracle-jdevimpl-deploy-ApplicationResourcesWindow-VIEW_NAME";
    private static ApplicationResourcesWindow _instance;
    private final HashMap _expansionStates;
    private Workspace _currentWorkspace;
    private ApplicationResourcesNode _resourcesNode;

    private void $init$() {
        this._expansionStates = new HashMap();
    }

    public static ApplicationResourcesWindow getInstance() {
        if (_instance == null) {
            _instance = new ApplicationResourcesWindow();
        }
        return _instance;
    }

    private ApplicationResourcesWindow() {
        this(ApplicationResourcesWindow.initContext(Context.newIdeContext()));
        this.setManager(ApplicationResourcesNavigatorManager.getApplicationResourcesNavigatorManager());
    }

    private ApplicationResourcesWindow(Context context) {
        super(context, "oracle-jdevimpl-deploy-ApplicationResourcesWindow-VIEW_TYPE.oracle-jdevimpl-deploy-ApplicationResourcesWindow-VIEW_NAME");
        this.$init$();
        this._resourcesNode = (ApplicationResourcesNode)context.getElement();
        Assert.check((_instance == null ? 1 : 0) != 0);
        _instance = this;
    }

    private static Context initContext(Context context) {
        context.setElement((Element)new ApplicationResourcesNode());
        return context;
    }

    static ViewId createViewId() {
        return new ViewId(VIEW_TYPE, VIEW_NAME);
    }

    public ApplicationResourcesNode getApplicationResourcesNode() {
        return this._resourcesNode;
    }

    public void addResourceNode(Element node) {
        this._resourcesNode.add(node);
        this._resourcesNode.sortChildren();
        UpdateMessage.fireStructureChanged((Subject)this._resourcesNode);
    }

    public boolean removeResourceNode(Element node) {
        boolean result = this._resourcesNode.remove(node);
        if (result) {
            UpdateMessage.fireStructureChanged((Subject)this._resourcesNode);
        }
        return result;
    }

    public String getTabName() {
        return ApplicationResourcesArb.getString(2);
    }

    public String getTitleName() {
        return ApplicationResourcesArb.getString(4);
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    public void applicationChanged(ApplicationChangeEvent e) {
        TreeExplorer treeExplorer = this.getTreeExplorer();
        treeExplorer.getContext();
        Workspace workspace = e.getApplication();
        int stateChange = e.getStateChange();
        if (stateChange == 1) {
            this._currentWorkspace = null;
            if (workspace != null) {
                URL workspaceURL = workspace.getURL();
                TNode root = treeExplorer.getRoot();
                List expansionState = ExplorerContext.storeExpansionState((TNode)root, (TreeExplorer)treeExplorer);
                this._expansionStates.put(workspaceURL, expansionState);
                this._resourcesNode.applicationChanged(e);
            }
        } else if (stateChange == 2) {
            this._currentWorkspace = workspace;
            this._resourcesNode.applicationChanged(e);
            UpdateMessage.fireStructureChanged((Subject)this._resourcesNode);
            treeExplorer.getContext();
            this.fireTitleChangeListener();
            if (workspace != null) {
                URL workspaceURL = workspace.getURL();
                List expansionState = (List)this._expansionStates.remove(workspaceURL);
                TNode root = treeExplorer.getRoot();
                ExplorerContext.restoreExpansionState((TNode)root, (TreeExplorer)treeExplorer, (List)expansionState);
            }
        }
    }

    public static void notifyApplicationChanged(Iterator iter, ApplicationChangeEvent event) {
        if (iter != null) {
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof ApplicationChangeListener)) continue;
                ApplicationChangeListener listener = (ApplicationChangeListener)child;
                long startTime = System.nanoTime();
                listener.applicationChanged(event);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ApplicationChangeListener.applicationChanged", listener.getClass().getName(), endTime - startTime);
            }
        }
    }

    public static void sortNodes(ArrayList nodes) {
        Collections.sort(nodes, new 1());
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        context.setWorkspace(this._currentWorkspace);
        context.setProject(null);
        return context;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideapplicationresourcespanel_html");
    }

    static final class 1
    implements Comparator {
        public int compare(Displayable node1, Displayable node2) {
            return node1.getShortLabel().compareTo(node2.getShortLabel());
        }
    }
}

