/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.AuditEditorAdapter;
import oracle.jdeveloper.audit.model.AuditEditorListener;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaParserPlugin;

public class JavaSourceEditorAdapter
extends AuditEditorAdapter
implements JavaParserPlugin.HelperClient {
    private BasicEditorPane editor;
    private AuditEditorListener listener;
    private Map attributes;
    private static final Log LOG = new Log("editor");

    public void attach(CodeEditor editor, AuditEditorListener listener) {
        this.editor = editor.getFocusedEditorPane();
        this.listener = listener;
        this.attributes = new HashMap();
        JavaParserPlugin.attachHelperClient(this.editor, this);
    }

    public void ensureCurrent() {
        LOG.trace("ensuring compile current");
        JavaParserPlugin.ensureCompileScheduled(this.editor);
    }

    public void detach(CodeEditor editor, AuditEditorListener listener) {
        JavaParserPlugin.detachHelperClient(editor.getFocusedEditorPane(), this);
    }

    public void notifyCompileScheduled() {
        LOG.trace("handling compile scheduled");
        this.listener.modelStale();
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    public void notifyCompileFinished(JavaManager manager, SourceFile file, int cid, int delay) {
        LOG.trace("handling compile finished");
        this.attributes.put(JavaManager.class, manager);
        this.attributes.put(SourceFile.class, file);
        this.listener.modelCurrent(this.attributes);
    }
}

