/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.MethodElement;

public class JavaSourceModelAdapter
extends TextFileModelAdapter {
    private JavaManager manager;
    private boolean managerCreator;
    private WeakReference<SourceFile> root;
    private static final Log LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.root = null;
    }

    static {
        $assertionsDisabled = JavaSourceModelAdapter.class.desiredAssertionStatus() ^ true;
        LOG = new Log("javaadapter");
    }

    JavaSourceModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, JavaSourceNode node, URL url) {
        super(factory, type, workspace, project, directory, (Node)node, url);
        this.$init$();
        if (!$assertionsDisabled && this.getProject() == null) {
            throw new AssertionError();
        }
    }

    private JavaManager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        ContainerModelAdapter project = this.getProjectAdapter();
        this.manager = (JavaManager)project.getAttribute(JavaManager.class);
        if (this.manager != null) {
            return this.manager;
        }
        this.manager = JavaManager.getJavaManager((Project)project.getProject());
        this.managerCreator = true;
        project.setAttribute(JavaManager.class, (Object)this.manager);
        return this.manager;
    }

    protected void beginReadHook() {
        super.beginReadHook();
        CacheSupport support = this.getManager().getCacheSupport();
        support.beginCacheUse();
    }

    protected void endReadHook() {
        CacheSupport support = this.getManager().getCacheSupport();
        support.endCacheUse();
        super.endReadHook();
    }

    public void cancelRead() {
        SourceFile file;
        LOG.trace("getting root of {0}", (Object)this);
        this.verifyReadTransaction();
        if (this.root != null && (file = (SourceFile)this.root.get()) != null) {
            file.cancelCompile();
        }
    }

    public Object getRootImplementation() {
        SourceFile file;
        if (this.root == null || (file = (SourceFile)this.root.get()) == null || file.isExpired() || !URLFileSystem.equals((URL)this.getUrl(), (URL)file.getURL())) {
            file = this.getManager().getSourceFile(this.getUrl());
            if (file == null) {
                throw new CancellationException(this.getUrl() + " not found");
            }
            this.root = new WeakReference<SourceFile>(file);
        }
        if (file.isCompiled()) {
            Dependency dependencies = (Dependency)this.getFactory().getAttribute(Dependency.class);
            if (dependencies != null && dependencies.hasChanged()) {
                file.clearCompiledInfo();
                file.compile();
            }
        } else {
            file.compile();
        }
        return file;
    }

    public Location[] getElementLocations(Element element) {
        SourceElement construct;
        MethodElement codeElement;
        int offset;
        Location location;
        SourceElement name;
        LOG.trace("getting element location for {0}", (Object)element);
        this.verifyReadTransaction();
        if (element instanceof JavaSourceNode) {
            JavaSourceNode node = (JavaSourceNode)element;
            if (node.getURL().equals(this.getUrl())) {
                return new Location[]{this.getLocation()};
            }
        } else if (element instanceof ClassElement) {
            SourceElement construct2;
            ClassElement codeElement2 = (ClassElement)element;
            int offset2 = codeElement2.getStartOffset();
            Location location2 = this.getLocation(offset2, codeElement2.getEndOffset() - codeElement2.getStartOffset());
            SourceElement name2 = (SourceElement)this.getConstruct(location2);
            if (name2 instanceof SourceName && (construct2 = name2.getParent()) instanceof SourceClass) {
                return new Location[]{this.getLocation(construct2)};
            }
        } else if (element instanceof MethodElement && (name = (SourceElement)this.getConstruct(location = this.getLocation(offset = (codeElement = (MethodElement)element).getStartOffset(), codeElement.getEndOffset() - codeElement.getStartOffset()))) instanceof SourceName && (construct = name.getParent()) instanceof SourceMethod) {
            return new Location[]{this.getLocation(construct)};
        }
        return null;
    }

    public Location getLocation(Object construct) {
        LOG.trace("getting location of {0}", construct);
        this.verifyReadTransaction();
        if (construct instanceof SourceElement) {
            return this.getLocation((SourceElement)construct);
        }
        return null;
    }

    private Location getLocation(SourceElement element) {
        if (URLFileSystem.equals((URL)element.getOwningSourceFile().getURL(), (URL)this.getUrl())) {
            int length;
            int offset;
            do {
                offset = element.getStartOffset();
                length = element.getEndOffset() - offset;
            } while (offset < 0 && (element = element.getParent()) != null);
            return this.getLocation(offset, length);
        }
        return null;
    }

    public Location getFocusLocation(Object construct, Location location) {
        LOG.trace("getting focus location of {0}", construct);
        if (!$assertionsDisabled && location == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !location.equals((Object)this.getLocation(construct))) {
            throw new AssertionError();
        }
        this.verifyReadTransaction();
        if (construct instanceof SourceHasName) {
            SourceMember member;
            SourceDocComment comment;
            SourceName name = ((SourceHasName)construct).getNameElement();
            if (name != null) {
                return this.getLocation((SourceElement)name);
            }
            if (construct instanceof SourceMember && (comment = (member = (SourceMember)construct).getDocComment()) != null) {
                List children = member.getChildren();
                int offset = ((SourceElement)children.get(1)).getStartOffset();
                int length = ((SourceElement)children.get(children.size() - 1)).getEndOffset() - offset;
                return this.getLocation(offset, length);
            }
            return this.getLocation((SourceElement)((SourceHasName)construct));
        }
        if (construct instanceof SourceVariableDeclaration) {
            List variables = ((SourceVariableDeclaration)construct).getVariables();
            if (variables.isEmpty()) {
                return this.getLocation((SourceElement)((SourceVariableDeclaration)construct));
            }
            if (variables.size() == 1) {
                SourceVariable variable = (SourceVariable)variables.get(0);
                SourceName name = variable.getNameElement();
                if (name != null) {
                    return this.getLocation((SourceElement)name);
                }
                return this.getLocation((SourceElement)variable);
            }
            int offset = ((SourceElement)variables.get(0)).getStartOffset();
            int length = ((SourceElement)variables.get(variables.size() - 1)).getEndOffset() - offset;
            return this.getLocation(offset, length);
        }
        return location;
    }

    public Iterator getContainedConstructs(Object construct) {
        LOG.trace("getting contained constructs of {0}", construct);
        this.verifyReadTransaction();
        if (!$assertionsDisabled && !(construct instanceof SourceElement)) {
            throw new AssertionError();
        }
        return ((SourceElement)construct).getChildren().iterator();
    }

    public boolean contains(Object construct, Location location) {
        if (!$assertionsDisabled && this.getFactory() != location.getModel().getFactory()) {
            throw new AssertionError((Object)("generation mismatch: " + (Object)((Object)this) + " - " + location));
        }
        if (!$assertionsDisabled && this != location.getModel()) {
            throw new AssertionError();
        }
        this.verifyReadTransaction();
        if (!$assertionsDisabled && !(construct instanceof SourceElement)) {
            throw new AssertionError();
        }
        SourceElement element = (SourceElement)construct;
        int offset = element.getStartOffset();
        int endOffset = element.getEndOffset();
        return offset <= location.getOffset() && endOffset >= location.getEndOffset();
    }

    public void release() {
        if (this.managerCreator) {
            this.getProjectAdapter().setAttribute(JavaManager.class, null);
            this.managerCreator = false;
        }
        this.manager = null;
        this.root = null;
        super.release();
    }

    public Object label(Object construct) {
        if (construct instanceof SourceFile) {
            return URLFileSystem.getFileName((URL)this.getUrl());
        }
        if (construct instanceof SourceClass) {
            SourceClass type = (SourceClass)construct;
            if (!type.isAnonymous()) {
                return type.getName();
            }
            return '<' + type.getSuperclass().getName() + '>';
        }
        if (construct instanceof SourceMethod) {
            StringWriter writer = new StringWriter();
            ((SourceMethod)construct).print(new PrintWriter(writer), 1);
            return writer.toString();
        }
        return construct.getClass().toString();
    }

    public Object summary(Object construct) {
        if (construct instanceof SourceFile) {
            return URLFileSystem.getPlatformPathName((URL)this.getUrl());
        }
        if (construct instanceof SourceClass) {
            return ((SourceClass)construct).getQualifiedName();
        }
        if (construct instanceof SourceMethod) {
            StringWriter writer = new StringWriter();
            ((SourceMethod)construct).print(new PrintWriter(writer), 1);
            return writer.toString();
        }
        return construct.toString();
    }

    public Icon icon(Object construct) {
        if (construct instanceof SourceFile) {
            return this.getNode().getIcon();
        }
        if (construct instanceof SourceClass) {
            if (((SourceClass)construct).isInterface()) {
                return OracleIcons.getIcon((String)"interface.png");
            }
            return OracleIcons.getIcon((String)"class.png");
        }
        if (construct instanceof SourceMethod) {
            if (((SourceMethod)construct).isConstructor()) {
                return OracleIcons.getIcon((String)"constructor.png");
            }
            return OracleIcons.getIcon((String)"method.png");
        }
        return null;
    }
}

