/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;

public class JavaTransformAdapter
extends TransformAdapter {
    private SourceTransaction transaction;
    private UndoableEditCommand command;
    private TextBuffer buffer;
    private SourceFile file;
    private Set<SourceImport> initialUnusedImports;
    private Set<SourceImport> retainedImports;

    public Class getContextClass() {
        return JavaTransformContext.class;
    }

    public TransformContext createContext(Transform transform, Violation violation, Location location) {
        return new JavaTransformContext(this, transform, violation, location);
    }

    public void beginTransform(TransformContext context) {
        if (this.transaction != null) {
            throw new IllegalStateException("transaction already begun");
        }
        TextFileModelAdapter model = (TextFileModelAdapter)context.getModelAdapter();
        this.buffer = model.getTextBuffer();
        int cid = this.buffer.getChangeId();
        this.buffer.readUnlock();
        this.buffer.writeLock();
        boolean succeeded = false;
        try {
            this.buffer.readLock();
            if (cid != this.buffer.getChangeId()) {
                throw new ExpiredTextBufferException();
            }
            this.command = new UndoableEditCommand(context.getTransform().boundLabel(context), model.getTextNode(), context.getProject(), context.getWorkspace());
            this.file = (SourceFile)model.getRoot();
            if (!this.file.isCompiled()) {
                this.file.compile();
            }
            this.transaction = this.file.beginTransaction();
            this.initialUnusedImports = new HashSet<SourceImport>();
            for (SourceImport impor : this.file.getSourceImports()) {
                if (impor.isUsed()) continue;
                this.initialUnusedImports.add(impor);
            }
            this.retainedImports = new HashSet<SourceImport>();
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.clearTransaction();
            }
        }
    }

    public void endTransform(TransformContext context) throws Exception {
        if (this.transaction == null) {
            throw new IllegalStateException("transaction not begun");
        }
        context.getModelAdapter().verifyReadTransaction();
        this.transaction.savepoint();
        this.file.compile();
        List imports = this.file.getSourceImports();
        ArrayList<SourceImport> unusedImports = new ArrayList<SourceImport>();
        for (SourceImport impor : imports) {
            if (impor.isUsed() || this.initialUnusedImports.contains(impor)) continue;
            unusedImports.add(impor);
        }
        imports.removeAll(unusedImports);
        UndoableEdit edit = this.transaction.commit();
        if (edit != null) {
            this.command.addEdit(edit);
            Location selection = this.getSelection();
            if (selection != null) {
                this.command.setSelection(selection.getModel().getUrl(), selection.getOffset(), selection.getLength());
            }
            CommandProcessor.getInstance().invoke((Command)this.command);
        }
        this.clearTransaction();
    }

    public void cancelTransform(TransformContext context) throws Exception {
        if (this.transaction == null) {
            throw new IllegalStateException("transaction not begun");
        }
        this.transaction.abort();
        this.clearTransaction();
    }

    private void clearTransaction() {
        this.transaction = null;
        this.command = null;
        this.buffer.writeUnlock();
        this.buffer = null;
        this.file = null;
        this.initialUnusedImports = null;
        this.retainedImports = null;
    }

    void retainImport(SourceImport impor) {
        this.retainedImports.add(impor);
    }
}

