/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.net.URL;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.java.TemplateTransformContext;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TextTransformAdapter;
import oracle.jdeveloper.audit.transform.TextTransformContext;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.ceditor.template.PseudoTemplateFactory;

public class TemplateTransformAdapter
extends TextTransformAdapter {
    private PseudoTemplateFactory factory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Class getContextClass() {
        return TemplateTransformContext.class;
    }

    public TransformContext createContext(Transform transform, Violation violation, Location location) {
        return new TemplateTransformContext(this, transform, violation, location);
    }

    public void beginTransform(TemplateTransformContext context) throws Exception {
        OpenEditorCommand openCommand = new OpenEditorCommand(context.getTransform().labelOrId(), context.getTextNode(), context.getProject(), context.getWorkspace());
        CommandProcessor.getInstance().invoke((Command)openCommand);
        super.beginTransform((TransformContext)context);
    }

    static {
        $assertionsDisabled = TemplateTransformAdapter.class.desiredAssertionStatus() ^ true;
    }

    protected UndoableEditCommand createUndoableEditCommand(TextTransformContext context) {
        CodeEditor editor = (CodeEditor)EditorManager.getEditorManager().getCurrentEditor();
        this.factory = new PseudoTemplateFactory(editor.getContext());
        TextNode node = context.getTextNode();
        if (!$assertionsDisabled && editor.getContext().getNode() != node) {
            throw new AssertionError();
        }
        return new TemplateCommand(context.getTransform().boundLabel((TransformContext)context), this.factory, this.getBuffer(), node, context.getProject(), context.getWorkspace());
    }

    PseudoTemplateFactory getFactory() {
        return this.factory;
    }

    public static class OpenEditorCommand
    extends Command {
        private Workspace initialWorkspace;
        private Project initialProject;
        private URL initialURL;
        private int initialSelectionOffset;
        private int initialSelectionLength;

        public OpenEditorCommand(String name, TextNode node, Project project, Workspace workspace) {
            super(Ide.findOrCreateCmdID((String)name), 0, name);
            this.setContext(new Context(null, workspace, project, (Node)node));
        }

        public int doit() {
            EditorManager editorManager = EditorManager.getEditorManager();
            if (editorManager != null) {
                Editor editor = editorManager.getCurrentEditor();
                if (editor instanceof CodeEditor) {
                    CodeEditor codeEditor = (CodeEditor)editor;
                    Context context = codeEditor.getContext();
                    this.initialWorkspace = context.getWorkspace();
                    this.initialProject = context.getProject();
                    this.initialURL = context.getNode().getURL();
                    this.initialSelectionOffset = codeEditor.getSelectionStart();
                    this.initialSelectionLength = codeEditor.getSelectionEnd() - this.initialSelectionOffset;
                }
                OpenEditorOptions options = new OpenEditorOptions(this.getContext(), CodeEditor.class);
                editorManager.openEditor(options);
                return 0;
            }
            return 1;
        }

        public int undo() throws Exception {
            this.changeSelection(this.initialWorkspace, this.initialProject, this.initialURL, this.initialSelectionOffset, this.initialSelectionLength);
            return 0;
        }

        private void changeSelection(Workspace workspace, Project project, URL url, int offset, int length) {
            Ide.setActiveWorkspace((Workspace)workspace);
            Ide.setActiveProject((Project)project);
            Node node = NodeFactory.find((URL)url);
            Context context = new Context(null, workspace, project, node);
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, length);
            try {
                NavigationManager.getNavigationManager().navigateTo((NavigationPoint)point);
            }
            catch (Exception e) {
                Log.error((String)"opening {0} failed: {1}", (Object)context, (Object)e);
            }
        }
    }

    public class TemplateCommand
    extends UndoableEditCommand {
        private PseudoTemplateFactory factory;
        private TextBuffer buffer;
        private boolean neverDone;

        private void $init$() {
            this.neverDone = true;
        }

        public TemplateCommand(String name, PseudoTemplateFactory factory, TextBuffer buffer, TextNode node, Project project, Workspace workspace) {
            super(name, node, project, workspace);
            this.$init$();
            this.factory = factory;
            this.buffer = buffer;
        }

        public int doit() throws Exception {
            if (this.neverDone) {
                UndoableEdit edit;
                this.neverDone = false;
                this.buffer.beginEdit();
                try {
                    this.factory.realize();
                }
                finally {
                    edit = this.buffer.endEdit();
                }
                this.addEdit(edit);
            }
            return super.doit();
        }
    }
}

