/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.lang.reflect.Modifier;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visibility
implements Comparable,
TypeSafeEnumeration {
    public static final Visibility PRIVATE = new Visibility("private", 0, 2);
    public static final Visibility DEFAULT = new Visibility("default", 1, 0);
    public static final Visibility PROTECTED = new Visibility("protected", 2, 4);
    public static final Visibility PUBLIC = new Visibility("public", 3, 1);
    private String name;
    private int order;
    private int modifier;

    private Visibility(String name, int order, int modifier) {
        this.name = name;
        this.order = order;
        this.modifier = modifier;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        return this.order - ((Visibility)object).order;
    }

    public static Visibility valueOf(String string) {
        if (Visibility.PRIVATE.name.equals(string)) {
            return PRIVATE;
        }
        if (Visibility.DEFAULT.name.equals(string)) {
            return DEFAULT;
        }
        if (Visibility.PROTECTED.name.equals(string)) {
            return PROTECTED;
        }
        if (Visibility.PUBLIC.name.equals(string)) {
            return PUBLIC;
        }
        return null;
    }

    public static Visibility valueOf(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return PUBLIC;
        }
        if (Modifier.isProtected(modifiers)) {
            return PROTECTED;
        }
        if (Modifier.isPrivate(modifiers)) {
            return PRIVATE;
        }
        return DEFAULT;
    }

    public int getModifier() {
        return this.modifier;
    }
}

