/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public abstract class AbstractBuilderModel
implements BaliWizardState {
    private SourceModel _src;
    private boolean _clearExistingFiles;
    private boolean _raiseEditor;

    private void $init$() {
        this._clearExistingFiles = true;
        this._raiseEditor = true;
    }

    public abstract String getBuilderType();

    protected abstract String getBaseName();

    public AbstractBuilderModel() {
        this.$init$();
    }

    protected void initializeFromContext(Context ctx) {
        Project proj = ctx.getProject();
        this.setProject(proj);
        this.initializeSourceDir(ctx);
        this.getSourceModel().generateDefaultFileName(this.getBaseName());
    }

    protected void initializeSourceDir(Context ctx) {
        TreeNode parent;
        TNode tnode;
        SourceModel src = this.getSourceModel();
        Element elem = ctx.getElement();
        if ((elem == null || !elem.mayHaveChildren()) && (tnode = ExplorerContext.getFirstTNode((Context)ctx)) != null && (parent = tnode.getParent()) instanceof TNode) {
            tnode = (TNode)parent;
            elem = tnode.getData();
        }
        if (elem instanceof RelativeDirectoryContextFolder) {
            URLPath dirs;
            RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)elem;
            String path = folder.getRelativePath();
            if (path == null) {
                path = src.getRelativeDirectory();
            }
            if ((dirs = folder.getRootDirectories()) != null && dirs.size() == 1) {
                URL dir = URLFactory.newDirURL((URL)dirs.getFirstEntry(), (String)path);
                src.setDirectory(dir);
                if (!ModelUtil.hasLength((String)src.getDirectoryString())) {
                    src.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
                }
            } else if (ModelUtil.hasLength((String)path)) {
                src.setRelativeDirectory(path);
            } else {
                src.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
            }
        } else {
            URL dir = null;
            String relPath = null;
            if (elem instanceof Locatable) {
                Project proj;
                PackagedSource pkgSrc;
                URL url = ((Locatable)elem).getURL();
                if (url != null) {
                    URL uRL = dir = URLFileSystem.isDirectory((URL)url) ? url : URLFileSystem.getParent((URL)url);
                }
                if (elem instanceof PackagedSource && (relPath = (pkgSrc = (PackagedSource)elem).getPackage(proj = ctx.getProject())) != null) {
                    relPath = relPath.replace('.', '/');
                }
            }
            if (src.isInSourcePath(dir)) {
                src.setDirectory(dir);
                if (relPath != null) {
                    src.setRelativeDirectory(relPath);
                }
            } else {
                src.setRelativeDirectory(this.getDefaultRelativeDirectory(this.getProject()));
            }
        }
    }

    protected String getDefaultRelativeDirectory(Project project) {
        return "";
    }

    protected final void setClearExistingFiles(boolean clearExistingFiles) {
        this._clearExistingFiles = clearExistingFiles;
    }

    public boolean isRaiseEditor() {
        return this._raiseEditor;
    }

    public void setRaiseEditor(boolean raise) {
        this._raiseEditor = raise;
    }

    public final void setProject(Project project) {
        this.getSourceModel().setProject(project);
    }

    public final Project getProject() {
        return this.getSourceModel().getProject();
    }

    public final void setFileName(String newName) {
        this.getSourceModel().setFileName(newName);
    }

    public final String getFileName() {
        return this.getSourceModel().getFileName();
    }

    public final void setDirectory(URL url) {
        this.getSourceModel().setDirectory(url);
    }

    public final URL getDirectory() {
        return this.getSourceModel().getDirectory();
    }

    public final void setRelativeDirectory(String newDir) {
        this.getSourceModel().setRelativeDirectory(newDir);
    }

    public final String getRelativeDirectory() {
        return this.getSourceModel().getRelativeDirectory();
    }

    public final URL getURL() {
        return this.getSourceModel().getURL();
    }

    public final void setURL(URL url) {
        this.getSourceModel().setURL(url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void commitWizardState() {
        Node node = this.getSourceModel().createNode();
        if (node != null) {
            if (!node.isReadOnly()) {
                TextBuffer buffer = null;
                try {
                    if (node instanceof TextNode) {
                        buffer = ((TextNode)node).acquireTextBuffer();
                    }
                    if (!this.fileBuiltSynchronously(node)) return;
                    this.addFileToProject(node);
                    return;
                }
                finally {
                    if (buffer != null) {
                        ((TextNode)node).releaseTextBuffer();
                    }
                }
            } else {
                this.reportError(BuilderArb.getString(91), BuilderArb.format(120, URLFileSystem.getPlatformPathName((URL)this.getURL())), null);
            }
            return;
        } else {
            this.reportError(BuilderArb.getString(111), BuilderArb.format(73, this.getURL()), null);
        }
    }

    private boolean fileBuiltSynchronously(Node node) {
        if (this.getProject().isOpen()) {
            return this.buildFile(node);
        }
        if (!this.getProject().ensureOpen()) {
            return false;
        }
        SwingUtilities.invokeLater(new 1(this, node));
        return false;
    }

    private void addFileToProject(Node node) {
        this.getProject().add(node, this.getSourceModel().getContentSetKey());
        this.postProcess(node);
    }

    protected boolean buildFile(Node node) {
        if (node instanceof TextNode && this._clearExistingFiles) {
            TextNode txtNode = (TextNode)node;
            TextBuffer textBuffer = null;
            try {
                textBuffer = txtNode.acquireTextBuffer();
                int textBufferLength = textBuffer.getLength();
                if (textBufferLength > 0) {
                    textBuffer.remove(0, textBufferLength);
                    UpdateMessage.fireStructureChanged((Subject)txtNode);
                }
            }
            finally {
                if (textBuffer != null) {
                    txtNode.releaseTextBuffer();
                }
            }
        }
        return true;
    }

    protected void postProcess(Node node) {
        if (node != null) {
            try {
                node.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SwingUtilities.invokeLater(new 2(this, node));
        }
    }

    protected SourceModel createSourceModel() {
        return new SourceModel();
    }

    public final void reportError(String msg) {
        this.reportError(IdeArb.getString((int)201), msg, null);
    }

    public void reportError(String title, String msg, String helpID) {
        Assert.println((String)msg);
    }

    protected final SourceModel getSourceModel() {
        if (this._src == null) {
            this._src = this.createSourceModel();
        }
        return this._src;
    }

    static void mav$addFileToProject(AbstractBuilderModel abstractBuilderModel, Node node) {
        abstractBuilderModel.addFileToProject(node);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ AbstractBuilderModel this$0;

        public void run() {
            if (this.this$0.buildFile(this.v$node)) {
                AbstractBuilderModel.mav$addFileToProject(this.this$0, this.v$node);
            }
        }

        public 1(AbstractBuilderModel abstractBuilderModel, Node node) {
            this.v$node = node;
            this.this$0 = abstractBuilderModel;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ AbstractBuilderModel this$0;

        public void run() {
            Context context = Context.newIdeContext((Node)this.v$node);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            if (!this.this$0.isRaiseEditor()) {
                openEditorOptions.setFlags(2);
            }
            openEditorOptions.setFlags(8, true);
            editorManager.openEditor(openEditorOptions);
        }

        public 2(AbstractBuilderModel abstractBuilderModel, Node node) {
            this.v$node = node;
            this.this$0 = abstractBuilderModel;
        }
    }
}

