/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.jdeveloper.builder.cls.Generator;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;

public class AttributePanel
extends JPanel
implements ListDataListener {
    Border attrBorder;
    CardLayout attrLayout;
    JPanel emptyPanel;
    private HashMap mapClassToAttributePanel;
    private ArrayList attributePanels;
    private MutableComboBoxModel model;
    private GeneratorElement currGen;

    private void $init$() {
        this.attrBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BuilderArb.getString(117)), BorderFactory.createEmptyBorder(0, 8, 8, 8));
        this.attrLayout = new CardLayout();
        this.emptyPanel = new JPanel();
        this.mapClassToAttributePanel = new HashMap();
        this.attributePanels = new ArrayList();
    }

    public AttributePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    boolean validateAttributes() {
        Object item = this.model.getSelectedItem();
        if (item == null || item.toString().trim().length() == 0) {
            return true;
        }
        GeneratorElement elem = (GeneratorElement)item;
        Generator generator = elem.getGenerator();
        return generator != null ? generator.validateAttributes() : true;
    }

    public void setModel(MutableComboBoxModel model) {
        MutableComboBoxModel old = this.model;
        if (old != null) {
            old.removeListDataListener(this);
        }
        this.removeAll();
        this.add((Component)this.emptyPanel, "void");
        if (model != null) {
            model.addListDataListener(this);
            int i = model.getSize() - 1;
            while (i >= 0) {
                GeneratorElement elem = (GeneratorElement)model.getElementAt(i);
                this.updateClassAttributeMap(elem);
                --i;
            }
        }
        this.model = model;
        this.updateAttributes();
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void contentsChanged(ListDataEvent e) {
        this.updateAttributes();
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.currGen.setEnabled(isEnabled);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.attrLayout);
        this.setBorder(this.attrBorder);
        this.add((Component)this.emptyPanel, "void");
    }

    private void updateAttributes() {
        GeneratorElement elem = null;
        Object item = this.model.getSelectedItem();
        String itemName = item.toString();
        if (itemName.trim().length() == 0) {
            return;
        }
        elem = item instanceof GeneratorElement ? (GeneratorElement)item : new GeneratorElement(itemName, null);
        if (elem != this.currGen) {
            this.updateClassAttributeMap(elem);
            if (elem.getAttributes() != null) {
                String className = elem.toString();
                String panel = this.mapClassToAttributePanel.get(className).toString();
                this.attrLayout.show(this, panel);
            } else {
                this.attrLayout.show(this, "void");
            }
        }
        this.currGen = elem;
    }

    private void updateClassAttributeMap(GeneratorElement genElement) {
        JComponent attrs = genElement.getAttributes();
        if (attrs != null) {
            String className;
            String panelKey = className = genElement.toString();
            int count = this.attributePanels.size();
            if (count == 0) {
                this.attributePanels.add(new AttributeInfo(className, attrs));
                this.add((Component)attrs, className);
            } else {
                boolean match = false;
                for (AttributeInfo info : this.attributePanels) {
                    if (!info.getKey().equals(className) && info.getAttributes() != attrs) continue;
                    panelKey = info.getKey();
                    match = true;
                    break;
                }
                if (!match) {
                    this.attributePanels.add(new AttributeInfo(className, attrs));
                    this.add((Component)attrs, className);
                }
            }
            this.mapClassToAttributePanel.put(className, panelKey);
        }
    }

    private static class AttributeInfo {
        String key;
        JComponent attributes;

        AttributeInfo(String key, JComponent attributes) {
            this.key = key;
            this.attributes = attributes;
        }

        public String getKey() {
            return this.key;
        }

        public JComponent getAttributes() {
            return this.attributes;
        }
    }
}

