/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.model.PathsConfiguration;

public class ClassSourceModel
extends SourceModel {
    public String getExtension() {
        return ".java";
    }

    protected String getContentSetKey() {
        return PathsConfiguration.JAVA_CONTENT_SET_KEY;
    }

    protected URLPath getSourcePath() {
        return PathsConfiguration.getInstance((Project)this.getProject()).getProjectSourcePath();
    }

    public final void setRelativeDirectory(String newDir) {
        int idx;
        if (newDir != null && (idx = newDir.indexOf(46)) >= 0) {
            newDir = (idx = newDir.lastIndexOf(47, idx)) >= 0 ? newDir.substring(0, idx) : "";
        }
        super.setRelativeDirectory(newDir);
    }

    public void generateDefaultFileName(String baseName) {
        URL dirURL = this._getDirectory(true);
        int startCount = this.getDefaultNameStartIndex();
        DefaultNameGenerator gen = new DefaultNameGenerator(baseName, this.getExtension(), startCount);
        URL url = URLFactory.newUniqueURL((URL)dirURL, (NameGenerator)gen);
        this.setURL(url);
        String fName = URLFileSystem.getFileName((URL)url);
        this.setFileName(fName.substring(0, fName.indexOf(46)));
    }

    public URL getDirectory() {
        return this._getDirectory(false);
    }

    private URL _getDirectory(boolean fastDefault) {
        if (fastDefault) {
            return super.getDirectory();
        }
        String dirString = super.getDirectoryString();
        if (dirString.length() == 0 || this.getProject() == null) {
            return super.getBaseURL();
        }
        Context context = new Context(null, super.getProject());
        URL url = PathsConfiguration.getURLForPackage((String)dirString, (Context)context);
        return url;
    }
}

