/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.file;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.GalleryArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilder;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;

public class EmptyFileBuilder
extends FileBuilder {
    public String getShortLabel() {
        return GalleryArb.getString((int)175);
    }

    public String getLongLabel() {
        return GalleryArb.getString((int)221);
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"file.png");
    }

    protected String _getTitleString() {
        return this.getShortLabel();
    }

    protected String getHelpID() {
        return "f1_newfilegeneric_html";
    }

    protected AbstractBuilderModel _buildModel(Context context) {
        return new EmptyFileBuilderModel(context);
    }

    protected Image getHeaderImage() {
        return OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/simpleFile.png"));
    }

    private static class EmptyFileBuilderModel
    extends FileBuilderModel {
        public EmptyFileBuilderModel(Context context) {
            super(context);
        }

        public String getFileType() {
            return GalleryArb.getString((int)175);
        }

        public String getBuilderType() {
            return "File";
        }

        protected boolean buildFile(Node node) {
            if (super.buildFile(node)) {
                URL url;
                if (node != null && !URLFileSystem.exists((URL)(url = node.getURL()))) {
                    try {
                        URLFileSystem.openOutputStream((URL)url).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }

        protected String getBaseName() {
            return BuilderArb.getString(97);
        }

        protected String getDefaultRelativeDirectory(Project project) {
            return "";
        }

        protected void initializeSourceDir(Context ctx) {
            Context context = new Context(ctx);
            if (ctx != null && ctx.getElement() == null) {
                if (ctx.getNode() != null) {
                    context.setElement((Element)ctx.getNode());
                } else if (ctx.getProject() != null) {
                    context.setElement((Element)ctx.getProject());
                }
            }
            super.initializeSourceDir(context);
        }
    }
}

