/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.file;

import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.component.NewFileValidator;
import oracle.ide.model.Node;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.SourceModel;

public abstract class FileBuilderModel
extends AbstractBuilderModel
implements NewFileValidator {
    private String _ext;

    public FileBuilderModel(Context ctx) {
        this(ctx, "");
    }

    public FileBuilderModel(Context ctx, String ext) {
        this._ext = ext;
        this.initializeFromContext(ctx);
    }

    public abstract String getFileType();

    protected SourceModel createSourceModel() {
        return new FileSourceModel();
    }

    public String getFileExtension() {
        return this._ext;
    }

    public boolean getEnforceFileExtension() {
        return true;
    }

    public URL validateNewFileURL(URL url) throws TraversalException {
        return url;
    }

    protected boolean buildFile(Node node) {
        boolean success = false;
        if (super.buildFile(node)) {
            if (node.isNew()) {
                try {
                    node.save();
                }
                catch (IOException ioe) {
                    node.markDirty(true);
                }
            }
            success = true;
        }
        return success;
    }

    static String ra$_ext(FileBuilderModel fileBuilderModel) {
        return fileBuilderModel._ext;
    }

    protected class FileSourceModel
    extends SourceModel {
        public String getExtension() {
            return FileBuilderModel.ra$_ext(FileBuilderModel.this);
        }

        protected FileSourceModel() {
        }
    }
}

