/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.iface;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.iface.InterfaceBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.controls.PackagePopup;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public final class InterfaceBuilderPanel
extends JPanel
implements BaliWizardPanel {
    protected GridBagLayout mainLayout;
    protected JLabel clsLabel;
    protected JTextField clsField;
    protected JLabel pkgLabel;
    protected PackagePopup pkgField;
    protected JButton pkgBrowse;
    private InterfaceBuilderModel savedState;
    private static int FILENAME_DISPLAY_MAX_LENGTH = 80;

    private void $init$() {
        this.mainLayout = new GridBagLayout();
        this.clsLabel = new JLabel();
        this.clsField = new JTextField();
        this.pkgLabel = new JLabel();
        this.pkgField = new PackagePopup();
        this.pkgBrowse = new JButton();
    }

    public InterfaceBuilderPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.clsLabel, (Component)this.clsField, (String)BuilderArb.getString(127));
        ResourceUtils.resLabel((JLabel)this.pkgLabel, (Component)this.pkgField, (String)BuilderArb.getString(20));
        ResourceUtils.resButton((AbstractButton)this.pkgBrowse, (String)BuilderArb.getString(39));
        this.clsField.getDocument().addDocumentListener(new DataFieldDocumentListener(null));
        this.pkgBrowse.addActionListener(this.pkgField);
        this.setLayout(this.mainLayout);
        Insets insets = new Insets(0, 0, 5, 0);
        Insets centerInsets = new Insets(0, 8, 5, 8);
        this.add((Component)this.clsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.clsField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, centerInsets, 0, 0));
        insets.bottom = 0;
        centerInsets.bottom = 0;
        this.add((Component)this.pkgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.pkgField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, centerInsets, 0, 0));
        this.add((Component)this.pkgBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
    }

    public void initializeFromState(BaliWizardState theState) {
        InterfaceBuilderModel state;
        this.savedState = state = (InterfaceBuilderModel)theState;
        this.pkgField.setProject(state.getProject());
        this.clsField.setText(state.getClassName());
        this.pkgField.setText(state.getPackage());
        state.getBuilderDialog().setInitialFocus((Component)this.clsField);
    }

    public boolean validateAndWriteToState(BaliWizardState theState) {
        String clsName;
        InterfaceBuilderModel state = (InterfaceBuilderModel)theState;
        boolean result = false;
        String pkgName = this.pkgField.getText();
        if (pkgName != null) {
            pkgName = pkgName.trim();
        }
        if ((clsName = this.clsField.getText()) != null) {
            clsName = clsName.trim();
        }
        try {
            state.setPackage(pkgName);
            state.setClassName(clsName);
            result = true;
        }
        catch (ClassBuilderModel.IllegalPackageNameException ex) {
            state.reportError(BuilderArb.getString(43), BuilderArb.format(31, pkgName, BuilderArb.getString(16)), "f1_idedclassnameinvalid_html");
            this.pkgField.requestFocus();
        }
        catch (ClassBuilderModel.IllegalClassNameException ex) {
            state.reportError(BuilderArb.getString(119), BuilderArb.format(31, this._getDisplayName(clsName, false), BuilderArb.getString(99)), "f1_idedclassnameinvalid_html");
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.DuplicateClassException ex) {
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.InvalidFileException ex) {
            state.reportError(BuilderArb.getString(2), BuilderArb.format(9, this._getDisplayName(ex.getPath(), true)), null);
        }
        return result;
    }

    private String _getDisplayName(String name, boolean shortenInMiddle) {
        String result = name;
        if (name.length() > FILENAME_DISPLAY_MAX_LENGTH) {
            result = shortenInMiddle ? BuilderArb.format(53, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH / 2), name.substring(name.length() - FILENAME_DISPLAY_MAX_LENGTH / 2)) : BuilderArb.format(112, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH));
        }
        return result;
    }

    static InterfaceBuilderModel ra$savedState(InterfaceBuilderPanel interfaceBuilderPanel) {
        return interfaceBuilderPanel.savedState;
    }

    private class DataFieldDocumentListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        private void enableOK(DocumentEvent de) {
            Document doc = de.getDocument();
            try {
                boolean enable = doc.getText(0, doc.getLength()).trim().length() > 0;
                InterfaceBuilderPanel.ra$savedState(InterfaceBuilderPanel.this).getBuilderDialog().setOKButtonEnabled(enable);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }

        private DataFieldDocumentListener() {
        }

        DataFieldDocumentListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

