/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.PlainDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.AddinManager;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.TemplateCellRenderer;
import oracle.jdeveloper.ceditor.template.TemplateConfigModel;
import oracle.jdeveloper.ceditor.template.TemplateOptions;
import oracle.jdeveloper.ceditor.template.Templates;
import oracle.jdeveloper.ceditor.template.VariableDataModel;

public final class ConfigPanel
extends JPanel
implements Traversable,
ApplyListener,
ListSelectionListener,
ActionListener,
DocumentListener,
FocusListener {
    private TemplateConfigModel _dataModel;
    private VariableDataModel _variableDataModel;
    private JTable _templateTable;
    private JTable _variableTable;
    private static int _currentRow;
    private JTextArea _text;
    private JTextArea _imports;
    private JButton _butAdd;
    private JButton _butDel;
    private boolean _bValuesChanging;
    private static final Highlighter.HighlightPainter myHighlightPainter;

    static void registerUI() {
        String sTitle = TemplateArb.getString(12);
        Navigable templateNavigable = new Navigable(sTitle, ConfigPanel.class);
        AddinManager am = AddinManager.getAddinManager();
        CodeEditorAddin myAddin = (CodeEditorAddin)am.getAddin(CodeEditorAddin.class);
        if (myAddin != null) {
            CodeEditorAddin ce = myAddin;
            Navigable ceNav = ce.getEditorNavigable();
            ceNav.addChildNavigable(templateNavigable);
        }
    }

    public ConfigPanel() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this._dataModel = new TemplateConfigModel(this);
        this._templateTable = new JTable(this._dataModel);
        this._variableDataModel = new VariableDataModel(null);
        this._variableTable = new JTable(this._variableDataModel);
        TableColumn typeColumn = this._variableTable.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("default");
        comboBox.addItem("smartIndex");
        comboBox.addItem("curMethod");
        comboBox.addItem("suggestNameFromType()");
        comboBox.addItem("typeOf()");
        comboBox.addItem("elementTypeOf()");
        comboBox.addItem("smartCollectionContent()");
        comboBox.addItem("smartListContent()");
        comboBox.addItem("smartMapValues()");
        comboBox.addItem("smartMapKeys()");
        comboBox.addItem("varOfType()");
        comboBox.addItem("copyOf()");
        comboBox.addItem("arrayOf()");
        comboBox.addItem("arrays");
        comboBox.addItem("date");
        comboBox.addItem("time");
        comboBox.addItem("year");
        comboBox.addItem("curPackage");
        comboBox.addItem("curProject");
        comboBox.addItem("curClass");
        comboBox.addItem("fileName");
        comboBox.addItem("userName");
        comboBox.setEditable(true);
        DefaultCellEditor typeEditor = new DefaultCellEditor(comboBox);
        typeColumn.setCellEditor(typeEditor);
        this._variableTable.setRowHeight(comboBox.getPreferredSize().height);
        this._templateTable.getColumnModel().getColumn(0).setCellRenderer(new TemplateCellRenderer(this._dataModel));
        JScrollPane scrollpane = new JScrollPane(this._templateTable);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollpane, "Center");
        FlowLayout fll = new FlowLayout();
        fll.setAlignment(2);
        JPanel panelTop = new JPanel(fll);
        this._butAdd = new JButton();
        this._butDel = new JButton();
        ResourceUtils.resButton((AbstractButton)this._butAdd, (String)TemplateArb.getString(8));
        ResourceUtils.resButton((AbstractButton)this._butDel, (String)TemplateArb.getString(0));
        this._butAdd.addActionListener(this);
        this._butDel.addActionListener(this);
        panelTop.add(this._butAdd);
        panelTop.add(this._butDel);
        tablePanel.add((Component)panelTop, "South");
        ListSelectionModel lsm = this._templateTable.getSelectionModel();
        lsm.setSelectionMode(0);
        lsm.addListSelectionListener(this);
        JTabbedPane tp = new JTabbedPane();
        this._text = new JTextArea();
        this._text.getDocument().addDocumentListener(this);
        this._text.addFocusListener(this);
        this._imports = new ImportTextField();
        this._imports.getDocument().addDocumentListener(this);
        Font fntDefault = UIManager.getFont("TextArea.font");
        Font fntFixed = new Font("MonoSpaced", 0, fntDefault.getSize());
        this._text.setFont(fntFixed);
        String label = StringUtils.stripMnemonic((String)TemplateArb.getString(6));
        int mnemonic = StringUtils.getMnemonicKeyCode((String)TemplateArb.getString(6));
        tp.addTab(label, new JScrollPane(this._text));
        tp.setMnemonicAt(0, mnemonic);
        label = StringUtils.stripMnemonic((String)TemplateArb.getString(2));
        mnemonic = StringUtils.getMnemonicKeyCode((String)TemplateArb.getString(2));
        tp.addTab(label, new JScrollPane(this._imports));
        tp.setMnemonicAt(1, mnemonic);
        label = StringUtils.stripMnemonic((String)TemplateArb.getString(9));
        mnemonic = StringUtils.getMnemonicKeyCode((String)TemplateArb.getString(9));
        tp.addTab(label, new JScrollPane(this._variableTable));
        tp.setMnemonicAt(2, mnemonic);
        CustomJSplitPane split = new CustomJSplitPane(0, (Component)tablePanel, (Component)tp);
        split.setDividerLocation(0.5);
        this.add((Component)split, "Center");
    }

    private void setValuesChanging(boolean b) {
        this._bValuesChanging = b;
    }

    private boolean isValuesChanging() {
        return this._bValuesChanging;
    }

    private Template getCurrentTemplate() {
        int nRow = this.getSelectedRow();
        if (nRow >= 0) {
            return this._dataModel.getTemplate(nRow);
        }
        return null;
    }

    private void syncDetail(int nRow) {
        if (nRow >= 0) {
            try {
                try {
                    this.setValuesChanging(true);
                    this._text.setEnabled(true);
                    this._imports.setEnabled(true);
                    Template t = this._dataModel.getTemplate(nRow);
                    t.checkVariables();
                    this._variableDataModel.setTemplate(t);
                    this._variableDataModel.setConfigPanel(this);
                    this._text.setText(t.getText());
                    this.highlight();
                    List imports = t.getImports();
                    StringBuffer sbImports = new StringBuffer();
                    int n = imports.size();
                    int i = 0;
                    while (i < n) {
                        String sImport = (String)imports.get(i);
                        sbImports.append(sImport);
                        sbImports.append('\n');
                        ++i;
                    }
                    this._imports.setText(sbImports.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            finally {
                this.setValuesChanging(false);
            }
        } else {
            this._text.setText("");
            this._text.setEnabled(false);
            this._imports.setText("");
            this._imports.setEnabled(false);
        }
    }

    private void startEdit(int nRow, int nCol) {
        this._templateTable.editCellAt(nRow, nCol);
        Component c = this._templateTable.getEditorComponent();
        if (c != null) {
            c.requestFocus();
        }
    }

    private static Templates getTemplates(TraversableContext tc) {
        TemplateOptions to = (TemplateOptions)tc.find("code-template-options");
        Templates templates = to.getTemplates();
        return templates;
    }

    private void setTemplates(Templates ts) {
        this._dataModel.setTemplates(ts);
        ListSelectionModel lsm = this._templateTable.getSelectionModel();
        Rectangle rCell = this._templateTable.getCellRect(_currentRow, 0, true);
        this._templateTable.scrollRectToVisible(rCell);
        lsm.setSelectionInterval(_currentRow, _currentRow);
    }

    private void whenAddPressed() {
        this.commitTableEditing(true);
        int nPos = this._dataModel.addEmptyTemplate();
        ListSelectionModel lsm = this._templateTable.getSelectionModel();
        Rectangle rCell = this._templateTable.getCellRect(nPos, 0, true);
        this._templateTable.scrollRectToVisible(rCell);
        lsm.setSelectionInterval(nPos, nPos);
        this._templateTable.editCellAt(nPos, 0);
    }

    private void whenDeletePressed() {
        this.commitTableEditing(false);
        int nRow = this.getSelectedRow();
        if (nRow >= 0) {
            this._dataModel.removeTemplate(nRow);
            ListSelectionModel lsm = this._templateTable.getSelectionModel();
            int nRows = this._dataModel.getRowCount();
            if (nRows != 0) {
                nRow = Math.min(nRows - 1, nRow);
                lsm.setSelectionInterval(nRow, nRow);
            } else {
                this.syncDetail(-1);
            }
        }
    }

    private int getSelectedRow() {
        int rowCount = this._dataModel.getRowCount();
        if (rowCount == 0) {
            return -1;
        }
        _currentRow = this._templateTable.getSelectedRow();
        return _currentRow;
    }

    private void setSelectedRow(int row) {
        int rowCount = this._dataModel.getRowCount();
        if (row < rowCount) {
            this._templateTable.setEditingRow(row);
        }
    }

    private void commitTableEditing(boolean showErrorMessages) {
        if (!showErrorMessages) {
            this._dataModel.setErrorMessagesEnabled(false);
        }
        try {
            TableCellEditor tce = this._templateTable.getCellEditor();
            if (tce != null) {
                tce.stopCellEditing();
            }
            if ((tce = this._variableTable.getCellEditor()) != null) {
                tce.stopCellEditing();
            }
        }
        finally {
            if (!showErrorMessages) {
                this._dataModel.setErrorMessagesEnabled(true);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm;
        if (!e.getValueIsAdjusting() && (lsm = (ListSelectionModel)e.getSource()).getSelectionMode() == 0) {
            int nRow = this.getSelectedRow();
            int nCol = this._templateTable.getSelectedColumn();
            this.syncDetail(nRow);
            if (nRow >= 0) {
                this.startEdit(nRow, nCol);
            }
        }
    }

    public void onEntry(TraversableContext dataContext) {
        Templates templates = ConfigPanel.getTemplates(dataContext);
        this.setTemplates(templates);
        this.setSelectedRow(_currentRow);
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commitTableEditing(false);
        this._dataModel.onExit();
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return "f1_idedidesetcodetemplates_html";
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        Templates templates = ConfigPanel.getTemplates(tc);
        templates.save();
    }

    public void cancel(ApplyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._butAdd) {
            this.whenAddPressed();
        } else if (e.getSource() == this._butDel) {
            this.whenDeletePressed();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.whenDocumentChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.whenDocumentChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.whenDocumentChanged(e);
    }

    private void whenDocumentChanged(DocumentEvent e) {
        Template t;
        if (!this.isValuesChanging() && (t = this.getCurrentTemplate()) != null) {
            Document doc = e.getDocument();
            if (doc == this._text.getDocument()) {
                String sText = this._text.getText();
                this.highlight();
                t.setText(sText);
            } else {
                String sImports = this._imports.getText();
                t.setImports(sImports);
            }
        }
    }

    public void highlight() {
        Highlighter hilite = this._text.getHighlighter();
        hilite.removeAllHighlights();
        try {
            Document doc = this._text.getDocument();
            String text = doc.getText(0, doc.getLength());
            int pos = 0;
            int oldpos = -1;
            while ((pos = text.indexOf(36, pos)) >= 0) {
                if (oldpos == -1) {
                    oldpos = pos++;
                    continue;
                }
                hilite.addHighlight(oldpos, ++pos, myHighlightPainter);
                oldpos = -1;
            }
            if (oldpos != -1) {
                hilite.addHighlight(oldpos, doc.getLength(), myHighlightPainter);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        Template t = this.getCurrentTemplate();
        if (t != null) {
            t.checkVariables();
            this._variableDataModel.setTemplate(t);
            this._variableDataModel.setConfigPanel(this);
        }
    }

    static {
        myHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
    }

    static class ImportTextField
    extends JTextArea {
        protected Document createDefaultModel() {
            return new ImportDocument();
        }

        protected class ImportDocument
        extends PlainDocument {
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                int i = 0;
                while (i < result.length) {
                    if (Character.isJavaIdentifierPart(source[i]) || source[i] == '.' || source[i] == '\n') {
                        result[j++] = source[i];
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    ++i;
                }
                super.insertString(offs, new String(result, 0, j), a);
            }

            protected ImportDocument() {
            }
        }
    }
}

