/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.ceditor.template.AbstractVariableProcessor;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.ceditor.template.TemplateJotUtils;
import oracle.jdeveloper.ceditor.template.TemplateVariable;
import oracle.jdeveloper.ceditor.template.TemplateVariableProcessor;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public class DefaultVariableProcessor
extends AbstractVariableProcessor {
    private String decapitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        sb.append(s.substring(0, 1).toLowerCase());
        sb.append(s.substring(1));
        return sb.toString();
    }

    public String suggestNameFromType(TemplateContext ctx, int offset, String type, String oldValue) {
        if (oldValue == null) {
            return "XXXXXXXXX";
        }
        boolean isArray = false;
        while (type.endsWith("[]")) {
            isArray = true;
            type = type.substring(0, type.length() - 2);
        }
        String suggest = type.equals("String") ? (isArray ? "strings" : "s") : (type.equals("int") ? (isArray ? type + 's' : "i") : (type.equals("boolean") ? (isArray ? type + 's' : "b") : (type.equals("long") ? (isArray ? type + 's' : "l") : (type.equals("char") ? (isArray ? type + 's' : "c") : (type.equals("float") ? (isArray ? type + 's' : "v") : (type.equals("byte") ? (isArray ? type + 's' : "b") : (type.equals("double") ? (isArray ? type + 's' : "v") : (type.equals("short") ? (isArray ? type + 's' : "i") : (isArray ? this.decapitalize(type) + 's' : this.decapitalize(type))))))))));
        HashSet<String> localId = new HashSet<String>();
        String[] idlist = TemplateJotUtils.getCurrentMethodArguments(ctx, offset);
        int i = 0;
        while (i < idlist.length) {
            localId.add(idlist[i]);
            ++i;
        }
        idlist = TemplateJotUtils.getCurrentMethodLocals(ctx, offset);
        int i2 = 0;
        while (i2 < idlist.length) {
            localId.add(idlist[i2]);
            ++i2;
        }
        localId.remove(oldValue);
        localId.add("float");
        localId.add("int");
        localId.add("short");
        localId.add("byte");
        localId.add("char");
        localId.add("long");
        localId.add("boolean");
        localId.add("double");
        if (localId.contains(suggest)) {
            int index = 1;
            while (localId.contains(suggest + index)) {
                ++index;
            }
            suggest = suggest + index;
        }
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        suggest = styleOptions.getLocalVariableName(suggest);
        return suggest;
    }

    public String getSmartIndex(TemplateContext ctx, int offset, String oldValue) {
        if (oldValue == null) {
            return "XXXXXXXXXXXXXXXXXXXXX";
        }
        HashSet<String> localId = new HashSet<String>();
        String[] idlist = TemplateJotUtils.getCurrentMethodArguments(ctx, offset);
        int i = 0;
        while (i < idlist.length) {
            localId.add(idlist[i]);
            ++i;
        }
        idlist = TemplateJotUtils.getCurrentMethodLocals(ctx, offset);
        int i2 = 0;
        while (i2 < idlist.length) {
            localId.add(idlist[i2]);
            ++i2;
        }
        localId.remove(oldValue);
        String seed = " ijklmnopqrstuvwxyz";
        int base = seed.length();
        int max = base * base * base;
        int i3 = 0;
        while (i3 < max) {
            int p1 = i3 % base;
            int p2 = i3 / base % base;
            int p3 = i3 / (base * base) % base;
            String vname = "" + seed.charAt(p3) + seed.charAt(p2) + seed.charAt(p1);
            if (!(vname = vname.trim()).equals("") && !localId.contains(vname)) {
                return vname;
            }
            ++i3;
        }
        return "XXXXX";
    }

    public boolean canProcessVariable(TemplateContext ctx, TemplateVariable var) {
        String loctype = var.getType();
        String type = this.nameFromType(loctype);
        if (type.equals("smartIndex") || type.equals("smartListContent") || type.equals("smartCollectionContent") || type.equals("smartMapValues") || type.equals("smartMapKeys") || type.equals("elementTypeOf") || type.equals("copyOf") || type.equals("typeOf") || type.equals("varOfType") || type.equals("suggestNameFromType") || type.equals("arrayOf") || type.equals("arrays") || type.equals("curMethod") || type.equals("cel") || type.equals("default") || type.equals("date") || type.equals("time") || type.equals("year") || type.equals("curPackage") || type.equals("curProject") || type.equals("curClass") || type.equals("fileName") || type.equals("userName")) {
            return true;
        }
        System.out.println("Warning unknown template type " + loctype + " Assume it's default");
        return true;
    }

    public static ArrayList getSmartListContent(TemplateContext ctx, int offset, String varname) {
        JavaType containerType;
        SourceVariable container = TemplateJotUtils.getSourceVariable(ctx.getCodeEditor(), offset);
        if (container != null && (containerType = container.getResolvedType()).hasActualTypeArguments()) {
            ArrayList<String> valueTypes = new ArrayList<String>();
            valueTypes.add(((JavaType)containerType.getActualTypeArguments().toArray()[0]).getQualifiedName());
            return valueTypes;
        }
        String[] mnames = new String[]{"add", "contains", "remove", "indexOf", "lastIndexOf", "set"};
        int[] offsets = new int[]{1, 1, 1, 1, 1, 1};
        return TemplateJotUtils.getSmartContent(ctx, offset, varname, mnames, offsets);
    }

    public static ArrayList getSmartCollectionContent(TemplateContext ctx, int offset, String varname) {
        JavaType containerType;
        SourceVariable container = TemplateJotUtils.getSourceVariable(ctx.getCodeEditor(), offset);
        if (container != null && (containerType = container.getResolvedType()).hasActualTypeArguments()) {
            ArrayList<String> valueTypes = new ArrayList<String>();
            valueTypes.add(((JavaType)containerType.getActualTypeArguments().toArray()[0]).getQualifiedName());
            return valueTypes;
        }
        String[] mnames = new String[]{"add", "contains", "remove"};
        int[] offsets = new int[]{1, 1, 1};
        return TemplateJotUtils.getSmartContent(ctx, offset, varname, mnames, offsets);
    }

    public static ArrayList getSmartMapValueContent(TemplateContext ctx, int offset, String varname) {
        JavaType containerType;
        SourceVariable container = TemplateJotUtils.getSourceVariable(ctx.getCodeEditor(), offset);
        if (container != null && (containerType = container.getResolvedType()).hasTypeParameters()) {
            ArrayList<String> valueTypes = new ArrayList<String>();
            valueTypes.add(((JavaType)containerType.getActualTypeArguments().toArray()[1]).getQualifiedName());
            return valueTypes;
        }
        String[] mnames = new String[]{"put", "containsValue"};
        int[] offsets = new int[]{1, 1};
        return TemplateJotUtils.getSmartContent(ctx, offset, varname, mnames, offsets);
    }

    public static ArrayList getSmartMapKeyContent(TemplateContext ctx, int offset, String varname) {
        JavaType containerType;
        SourceVariable container = TemplateJotUtils.getSourceVariable(ctx.getCodeEditor(), offset);
        if (container != null && (containerType = container.getResolvedType()).hasTypeParameters()) {
            ArrayList<String> valueTypes = new ArrayList<String>();
            valueTypes.add(((JavaType)containerType.getActualTypeArguments().toArray()[0]).getQualifiedName());
            return valueTypes;
        }
        String[] mnames = new String[]{"put", "containsKey", "remove", "get"};
        int[] offsets = new int[]{2, 1, 1, 1};
        return TemplateJotUtils.getSmartContent(ctx, offset, varname, mnames, offsets);
    }

    public HintChoice[] getHints(TemplateContext ctx, TemplateVariable var, int offset) {
        if (!ctx.isJavaCode()) {
            return TemplateVariableProcessor.EMPTY_HINTLIST;
        }
        String loctype = var.getType();
        String type = this.nameFromType(loctype);
        if (type.equals("varOfType")) {
            String val = this.argFromType(loctype);
            if (val == null) {
                return TemplateVariableProcessor.EMPTY_HINTLIST;
            }
            String vname = this.varNameFromArg(val);
            int ofs = offset;
            if (vname != null) {
                val = ctx.getTemplate().getCurrentValueByName(vname);
                if (val == null) {
                    return TemplateVariableProcessor.EMPTY_HINTLIST;
                }
                ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
            }
            HintChoice[] res = TemplateJotUtils.getCurrentHintsIdentifiersOfType(ctx, ofs, val);
            return res;
        }
        if (type.equals("varOfTypeV2")) {
            String val = this.argFromType(loctype);
            if (val == null) {
                return TemplateVariableProcessor.EMPTY_HINTLIST;
            }
            String vname = this.varNameFromArg(val);
            int ofs = offset;
            if (vname != null) {
                val = ctx.getTemplate().getCurrentValueByName(vname);
                if (val == null) {
                    return TemplateVariableProcessor.EMPTY_HINTLIST;
                }
                ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
            }
            HintChoice[] res = TemplateJotUtils.getCurrentHintsIdentifiersOfType(ctx, ofs, val);
            return res;
        }
        if (type.equals("arrays")) {
            HintChoice[] res = TemplateJotUtils.getCurrentHintsArraysIdentifiersOfType(ctx, offset, null);
            return res;
        }
        if (type.equals("smartListContent")) {
            ArrayList content;
            String val = this.argFromType(loctype);
            if (val == null) {
                return TemplateVariableProcessor.EMPTY_HINTLIST;
            }
            String vname = this.varNameFromArg(val);
            int ofs = offset;
            if (vname != null) {
                val = ctx.getTemplate().getCurrentValueByName(vname);
                if (val == null) {
                    return TemplateVariableProcessor.EMPTY_HINTLIST;
                }
                ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
            }
            if ((content = DefaultVariableProcessor.getSmartListContent(ctx, ofs, val)).size() > 0) {
                HintChoice[] res = new HintChoice[content.size()];
                int i = 0;
                while (i < content.size()) {
                    String suggest = (String)content.get(i);
                    res[i] = new HintChoice(TemplateJotUtils.shortClassName(suggest), "", 3);
                    ++i;
                }
                return res;
            }
            return TemplateVariableProcessor.EMPTY_HINTLIST;
        }
        if (type.equals("smartCollectionContent")) {
            ArrayList content;
            String val = this.argFromType(loctype);
            if (val == null) {
                return TemplateVariableProcessor.EMPTY_HINTLIST;
            }
            String vname = this.varNameFromArg(val);
            int ofs = offset;
            if (vname != null) {
                val = ctx.getTemplate().getCurrentValueByName(vname);
                if (val == null) {
                    return TemplateVariableProcessor.EMPTY_HINTLIST;
                }
                ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
            }
            if ((content = DefaultVariableProcessor.getSmartCollectionContent(ctx, ofs, val)).size() > 0) {
                HintChoice[] res = new HintChoice[content.size()];
                int i = 0;
                while (i < content.size()) {
                    String suggest = (String)content.get(i);
                    res[i] = new HintChoice(TemplateJotUtils.shortClassName(suggest), "", 3);
                    ++i;
                }
                return res;
            }
            return TemplateVariableProcessor.EMPTY_HINTLIST;
        }
        if (type.equals("smartMapValues")) {
            ArrayList content;
            String val = this.argFromType(loctype);
            if (val == null) {
                return TemplateVariableProcessor.EMPTY_HINTLIST;
            }
            String vname = this.varNameFromArg(val);
            int ofs = offset;
            if (vname != null) {
                val = ctx.getTemplate().getCurrentValueByName(vname);
                if (val == null) {
                    return TemplateVariableProcessor.EMPTY_HINTLIST;
                }
                ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
            }
            if ((content = DefaultVariableProcessor.getSmartMapValueContent(ctx, ofs, val)).size() > 0) {
                HintChoice[] res = new HintChoice[content.size()];
                int i = 0;
                while (i < content.size()) {
                    String suggest = (String)content.get(i);
                    res[i] = new HintChoice(TemplateJotUtils.shortClassName(suggest), "", 3);
                    ++i;
                }
                return res;
            }
            return TemplateVariableProcessor.EMPTY_HINTLIST;
        }
        if (type.equals("smartMapKeys")) {
            ArrayList content;
            String val = this.argFromType(loctype);
            if (val == null) {
                return TemplateVariableProcessor.EMPTY_HINTLIST;
            }
            String vname = this.varNameFromArg(val);
            int ofs = offset;
            if (vname != null) {
                val = ctx.getTemplate().getCurrentValueByName(vname);
                if (val == null) {
                    return TemplateVariableProcessor.EMPTY_HINTLIST;
                }
                ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
            }
            if ((content = DefaultVariableProcessor.getSmartMapKeyContent(ctx, ofs, val)).size() > 0) {
                HintChoice[] res = new HintChoice[content.size()];
                int i = 0;
                while (i < content.size()) {
                    String suggest = (String)content.get(i);
                    res[i] = new HintChoice(TemplateJotUtils.shortClassName(suggest), "", 3);
                    ++i;
                }
                return res;
            }
            return TemplateVariableProcessor.EMPTY_HINTLIST;
        }
        return TemplateVariableProcessor.EMPTY_HINTLIST;
    }

    public boolean isCalculatedField(TemplateContext ctx, TemplateVariable var, int offset) {
        if (!ctx.isJavaCode()) {
            return false;
        }
        String loctype = var.getType();
        String type = this.nameFromType(loctype);
        return type.equals("smartListContent") || type.equals("smartMapValues") || type.equals("smartCollectionContent") || type.equals("smartMapKeys") || type.equals("elementTypeOf") || type.equals("copyOf") || type.equals("typeOf") || type.equals("varOfType") || type.equals("suggestNameFromType") || type.equals("arrayOf");
    }

    public String guessValue(TemplateContext ctx, TemplateVariable var, int offset, String oldValue) {
        String loctype = var.getType();
        String type = this.nameFromType(loctype);
        if (ctx.isJavaCode()) {
            if (type.equals("smartIndex")) {
                return this.getSmartIndex(ctx, offset, oldValue);
            }
            if (type.equals("smartCollectionContent")) {
                ArrayList content;
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                if ((content = DefaultVariableProcessor.getSmartCollectionContent(ctx, ofs, val)).size() > 0) {
                    String suggest = (String)content.get(0);
                    suggest = suggest.substring(suggest.lastIndexOf(46) + 1);
                    suggest = suggest.substring(suggest.lastIndexOf(36) + 1);
                    return suggest;
                }
                return "Object";
            }
            if (type.equals("smartListContent")) {
                ArrayList content;
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                if ((content = DefaultVariableProcessor.getSmartListContent(ctx, ofs, val)).size() > 0) {
                    String suggest = (String)content.get(0);
                    suggest = suggest.substring(suggest.lastIndexOf(46) + 1);
                    suggest = suggest.substring(suggest.lastIndexOf(36) + 1);
                    return suggest;
                }
                return "Object";
            }
            if (type.equals("smartMapValues")) {
                ArrayList content;
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                if ((content = DefaultVariableProcessor.getSmartMapValueContent(ctx, ofs, val)).size() > 0) {
                    String suggest = (String)content.get(0);
                    return suggest.substring(suggest.lastIndexOf(46) + 1);
                }
                return "Object";
            }
            if (type.equals("smartMapKeys")) {
                ArrayList content;
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                if ((content = DefaultVariableProcessor.getSmartMapKeyContent(ctx, ofs, val)).size() > 0) {
                    String suggest = (String)content.get(0);
                    return suggest.substring(suggest.lastIndexOf(46) + 1);
                }
                return "Object";
            }
            if (type.equals("elementTypeOf")) {
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                return TemplateJotUtils.getElementTypeOf(ctx, ofs, val);
            }
            if (type.equals("copyOf")) {
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                if (vname != null && (val = ctx.getTemplate().getCurrentValueByName(vname)) == null) {
                    return null;
                }
                return val;
            }
            if (type.equals("typeOf")) {
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                return TemplateJotUtils.getTypeOf(ctx, ofs, val);
            }
            if (type.equals("varOfType")) {
                String[] args;
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                if ((args = TemplateJotUtils.getCurrentIdentifiersOfType(ctx, ofs, val)).length > 0) {
                    return args[0];
                }
                return "unknown";
            }
            if (type.equals("varOfTypeV2")) {
                String[] args;
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                if ((args = TemplateJotUtils.getCurrentIdentifiersOfType(ctx, ofs, val)).length > 0) {
                    return args[0];
                }
                return "unknown";
            }
            if (type.equals("suggestNameFromType")) {
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                return this.suggestNameFromType(ctx, ofs, val, oldValue);
            }
            if (type.equals("arrayOf")) {
                String val = this.argFromType(loctype);
                if (val == null) {
                    return "<ERROR>";
                }
                String vname = this.varNameFromArg(val);
                int ofs = offset;
                if (vname != null) {
                    val = ctx.getTemplate().getCurrentValueByName(vname);
                    if (val == null) {
                        return null;
                    }
                    ofs = ctx.getTemplate().getCurrentOffsetByName(vname);
                }
                return val + "[]";
            }
            if (type.equals("arrays")) {
                HintChoice[] res = TemplateJotUtils.getCurrentHintsArraysIdentifiersOfType(ctx, offset, null);
                if (res.length > 0) {
                    return res[0].getName();
                }
                return "unknown";
            }
            if (type.equals("curMethod")) {
                return TemplateJotUtils.getCurrentMethodName(ctx, offset);
            }
            if (type.equals("date")) {
                DateFormat dateFormat = SimpleDateFormat.getDateInstance();
                return dateFormat.format(new Date());
            }
            if (type.equals("time")) {
                DateFormat timeFormat = SimpleDateFormat.getTimeInstance();
                return timeFormat.format(new Date());
            }
            if (type.equals("year")) {
                return Integer.toString(Calendar.getInstance().get(1));
            }
            if (type.equals("curPackage")) {
                return TemplateJotUtils.getCurrentPackageName(ctx, offset);
            }
            if (type.equals("curProject")) {
                return ctx.getCodeEditor().getContext().getProject().getShortLabel();
            }
            if (type.equals("curClass")) {
                return TemplateJotUtils.getCurrentClassName(ctx, offset);
            }
            if (type.equals("fileName")) {
                String res = ctx.getCodeEditor().getContext().getNode().getShortLabel();
                if (res == null) {
                    res = "duhhh";
                }
                return res;
            }
            if (type.equals("userName")) {
                String res = System.getProperty("user.name", "Unknown");
                return res;
            }
        }
        return var.getDefValue();
    }
}

