/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateController;
import oracle.jdeveloper.ceditor.template.TemplateVariable;

public class PseudoTemplateFactory {
    Template _t;
    private ArrayList _zones;
    private BasicEditorPane _editor;
    private CodeEditor _codeEditor;

    public void setEnd(int offset) {
        this.addZoneInternal("end", offset, offset);
    }

    public int getStartPos() {
        if (this._zones.size() != 0) {
            Zone zn = (Zone)this._zones.get(0);
            return zn._start;
        }
        return 0;
    }

    public int getEndPos() {
        if (this._zones.size() != 0) {
            Zone zn = (Zone)this._zones.get(this._zones.size() - 1);
            return zn._end;
        }
        return 0;
    }

    public void addZone(String id, int st, int en) {
        this.addZoneInternal(id + id, st, en);
    }

    private void addZoneInternal(String id, int st, int en) {
        String orgtext;
        try {
            orgtext = this._editor.getText(st, en - st);
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Bad zones offsets in template");
        }
        TemplateVariable var = this._t.getVariable(id);
        if (var == null && !id.equals("end")) {
            this._t.addOrUpdateVariable(id, "default", orgtext, true);
        }
        int i = 0;
        while (i < this._zones.size()) {
            Zone zone = (Zone)this._zones.get(i);
            if (en > zone._start && st < zone._end) {
                throw new RuntimeException("Overlaping zones in template");
            }
            if (st <= zone._start) break;
            ++i;
        }
        this._zones.add(i, new Zone(id, st, en));
    }

    public void addVariable(String id, String type, String def, boolean editable) {
        id = id + id;
        this._t.addOrUpdateVariable(id, type, def, editable);
    }

    public PseudoTemplateFactory(Context context) {
        this._editor = TemplateController.getEditor(context);
        this._t = new Template();
        this._codeEditor = TemplateController.getCodeEditor(context);
        this._zones = new ArrayList();
    }

    public void realize() {
        Zone[] zones = new Zone[this._zones.size()];
        zones = this._zones.toArray(zones);
        try {
            if (zones.length != 0) {
                int st = zones[0]._start;
                int en = zones[zones.length - 1]._end;
                int curzone = 0;
                StringBuffer sb = new StringBuffer(en - st + 4 * zones.length);
                while (curzone < zones.length) {
                    if (st == zones[curzone]._start) {
                        sb.append('$');
                        sb.append(zones[curzone]._name);
                        sb.append('$');
                        st = zones[curzone]._end;
                        ++curzone;
                        continue;
                    }
                    String cstst = this._editor.getText(st, zones[curzone]._start - st);
                    int i = 0;
                    while (i < cstst.length()) {
                        char c = cstst.charAt(i);
                        if (c == '$') {
                            sb.append("$$");
                        } else {
                            sb.append(c);
                        }
                        ++i;
                    }
                    st = zones[curzone]._start;
                }
                this._t.setText(sb.toString());
                this._t.parseVariables();
                this._editor.select(this.getStartPos(), this.getEndPos());
                TemplateController.launchEdit(this._editor, this._codeEditor, this._t, this.getStartPos());
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Unexpected error in realize");
        }
    }

    static class Zone {
        String _name;
        int _start;
        int _end;

        public Zone(String name, int st, int en) {
            this._name = name;
            this._start = st;
            this._end = en;
        }
    }
}

