/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;

class SourceImportsDesc {
    private SourceImport[] _imports;
    private SourcePackage _package;
    private int _nEndImportPos;

    private void $init$() {
        this._nEndImportPos = -1;
    }

    private SourceImportsDesc() {
        this.$init$();
    }

    static SourceImportsDesc parse(Context context) {
        SourceImportsDesc ret = null;
        Node node = context.getNode();
        if (node instanceof JavaSourceNode) {
            JavaManager mgr = JavaManager.getJavaManager((Project)context.getProject());
            SourceFile sourceFile = mgr.getSourceFile(node.getURL());
            SourceImportsDesc sid = new SourceImportsDesc();
            sid._imports = sourceFile.getSourceImports().toArray(new SourceImport[0]);
            sid._package = sourceFile.getSourcePackage();
            ret = sid;
        }
        return ret;
    }

    int getEndImportPosition() {
        if (this._nEndImportPos == -1) {
            if (this._package != null) {
                this._nEndImportPos = this._package.getEndOffset();
            }
            if (this._imports != null) {
                int i = 0;
                while (i < this._imports.length) {
                    SourceImport is = this._imports[i];
                    this._nEndImportPos = Math.max(is.getEndOffset(), this._nEndImportPos);
                    ++i;
                }
            }
        }
        return this._nEndImportPos;
    }

    boolean hasImport(String sImport) {
        boolean bRet = false;
        String sTemplatePackage = null;
        int i = 0;
        while (!bRet && i < this._imports.length) {
            SourceImport is = this._imports[i];
            String sSourceImport = is.getName();
            if (sSourceImport.endsWith(".*")) {
                if (sTemplatePackage == null) {
                    sTemplatePackage = SourceImportsDesc.getPackage(sImport);
                }
                if (SourceImportsDesc.getPackage(sSourceImport).equals(sTemplatePackage)) {
                    bRet = true;
                }
            } else if (sSourceImport.equals(sImport)) {
                bRet = true;
            }
            ++i;
        }
        return bRet;
    }

    private static String getPackage(String sFullQualClass) {
        int i = sFullQualClass.lastIndexOf(46);
        return sFullQualClass.substring(0, i);
    }
}

