/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.ceditor.template.TemplateVariable;

final class Template
implements Copyable {
    private static StringBuffer BLANKS = new StringBuffer("        ");
    private String _shortcut;
    private String _before;
    private String _desc;
    private ArrayList _imports;
    private ArrayList _variables;
    private boolean _valid;
    private String[] _fields;
    private int[][] _fieldsPosition;
    private int[] _offsets;
    private int _endOffset;
    private String[] _values;
    private boolean[] _entered;
    private OffsetMark[] _fieldOffset;

    private void $init$() {
        this._valid = true;
    }

    Template(String sShortcut, String sDesc, String sBefore) {
        this.$init$();
        this._shortcut = sShortcut;
        this._before = sBefore == null ? "" : sBefore;
        this._desc = sDesc;
    }

    private Template(String sShortcut, String sDesc, String sBefore, ArrayList imports) {
        this.$init$();
        this._shortcut = sShortcut == null ? "" : sShortcut;
        this._before = sBefore == null ? "" : sBefore;
        this._desc = sDesc == null ? "" : sDesc;
        this._imports = imports;
    }

    Template() {
        this("", "", "", null);
    }

    public Template(String text) {
        this("", text, "", null);
    }

    private final void copyToImpl(Template copy) {
        copy._shortcut = this._shortcut;
        copy._before = this._before;
        copy._desc = this._desc;
        if (this._imports != null) {
            copy._imports = new ArrayList(this._imports.size());
            copy._imports.addAll(this._imports);
        } else {
            copy._imports = null;
        }
        if (this._variables != null) {
            copy._variables = new ArrayList(this._variables.size());
            int i = 0;
            while (i < this._variables.size()) {
                TemplateVariable var = (TemplateVariable)this._variables.get(i);
                copy._variables.add(new TemplateVariable(var));
                ++i;
            }
        } else {
            copy._variables = null;
        }
    }

    void toXML(PrintWriter out) {
        out.println("  <item>");
        out.println("    <abbr><![CDATA[" + this.getShortcut() + "]]></" + "abbr" + ">");
        out.println("    <descr><![CDATA[" + this.getDescription() + "]]></" + "descr" + ">");
        out.println("    <text1><![CDATA[" + this._before + "]]></" + "text1" + ">");
        int n = this._imports == null ? 0 : this._imports.size();
        int i = 0;
        while (i < n) {
            out.println("    <import>" + this._imports.get(i).toString() + "</" + "import" + ">");
            ++i;
        }
        n = this._variables == null ? 0 : this._variables.size();
        int i2 = 0;
        while (i2 < n) {
            TemplateVariable var = (TemplateVariable)this._variables.get(i2);
            var.toXML(out);
            ++i2;
        }
        out.println(" </item>");
    }

    String getShortcut() {
        return this._shortcut;
    }

    void setShortcut(String s) {
        this._shortcut = s;
    }

    String getText() {
        return this._before;
    }

    public void checkVariables() {
        HashMap vnames = new HashMap();
        this.parseToHashMap(vnames);
        if (this._variables != null) {
            int i = 0;
            while (i < this._variables.size()) {
                TemplateVariable var = (TemplateVariable)this._variables.get(i);
                if (vnames.containsKey(var.getName())) {
                    ++i;
                    continue;
                }
                this._variables.remove(i);
            }
        }
        for (String key : vnames.keySet()) {
            TemplateVariable var = this.getVariable(key);
            if (var != null) continue;
            this.addVariable(new TemplateVariable(key, "default", key, true));
        }
    }

    void setText(String sText) {
        this._before = sText;
    }

    String getDescription() {
        return this._desc == null ? "" : this._desc;
    }

    void setDescription(String s) {
        this._desc = s;
    }

    int getCursorPos() {
        return this._endOffset;
    }

    int getInitialCursorPos() {
        if (this._fields.length > 0) {
            return this._offsets[0];
        }
        return this._endOffset;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setValid(boolean valid) {
        this._valid = valid;
    }

    public void addVariable(TemplateVariable var) {
        if (this._variables == null) {
            this._variables = new ArrayList(2);
        }
        if (!this._variables.contains(var)) {
            int i = 0;
            while (i < this._variables.size() && var.compareTo(this._variables.get(i)) > 0) {
                ++i;
            }
            this._variables.add(i, var);
        }
    }

    public List getVariables() {
        if (this._variables == null) {
            return Collections.EMPTY_LIST;
        }
        return this._variables;
    }

    public int getVariableIndex(String name) {
        if (this._variables == null) {
            return -1;
        }
        return this._variables.indexOf(new TemplateVariable(name, null, null, false));
    }

    public TemplateVariable getVariable(String name) {
        int index = this.getVariableIndex(name);
        if (index == -1) {
            return null;
        }
        return (TemplateVariable)this._variables.get(index);
    }

    public void removeVariable(String name) {
        int index = this._variables.indexOf(new TemplateVariable(name, null, null, false));
        if (index == -1) {
            this._variables.remove(index);
        }
    }

    public void addOrUpdateVariable(String name, String type, String defval, boolean editable) {
        TemplateVariable var = this.getVariable(name);
        if (var == null) {
            this.addVariable(new TemplateVariable(name, type, defval, editable));
        } else {
            var.setType(type);
            var.setDefValue(defval);
            var.setEditable(editable);
        }
    }

    public void addImport(String sImport) {
        if (this._imports == null) {
            this._imports = new ArrayList(2);
        }
        if (!this._imports.contains(sImport)) {
            this._imports.add(sImport);
        }
    }

    public List getImports() {
        if (this._imports == null) {
            return Collections.EMPTY_LIST;
        }
        return this._imports;
    }

    public void setImports(String sImports) {
        ArrayList<String> list = new ArrayList<String>(2);
        StringTokenizer st = new StringTokenizer(sImports, "\n");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        this.setImports(list);
    }

    public void setImports(List imports) {
        if (this._imports == null) {
            this._imports = new ArrayList(imports.size());
        } else {
            this._imports.clear();
        }
        this._imports.addAll(imports);
    }

    public boolean isEmpty() {
        return (this._imports == null || this._imports.isEmpty()) && this._shortcut.length() == 0 && this._before.length() == 0 && this._desc.length() == 0;
    }

    Template adjust(String sIndent, boolean bBracesSameLine, int nIndentSize, int nTabStop, boolean bUseTab) {
        Template res = new Template();
        this.copyToImpl(res);
        res._before = Template.adjust(this._before, sIndent, bBracesSameLine, nIndentSize, nTabStop, bUseTab);
        return res;
    }

    private static String adjust(String s, String sIndent, boolean bBracesSameLine, int nIndentSize, int nTabStop, boolean bUseTab) {
        StringBuffer sb = Template.indent(s, sIndent, nIndentSize, nTabStop, bUseTab);
        if (bBracesSameLine) {
            sb = Template.adaptBracesSameLine(sb);
        }
        return sb.toString();
    }

    private static StringBuffer indent(String sText, String sIndent, int nIndentSize, int nTabStop, boolean bUseTab) {
        int nBaseIndentLevel = Template.getIndentLevel(sIndent, nIndentSize, nTabStop);
        StringBuffer sb = new StringBuffer();
        int n = sText.length();
        int i = 0;
        while (i < n) {
            char c = sText.charAt(i);
            sb.append(c);
            if (c == '\n') {
                int nIndentLevel = Template.countTabs(sText, i + 1);
                if (nIndentLevel > 0) {
                    i += nIndentLevel;
                    int nSpaces = nIndentLevel * nIndentSize;
                    int nTabs = 0;
                    if (bUseTab) {
                        int nColumns = (nIndentLevel += nBaseIndentLevel) * nIndentSize;
                        nTabs = nColumns / nTabStop;
                        nSpaces = nColumns % nTabStop;
                    } else {
                        sb.append(sIndent);
                    }
                    int j = 0;
                    while (j < nTabs) {
                        sb.append('\t');
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < nSpaces) {
                        sb.append(' ');
                        ++j2;
                    }
                } else {
                    sb.append(sIndent);
                }
            }
            ++i;
        }
        return sb;
    }

    private static int getIndentLevel(String sIndent, int nIndentSize, int nTabStop) {
        int nSpaces = 0;
        int nTabs = 0;
        int n = sIndent.length();
        int i = 0;
        while (i < n) {
            char c = sIndent.charAt(i);
            if (c == '\t') {
                ++nTabs;
            } else if (c == ' ') {
                ++nSpaces;
            }
            ++i;
        }
        int nTotalSpaces = nSpaces + nTabs * nTabStop;
        return nTotalSpaces / nIndentSize;
    }

    private static int countTabs(String sText, int position) {
        int nTabs = 0;
        int n = sText.length();
        int i = position;
        while (i < n) {
            char c;
            if ((c = sText.charAt(i++)) != '\t') break;
            ++nTabs;
        }
        return nTabs;
    }

    private static StringBuffer adaptBracesSameLine(StringBuffer sb) {
        int n = sb.length();
        int nNL = -1;
        int nState = 0;
        int i = 0;
        while (i < n) {
            char c = sb.charAt(i);
            block0 : switch (nState) {
                case 0: {
                    switch (c) {
                        case '\n': {
                            nNL = i;
                            nState = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break block0;
                        }
                        case '{': {
                            nState = 2;
                            break block0;
                        }
                    }
                    nState = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break block0;
                        }
                        case '\n': {
                            nState = 0;
                            sb.replace(nNL, i, " {");
                            n = sb.length();
                            break block0;
                        }
                    }
                    nState = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return sb;
    }

    private int parseToHashMap(HashMap vnames) {
        StringBuffer fulltext = new StringBuffer(this.getText());
        int state = 0;
        int pstart = 0;
        int lim = fulltext.length();
        int noffs = 0;
        int i = 0;
        while (i < lim) {
            char c = fulltext.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '$') break;
                    pstart = i;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c != '$') break;
                    String varname = fulltext.substring(pstart + 1, i);
                    if (!varname.equalsIgnoreCase("end") && !varname.equals("")) {
                        vnames.put(varname, null);
                        ++noffs;
                    }
                    state = 0;
                    break;
                }
            }
            ++i;
        }
        return noffs;
    }

    public void parseVariables() {
        StringBuffer fulltext = new StringBuffer(this.getText());
        HashMap<String, ArrayList<Integer>> vnames = new HashMap<String, ArrayList<Integer>>();
        this._endOffset = this._before.length();
        int state = 0;
        int pstart = 0;
        int lim = fulltext.length();
        int noffs = this.parseToHashMap(vnames);
        this._fields = new String[vnames.size()];
        this._values = new String[vnames.size()];
        this._entered = new boolean[vnames.size()];
        this._fieldOffset = new OffsetMark[vnames.size()];
        this._offsets = new int[noffs];
        noffs = 0;
        lim = fulltext.length();
        int fcnt = 0;
        int i = 0;
        while (i < lim) {
            char c = fulltext.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '$') break;
                    pstart = i;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c != '$') break;
                    String varname = fulltext.substring(pstart + 1, i);
                    if (varname.equals("")) {
                        fulltext.delete(pstart, i);
                        i = pstart;
                    } else if (varname.equalsIgnoreCase("end")) {
                        this._endOffset = pstart;
                        fulltext.delete(pstart, i + 1);
                        i = pstart - 1;
                    } else {
                        ArrayList<Integer> al = (ArrayList<Integer>)vnames.get(varname);
                        if (al == null) {
                            this._fields[fcnt++] = varname;
                            al = new ArrayList<Integer>();
                            vnames.put(varname, al);
                        }
                        this._offsets[noffs] = pstart;
                        al.add(new Integer(noffs++));
                        fulltext.delete(pstart, i + 1);
                        i = pstart - 1;
                    }
                    lim = fulltext.length();
                    state = 0;
                    break;
                }
            }
            ++i;
        }
        if (this._endOffset > fulltext.length()) {
            this._endOffset = fulltext.length();
        }
        this._before = fulltext.toString();
        this._fieldsPosition = new int[fcnt][];
        int i2 = 0;
        while (i2 < fcnt) {
            ArrayList al = (ArrayList)vnames.get(this._fields[i2]);
            this._fieldsPosition[i2] = new int[al.size()];
            int j = 0;
            while (j < al.size()) {
                Integer val = (Integer)al.get(j);
                this._fieldsPosition[i2][j] = val;
                ++j;
            }
            ++i2;
        }
    }

    public int[] getOriginalOffsets() {
        return this._offsets;
    }

    public int getFieldCount() {
        return this._fields.length;
    }

    public int[] getFieldPositions(int field) {
        return this._fieldsPosition[field];
    }

    public String getFieldName(int field) {
        return this._fields[field];
    }

    public void setValueAndOffset(int field, String value, OffsetMark offset, boolean setentered) {
        if (setentered) {
            this._entered[field] = true;
        }
        this._values[field] = value;
        this._fieldOffset[field] = offset;
    }

    public int getFieldIndex(String name) {
        int i = 0;
        while (i < this._fields.length) {
            if (name.equals(this._fields[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getCurrentValueByName(String name) {
        int index = this.getFieldIndex(name);
        if (index != -1) {
            return this._values[index];
        }
        return null;
    }

    public int getCurrentOffsetByName(String name) {
        int index = this.getFieldIndex(name);
        if (index != -1) {
            return this._fieldOffset[index].getOffset();
        }
        return -1;
    }

    public String guessFieldValue(CodeEditor ce, int field, int offset, String oldValue) {
        if (this._values[field] != null) {
            return this._values[field];
        }
        TemplateVariable var = this.getVariable(this._fields[field]);
        return var.guessValue(new TemplateContext(ce, this), offset, oldValue);
    }

    public HintChoice[] getFieldHints(CodeEditor ce, int field, int offset) {
        TemplateVariable var = this.getVariable(this._fields[field]);
        return var.getHints(new TemplateContext(ce, this), offset);
    }

    public String getFieldValue(CodeEditor ce, int field, int offset, boolean nonullvalue, String oldValue) {
        TemplateVariable var = this.getVariable(this._fields[field]);
        if (!this.canCalculateField(ce, field)) {
            return var.getDefValue();
        }
        String res = var.guessValue(new TemplateContext(ce, this), offset, oldValue);
        if (nonullvalue && res == null) {
            return var.getDefValue();
        }
        return res;
    }

    public boolean canEditField(int field) {
        TemplateVariable var = this.getVariable(this._fields[field]);
        return var.isEditable();
    }

    public boolean canCalculateField(CodeEditor ce, int field) {
        TemplateVariable var = this.getVariable(this._fields[field]);
        if (!var.isEditable()) {
            return true;
        }
        if (this._entered[field]) {
            return false;
        }
        return var.isCalculatedField(new TemplateContext(ce, this));
    }

    public Object copyTo(Object target) {
        Template copy = target != null ? (Template)target : new Template();
        this.copyToImpl(copy);
        return copy;
    }
}

