/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.ceditor.template.ConfigPanel;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.Templates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TemplateConfigModel
extends AbstractTableModel
implements Comparator {
    private Templates _templates;
    private ArrayList _orderedList;
    private ConfigPanel _srcPanel;
    private boolean _errorMessagesEnabled;

    private void $init$() {
        this._errorMessagesEnabled = true;
    }

    TemplateConfigModel(ConfigPanel srcPanel) {
        this.$init$();
        this._srcPanel = srcPanel;
    }

    public void setTemplates(Templates templates) {
        this._templates = templates;
        this.refreshModel();
    }

    void setErrorMessagesEnabled(boolean errorMessagesEnabled) {
        this._errorMessagesEnabled = errorMessagesEnabled;
    }

    private void refreshModel() {
        if (this._templates != null) {
            int n = this._templates.getTemplateCount();
            this._orderedList = new ArrayList(n);
            int i = 0;
            while (i < n) {
                this._orderedList.add(new Integer(i));
                ++i;
            }
            Collections.sort(this._orderedList, this);
        }
    }

    public int addEmptyTemplate() {
        int emptyTemplatePos = this._templates.searchTemplatePosEndingWith("");
        if (emptyTemplatePos == -1) {
            Template t = new Template();
            emptyTemplatePos = this._templates.addTemplate(t);
            this._orderedList.add(new Integer(emptyTemplatePos));
            this.fireTableRowsInserted(emptyTemplatePos, emptyTemplatePos);
        }
        return emptyTemplatePos;
    }

    public int compare(Object o1, Object o2) {
        Integer i1 = (Integer)o1;
        Integer i2 = (Integer)o2;
        Template t1 = this._templates.getTemplate(i1);
        Template t2 = this._templates.getTemplate(i2);
        String s1 = t1.getShortcut();
        String s2 = t2.getShortcut();
        return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this._templates == null ? 0 : this._templates.getTemplateCount();
    }

    Template getTemplate(int nRow) {
        Integer i = (Integer)this._orderedList.get(nRow);
        return this._templates.getTemplate(i);
    }

    @Override
    public Object getValueAt(int nRow, int nCol) {
        String ret;
        Template t = this.getTemplate(nRow);
        switch (nCol) {
            case 0: {
                ret = t.getShortcut();
                break;
            }
            case 1: {
                ret = t.getDescription();
                break;
            }
            default: {
                ret = null;
                break;
            }
        }
        return ret;
    }

    @Override
    public void setValueAt(Object aValue, int nRow, int nCol) {
        Template t = this.getTemplate(nRow);
        String s = aValue.toString();
        switch (nCol) {
            case 0: {
                boolean isDuplicate;
                t.setShortcut(s);
                if (this._errorMessagesEnabled && (isDuplicate = this._templates.isDuplicateShortcut(t))) {
                    this.showInvalidTemplateMessage(TemplateArb.getString(15));
                }
                if (!this._templates.updateValidities()) break;
                this._srcPanel.repaint();
                break;
            }
            case 1: {
                t.setDescription(s);
                break;
            }
        }
    }

    private void showInvalidTemplateMessage(String message) {
        JOptionPane.showMessageDialog(this._srcPanel, message, TemplateArb.getString(20), 2);
    }

    void isValid() {
        this._templates.updateValidities();
    }

    void removeTemplate(int nRow) {
        if (nRow != -1) {
            Integer pos = (Integer)this._orderedList.get(nRow);
            this._templates.removeTemplate(pos);
            this.refreshModel();
            this.fireTableRowsDeleted(nRow, nRow);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return TemplateArb.getString(3);
            }
            case 1: {
                return TemplateArb.getString(4);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onExit() throws TraversalException {
        int n = this._templates.getTemplateCount();
        int i = n - 1;
        while (i >= 0) {
            Template t1 = this._templates.getTemplate(i);
            String shortcut1 = t1.getShortcut();
            if (shortcut1 == null || shortcut1.length() == 0) {
                if (!t1.isEmpty()) throw new TraversalException(TemplateArb.getString(1), TemplateArb.getString(20));
                this._templates.removeTemplate(i);
            } else {
                int j = i - 1;
                while (j >= 0) {
                    Template t2 = this._templates.getTemplate(j);
                    String shortcut2 = t2.getShortcut();
                    if (shortcut1.equals(shortcut2)) {
                        throw new TraversalException(TemplateArb.getString(15), TemplateArb.getString(20));
                    }
                    --j;
                }
            }
            --i;
        }
    }
}

