/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Project;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.util.Formatting;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.SourceImportsDesc;
import oracle.jdeveloper.ceditor.template.Template;
import oracle.jdeveloper.ceditor.template.TemplateArb;
import oracle.jdeveloper.ceditor.template.TemplateHintCellRenderer;
import oracle.jdeveloper.ceditor.template.TemplateItem;
import oracle.jdeveloper.ceditor.template.TemplateListInsight;
import oracle.jdeveloper.ceditor.template.TemplateOptions;
import oracle.jdeveloper.ceditor.template.Templates;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

final class TemplateController
implements CodeMenuConstants,
Controller,
DynamicMenuListener {
    private static final String ACTION_NAME = "CodeTemplate.EXPAND";
    private static final int ACTION_ID = Ide.createCmdID((String)"CodeTemplate.EXPAND");
    private static IdeAction actionExpand;
    static TemplateListInsight _templateInsight;
    private static TemplateActionHookInvoker _actionHookInvoker;
    private static boolean isSimpleMacro;
    private static OffsetMark endMark;
    private static OffsetMark cursorMark;
    private static OffsetMark closingMark;
    private JComponent[] dynamicItems;
    private static final String HIGHLIGHT_STYLE_NAME = "template-variable";
    private static final HighlightStyle HIGHLIGHT_STYLE;

    TemplateController() {
    }

    void initialize() {
        actionExpand = IdeAction.get((int)ACTION_ID, null, (String)TemplateArb.getString(5), (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(TemplateArb.getMnemonic(10)), (ArrayResourceBundle)TemplateArb.getInstance(), (int)21, null, (boolean)true);
        actionExpand.addController((Controller)this);
        this.initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
    }

    private static void clearHook() {
        _actionHookInvoker = null;
    }

    private static String getIndent(String s) {
        int nLastWS = 0;
        while (nLastWS < s.length()) {
            char c = s.charAt(nLastWS);
            if (c != ' ' && c != '\t') break;
            ++nLastWS;
        }
        return s.substring(0, nLastWS);
    }

    private static Template adjustTemplate(BasicEditorPane editor, Template t, int nPos) throws BadLocationException {
        int nLineNo = editor.getLineFromOffset(nPos);
        int nLineStart = editor.getLineStartOffset(nLineNo);
        String sLine = editor.getText(nLineStart, nPos - nLineStart);
        String sIndent = TemplateController.getIndent(sLine);
        int indentSize = editor.getIntegerProperty("indent-size");
        Integer iTabStop = (Integer)editor.getProperty("tab-size");
        Boolean bUseTab = (Boolean)editor.getProperty("use-tabs");
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        boolean bBraceSameLine = styleOptions.getBlockBracePosition() == 0;
        Template res = t.adjust(sIndent, bBraceSameLine, indentSize, iTabStop, bUseTab);
        res.parseVariables();
        return res;
    }

    private static Template getTemplate(Context context, int start, int end) {
        Template t;
        block8: {
            BasicEditorPane editor = TemplateController.getEditor(context);
            t = null;
            try {
                Rectangle caretRect;
                String scrit;
                TemplateOptions to = (TemplateOptions)Ide.getSettings().getData("code-template-options");
                Templates ts = to.getTemplates();
                if (start == end) {
                    int nLen = Math.min(end, ts.getLongestShortcut());
                    String sText = editor.getText(end - nLen, nLen);
                    t = ts.findTemplateEndingWith(sText);
                    scrit = sText;
                } else {
                    String text = editor.getText(start, end - start);
                    t = ts.findTemplate(text);
                    scrit = text;
                }
                if (t != null) break block8;
                int po = scrit.length() - 1;
                while (po >= 0 && Character.isJavaIdentifierPart(scrit.charAt(po))) {
                    --po;
                }
                scrit = scrit.substring(po + 1);
                Template[] tarray = ts.getSortedTemplates();
                TemplateItem[] tdatas = new TemplateItem[tarray.length];
                int i = 0;
                while (i < tarray.length) {
                    tdatas[i] = new TemplateItem(tarray[i]);
                    ++i;
                }
                int caretOffset = editor.getCaretPosition();
                try {
                    caretRect = editor.getUI().modelToView((JTextComponent)editor, caretOffset);
                }
                catch (BadLocationException e) {
                    caretRect = null;
                }
                _templateInsight = new TemplateListInsight(context, tdatas, scrit, caretRect);
                editor.installPlugin((EditorPlugin)_templateInsight);
                _templateInsight.showInsight();
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return t;
    }

    private static void replaceFieldAtPos(BasicEditorPane editor, int fnum, String val, OffsetMark[] startpos, OffsetMark[] endpos) {
        int start = startpos[fnum].getOffset();
        int end = endpos[fnum].getOffset();
        editor.select(start, end);
        editor.replaceSelection(val);
        end = start + val.length();
        startpos[fnum].setOffset(start);
        endpos[fnum].setOffset(end);
        int i = fnum;
        while (--i >= 0) {
            if (startpos[i].getOffset() > start) {
                startpos[i].setOffset(start);
            }
            if (endpos[i].getOffset() <= start) continue;
            endpos[i].setOffset(start);
        }
        i = fnum;
        while (++i < endpos.length) {
            if (startpos[i].getOffset() < end) {
                startpos[i].setOffset(end);
            }
            if (endpos[i].getOffset() >= end) continue;
            endpos[i].setOffset(end);
        }
    }

    private static OffsetMark addOffsetMark(BasicEditorPane editor, int pos) {
        BasicDocument document = (BasicDocument)editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer.addOffsetMark(pos);
    }

    private static OffsetMark addStartOffsetMark(BasicEditorPane editor, int pos) {
        BasicDocument document = (BasicDocument)editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer.addOffsetMark(pos, false);
    }

    private static void removeOffsetMark(BasicEditorPane editor, OffsetMark mark) {
        BasicDocument document = (BasicDocument)editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        textBuffer.removeOffsetMark(mark);
    }

    static void replace(BasicEditorPane editor, CodeEditor ce, int nPos, Template t) throws BadLocationException {
        t = TemplateController.adjustTemplate(editor, t, nPos);
        int nReplaceStart = nPos - t.getShortcut().length();
        editor.select(nReplaceStart, nPos);
        TemplateController.launchEdit(editor, ce, t, nReplaceStart);
    }

    protected static void launchEdit(BasicEditorPane editor, CodeEditor ce, Template t, int nReplaceStart) {
        editor.replaceSelection(t.getText());
        int[] offs = t.getOriginalOffsets();
        endMark = TemplateController.addOffsetMark(editor, nReplaceStart + t.getCursorPos());
        cursorMark = TemplateController.addOffsetMark(editor, nReplaceStart + t.getInitialCursorPos());
        closingMark = TemplateController.addOffsetMark(editor, nReplaceStart + t.getText().length());
        if (offs.length > 0) {
            boolean notdone;
            OffsetMark[] startPos = new OffsetMark[offs.length];
            OffsetMark[] endPos = new OffsetMark[offs.length];
            int i = 0;
            while (i < offs.length) {
                startPos[i] = TemplateController.addStartOffsetMark(editor, nReplaceStart + offs[i]);
                endPos[i] = TemplateController.addOffsetMark(editor, nReplaceStart + offs[i]);
                ++i;
            }
            String[] oldValues = new String[t.getFieldCount()];
            int i2 = 0;
            while (i2 < t.getFieldCount()) {
                int[] positions = t.getFieldPositions(i2);
                oldValues[i2] = t.getFieldValue(ce, i2, startPos[positions[0]].getOffset(), true, null);
                int j = 0;
                while (j < positions.length) {
                    TemplateController.replaceFieldAtPos(editor, positions[j], oldValues[i2], startPos, endPos);
                    ++j;
                }
                ++i2;
            }
            do {
                notdone = false;
                int i3 = 0;
                while (i3 < t.getFieldCount()) {
                    int[] positions = t.getFieldPositions(i3);
                    String val = t.guessFieldValue(ce, i3, startPos[positions[0]].getOffset(), oldValues[i3]);
                    if (val != null) {
                        t.setValueAndOffset(i3, val, startPos[positions[0]], false);
                        int j = 0;
                        while (j < positions.length) {
                            TemplateController.replaceFieldAtPos(editor, positions[j], val, startPos, endPos);
                            ++j;
                        }
                    } else {
                        notdone = true;
                    }
                    ++i3;
                }
            } while (notdone);
            _actionHookInvoker = new TemplateActionHookInvoker(editor, ce, t, startPos, endPos, endMark);
            isSimpleMacro = false;
        } else {
            isSimpleMacro = true;
        }
        int selectionOffset = endMark.getOffset();
        editor.select(selectionOffset, selectionOffset);
        editor.replaceSelection(";");
        endMark.setOffset(endMark.getOffset() - 1);
        editor.unselect();
    }

    static void addImports(BasicEditorPane editor, Context context, Template t) {
        SourceImportsDesc sid = SourceImportsDesc.parse(context);
        if (sid != null) {
            int nPos;
            List templImps = t.getImports();
            StringBuffer sb = new StringBuffer();
            for (String sTemplateImport : templImps) {
                if (sid.hasImport(sTemplateImport)) continue;
                sb.append("\nimport ");
                sb.append(sTemplateImport);
                sb.append(';');
            }
            if (sb.length() != 0 && (nPos = sid.getEndImportPosition()) != -1) {
                int nCursorPos = editor.getSelectionStart();
                editor.select(nPos, nPos);
                String sAdd = sb.toString();
                editor.replaceSelection(sAdd);
                editor.select(nCursorPos += sAdd.length(), nCursorPos);
            }
        }
    }

    protected static BasicEditorPane getEditor(Context context) {
        View view;
        BasicEditorPane ret = null;
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            CodeEditor ce = (CodeEditor)view;
            ret = ce.getFocusedEditorPane();
        }
        return ret;
    }

    protected static CodeEditor getCodeEditor(Context context) {
        View view;
        CodeEditor ret = null;
        if (context != null && (view = context.getView()) instanceof CodeEditor) {
            ret = (CodeEditor)view;
        }
        return ret;
    }

    private void initializeDynamicActions() {
        Menubar ideMenuManager = Ide.getMenubar();
        JMenuItem templateItem = ideMenuManager.createMenuItem((ToggleAction)actionExpand, 130.0f);
        templateItem.putClientProperty("menu-section-id", new Float(1.0f));
        this.dynamicItems = new JComponent[]{templateItem};
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == ACTION_ID) {
            BasicEditorPane editor;
            if (_actionHookInvoker != null) {
                _actionHookInvoker.finished(false);
            } else if (_templateInsight == null && (editor = TemplateController.getEditor(context)) != null && editor.isEditable() && context.getProject() != null) {
                int start = editor.getSelectionStart();
                int end = editor.getSelectionEnd();
                TemplateController.replaceTemplateNameWithTemplateCode(editor, context, start, end);
            }
        } else {
            return false;
        }
        return true;
    }

    static void replaceTemplateNameWithTemplateCode(BasicEditorPane editor, Context context, int start, int end) {
        Template template = TemplateController.getTemplate(context, start, end);
        if (template != null) {
            try {
                try {
                    EditDescriptor editDescriptor = new EditDescriptor(TemplateArb.getString(16));
                    editor.beginEdit(editDescriptor);
                    CodeEditor codeEditor = TemplateController.getCodeEditor(context);
                    TemplateController.replace(editor, codeEditor, end, template);
                    TemplateController.addImports(editor, context, template);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            finally {
                editor.endEdit();
                editor.beginFormatEdit(new EditDescriptor("Undo Reformat"));
                UndoableEdit redit = TemplateController.reformatTemplate(editor, TemplateController.getCodeEditor(context), start - template.getShortcut().length(), closingMark.getOffset());
                editor.endFormatEdit(true, redit);
                editor.select(endMark.getOffset(), endMark.getOffset() + 1);
                editor.mergeReplaceSelection("");
                editor.unselect();
                if (!isSimpleMacro && _actionHookInvoker != null) {
                    BasicDocument document = (BasicDocument)editor.getDocument();
                    TextBuffer textBuffer = document.getTextBuffer();
                    textBuffer.addTextBufferListener((TextBufferListener)_actionHookInvoker);
                    editor.addFocusListener((FocusListener)_actionHookInvoker);
                    editor.addActionHookInvoker((ActionHookInvoker)_actionHookInvoker);
                    _actionHookInvoker.start();
                }
                editor.setCaretPosition(cursorMark.getOffset());
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static void insertCustomTemplate(Context context, Template t, String undoLabel) {
        BasicEditorPane editor = TemplateController.getEditor(context);
        if (editor != null && editor.isEditable()) {
            int end = editor.getSelectionEnd();
            if (t != null) {
                try {
                    try {
                        editor.beginEdit(new EditDescriptor(undoLabel));
                        TemplateController.replace(editor, TemplateController.getCodeEditor(context), end, t);
                        TemplateController.addImports(editor, context, t);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }

    public static void insertCustomTemplate(Context context, Template t) {
        TemplateController.insertCustomTemplate(context, t, TemplateArb.getString(16));
    }

    public boolean update(IdeAction action, Context context) {
        if (action == actionExpand) {
            this.updateActionExpand(context);
            return true;
        }
        return false;
    }

    private void updateActionExpand(Context context) {
        BasicEditorPane editor = TemplateController.getEditor(context);
        actionExpand.setEnabled(editor != null && editor.isEditable() && context.getProject() != null);
    }

    private static UndoableEdit reformatTemplate(BasicEditorPane editor, CodeEditor ce, int start, int end) {
        JavaManager manager = JavaManager.getJavaManager((Project)ce.getContext().getProject());
        SourceFile file = manager.getSourceFile(((BasicDocument)editor.getDocument()).getTextBuffer());
        return Formatting.reformatSelection((SourceFile)file, (int)start, (int)end);
    }

    static {
        endMark = null;
        cursorMark = null;
        closingMark = null;
        String name = TemplateArb.getString(7);
        HIGHLIGHT_STYLE = CodeEditor.createHighlightStyle((String)HIGHLIGHT_STYLE_NAME, (String)name, (int)75, null, (Color)Color.LIGHT_GRAY);
    }

    static void maS$replaceFieldAtPos(BasicEditorPane basicEditorPane, int n, String string, OffsetMark[] offsetMarkArray, OffsetMark[] offsetMarkArray2) {
        TemplateController.replaceFieldAtPos(basicEditorPane, n, string, offsetMarkArray, offsetMarkArray2);
    }

    static void maS$removeOffsetMark(BasicEditorPane basicEditorPane, OffsetMark offsetMark) {
        TemplateController.removeOffsetMark(basicEditorPane, offsetMark);
    }

    static void maS$clearHook() {
        TemplateController.clearHook();
    }

    static HighlightStyle ra$HIGHLIGHT_STYLE() {
        return HIGHLIGHT_STYLE;
    }

    static OffsetMark maS$addOffsetMark(BasicEditorPane basicEditorPane, int n) {
        return TemplateController.addOffsetMark(basicEditorPane, n);
    }

    private static class TemplateActionHookInvoker
    implements ActionHookInvoker,
    TextBufferListener,
    FocusListener {
        BasicEditorPane _editor;
        Template _t;
        OffsetMark[] _starts;
        OffsetMark[] _ends;
        int _curvar;
        HighlightLayer _highlights;
        OffsetMark _endMark;
        CodeEditor _ce;
        boolean _updating;
        TemplateAssistInsight _assistInsight;

        private void $init$() {
            this._curvar = 0;
        }

        public TemplateActionHookInvoker(BasicEditorPane editor, CodeEditor ce, Template t, OffsetMark[] starts, OffsetMark[] ends, OffsetMark endMark) {
            this.$init$();
            this._editor = editor;
            this._t = t;
            this._ce = ce;
            this._starts = starts;
            this._ends = ends;
            this._endMark = endMark;
            this._highlights = this._editor.createHighlightLayer();
            this._curvar = 0;
        }

        public boolean start() {
            while (this._curvar < this._t.getFieldCount() && !this._t.canEditField(this._curvar)) {
                ++this._curvar;
            }
            if (this._curvar < this._t.getFieldCount()) {
                this.highlightVar(this._curvar);
            } else {
                this.finished(true);
            }
            return true;
        }

        private void highlightVar(int v) {
            int[] positions = this._t.getFieldPositions(v);
            int i = 0;
            while (i < positions.length) {
                this._highlights.addHighlight(TemplateController.ra$HIGHLIGHT_STYLE(), this._starts[positions[i]].getOffset(), this._ends[positions[i]].getOffset());
                ++i;
            }
            this._editor.select(this._starts[positions[0]].getOffset(), this._ends[positions[0]].getOffset());
            this.showInsight(this._t.getFieldHints(this._ce, v, this._ends[positions[0]].getOffset()));
        }

        private boolean isUndoDetected() {
            int coffset = this._endMark.getOffset();
            int i = 0;
            while (i < this._starts.length) {
                if (this._starts[i].getOffset() != coffset) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected void finished(boolean gotoEnd) {
            int i = 0;
            while (i < this._starts.length) {
                TemplateController.maS$removeOffsetMark(this._editor, this._starts[i]);
                TemplateController.maS$removeOffsetMark(this._editor, this._ends[i]);
                ++i;
            }
            if (gotoEnd) {
                this._editor.select(this._endMark.getOffset(), this._endMark.getOffset());
            }
            TemplateController.maS$removeOffsetMark(this._editor, this._endMark);
            this._editor.removeActionHookInvoker((ActionHookInvoker)this);
            this._editor.removeFocusListener((FocusListener)this);
            BasicDocument document = (BasicDocument)this._editor.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            textBuffer.removeTextBufferListener((TextBufferListener)this);
            this._editor.destroyHighlightLayer(this._highlights);
            TemplateController.maS$clearHook();
        }

        private String getCurrentZone(int startpos, int endpos) {
            int[] positions = this._t.getFieldPositions(this._curvar);
            try {
                String sText;
                int start = this._starts[positions[0]].getOffset();
                int end = this._ends[positions[0]].getOffset();
                if (endpos < start || startpos > end) {
                    String string = null;
                    return string;
                }
                String string = sText = this._editor.getText(start, end - start);
                return string;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "";
            }
        }

        private void setCurrentField(String stext) {
            this._updating = true;
            int[] positions = this._t.getFieldPositions(this._curvar);
            try {
                this._editor.beginEdit(new EditDescriptor(TemplateArb.getString(16)));
                TemplateController.maS$replaceFieldAtPos(this._editor, positions[0], stext, this._starts, this._ends);
                this.updateRelatedFields();
                this._editor.endEdit(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this._updating = false;
        }

        private void updateRelatedFields() {
            this._updating = true;
            int[] positions = this._t.getFieldPositions(this._curvar);
            try {
                boolean notdone;
                int start = this._starts[positions[0]].getOffset();
                int end = this._ends[positions[0]].getOffset();
                String sText = this._editor.getText(start, end - start);
                this._t.setValueAndOffset(this._curvar, sText, this._starts[positions[0]], true);
                int i = 1;
                while (i < positions.length) {
                    TemplateController.maS$replaceFieldAtPos(this._editor, positions[i], sText, this._starts, this._ends);
                    ++i;
                }
                String[] oldValues = new String[this._t.getFieldCount()];
                int i2 = 0;
                while (i2 < this._t.getFieldCount()) {
                    if (this._t.canCalculateField(this._ce, i2)) {
                        oldValues[i2] = this._t.guessFieldValue(this._ce, i2, 0, null);
                        this._t.setValueAndOffset(i2, null, null, false);
                    }
                    ++i2;
                }
                do {
                    notdone = false;
                    int i3 = 0;
                    while (i3 < this._t.getFieldCount()) {
                        if (this._t.canCalculateField(this._ce, i3)) {
                            positions = this._t.getFieldPositions(i3);
                            sText = this._t.getFieldValue(this._ce, i3, this._starts[positions[0]].getOffset(), false, oldValues[i3]);
                            if (sText != null) {
                                int j = 0;
                                while (j < positions.length) {
                                    TemplateController.maS$replaceFieldAtPos(this._editor, positions[j], sText, this._starts, this._ends);
                                    ++j;
                                }
                                this._t.setValueAndOffset(i3, sText, this._starts[positions[0]], false);
                            } else {
                                notdone = true;
                            }
                        }
                        ++i3;
                    }
                } while (notdone);
                this.highlightVar(this._curvar);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this._updating = false;
        }

        private synchronized void dynamicUpdate() {
            this._updating = true;
            if (this.isUndoDetected()) {
                this.finished(true);
            } else {
                SwingUtilities.invokeLater(new 1());
            }
        }

        private void showInsight(HintChoice[] choices) {
            HintChoice[] locchoices = choices;
            if (choices.length > 1) {
                Rectangle caretRect;
                int caretOffset = this._ce.getCaretPosition();
                try {
                    caretRect = this._editor.getUI().modelToView((JTextComponent)this._editor, caretOffset);
                }
                catch (BadLocationException e) {
                    caretRect = null;
                }
                if (this._assistInsight == null) {
                    this._assistInsight = new TemplateAssistInsight(locchoices, caretRect);
                    this._editor.installPlugin((EditorPlugin)this._assistInsight);
                    this._assistInsight.showInsight();
                }
            }
        }

        void clearInsight() {
            if (this._assistInsight != null) {
                this._editor.deinstallPlugin((EditorPlugin)this._assistInsight);
            }
            this._assistInsight = null;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.finished(false);
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            if (this._updating) {
                return;
            }
            String smod = this.getCurrentZone(offset, offset + count);
            if (smod != null) {
                this.dynamicUpdate();
            } else {
                this.finished(false);
            }
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            if (this.isUndoDetected()) {
                this.finished(true);
                return;
            }
            if (this._updating) {
                return;
            }
            String smod = this.getCurrentZone(offset, offset);
            if (smod != null) {
                this.dynamicUpdate();
            } else {
                this.finished(false);
            }
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private void nextField() {
            this._highlights.removeAllHighlights();
            this.clearInsight();
            ++this._curvar;
            while (this._curvar < this._t.getFieldCount() && !this._t.canEditField(this._curvar)) {
                ++this._curvar;
            }
            if (this._curvar < this._t.getFieldCount()) {
                this.highlightVar(this._curvar);
            } else {
                this.finished(true);
            }
        }

        private void prevField() {
            int nextpos = this._curvar;
            --nextpos;
            while (nextpos >= 0 && !this._t.canEditField(nextpos)) {
                --nextpos;
            }
            if (nextpos >= 0) {
                this._highlights.removeAllHighlights();
                this.clearInsight();
                this._curvar = nextpos;
                this.highlightVar(this._curvar);
            }
        }

        public synchronized boolean invokeAction(String actionKey) {
            if (actionKey.equals("cancel")) {
                if (this._assistInsight != null) {
                    return false;
                }
                this._highlights.removeAllHighlights();
                this.finished(true);
                return true;
            }
            if (actionKey.equals("insert-tab")) {
                this.nextField();
                return true;
            }
            if (actionKey.equals("insert-break")) {
                if (this._assistInsight != null) {
                    return false;
                }
                int cpos = this._editor.getCaretPosition();
                if (this.getCurrentZone(cpos, cpos) != null) {
                    this.nextField();
                    return true;
                }
            } else if (actionKey.equals("reverse-tab")) {
                this.prevField();
                return true;
            }
            return false;
        }

        static void mav$setCurrentField(TemplateActionHookInvoker templateActionHookInvoker, String string) {
            templateActionHookInvoker.setCurrentField(string);
        }

        static void mav$nextField(TemplateActionHookInvoker templateActionHookInvoker) {
            templateActionHookInvoker.nextField();
        }

        static boolean mav$isUndoDetected(TemplateActionHookInvoker templateActionHookInvoker) {
            return templateActionHookInvoker.isUndoDetected();
        }

        static void mav$updateRelatedFields(TemplateActionHookInvoker templateActionHookInvoker) {
            templateActionHookInvoker.updateRelatedFields();
        }

        class TemplateAssistData
        implements ListInsightData {
            private ListDataItem[] asData;
            private ReadOnlyListModel asModel;

            public TemplateAssistData(HintChoice[] choices) {
                this.asData = choices;
            }

            public ListModel getListModel() {
                if (this.asModel == null) {
                    this.asModel = new ReadOnlyListModel((Object[])this.asData);
                }
                return this.asModel;
            }

            public Object[] getData() {
                return this.asData;
            }

            public Object[] getMatchingData() {
                return this.asData;
            }

            public int getMatchingDataCount() {
                return this.asData.length;
            }

            public Object getDefault() {
                return this.asData[0];
            }

            public boolean complete(Object selectedObject) {
                HintChoice choice = (HintChoice)((Object)selectedObject);
                TemplateActionHookInvoker.mav$setCurrentField(TemplateActionHookInvoker.this, choice.getName());
                return false;
            }

            public void partialComplete() {
            }
        }

        class TemplateAssistInsight
        extends AbstractInsight
        implements InsightProvider {
            private InsightData asData;
            private Rectangle asRect;

            TemplateAssistInsight(HintChoice[] importChoices, Rectangle importRect) {
                this.asData = new TemplateAssistData(importChoices);
                this.asRect = importRect;
            }

            protected InsightProvider createInsightProvider() {
                return this;
            }

            public boolean isInsightTriggerChar(char typedChar) {
                return false;
            }

            public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
            }

            public Rectangle getShowRectangle() {
                return this.asRect;
            }

            protected void updateInsight() {
            }

            public void hideInsight() {
                super.hideInsight();
                TemplateActionHookInvoker.this.clearInsight();
            }

            protected int[] getPreferredLocations() {
                return AbstractInsight.COMPLETION_LOCATIONS;
            }

            public InsightData getInsightData(BasicEditorPane editorPane) {
                return this.asData;
            }

            public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
                return lastData;
            }

            public InsightView getInsightView() {
                return new ListInsightView((ListCellRenderer)new TemplateHintCellRenderer());
            }

            public boolean invokeAction(String actionKey) {
                if (actionKey.equals("insert-tab")) {
                    TemplateActionHookInvoker.mav$nextField(TemplateActionHookInvoker.this);
                    return true;
                }
                boolean res = super.invokeAction(actionKey);
                if (actionKey.equals("cancel")) {
                    return true;
                }
                if (actionKey.equals("insert-break")) {
                    TemplateActionHookInvoker.mav$nextField(TemplateActionHookInvoker.this);
                }
                return res;
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                try {
                    if (!TemplateActionHookInvoker.mav$isUndoDetected(TemplateActionHookInvoker.this)) {
                        TemplateActionHookInvoker.this._editor.beginEdit(new EditDescriptor(TemplateArb.getString(16)));
                        int offset = TemplateActionHookInvoker.this._editor.getCaretPosition();
                        OffsetMark curmark = TemplateController.maS$addOffsetMark(TemplateActionHookInvoker.this._editor, offset);
                        TemplateActionHookInvoker.mav$updateRelatedFields(TemplateActionHookInvoker.this);
                        offset = curmark.getOffset();
                        TemplateActionHookInvoker.this._editor.select(offset, offset);
                        TemplateActionHookInvoker.this._editor.endEdit(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

