/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.ceditor.template.HintChoice;

public class TemplateHintCellRenderer
extends JComponent
implements ListCellRenderer,
PrototypeCellProvider {
    private boolean boldDeclaredMembersOption;
    private boolean italicLocalVariablesOption;
    private boolean strikethruDeprecatedOption;
    private boolean showDefiningClassOption;
    private static final int HORIZONTAL_PADDING = 6;
    private static final int VERTICAL_PADDING = 2;
    private static final int INSIDE_PADDING = 8;
    private int cellTypeWidth;
    private int cellNameWidth;
    private int cellIconWidth;
    private int cellHeight;
    private Dimension cellSize;
    private HintChoice currentItem;

    public TemplateHintCellRenderer() {
        this.$init$();
        this.setOpaque(false);
        this.updateCellSize(0, 0, 0, 0);
    }

    protected void setBoldDeclaredMembers(boolean boldDeclaredMembers) {
        this.boldDeclaredMembersOption = boldDeclaredMembers;
    }

    protected void setItalicLocalVariables(boolean italicLocalVariables) {
        this.italicLocalVariablesOption = italicLocalVariables;
    }

    protected void setStrikethruDeprecated(boolean strikethruDeprecated) {
        this.strikethruDeprecatedOption = strikethruDeprecated;
    }

    protected void setShowDefiningClass(boolean showDefiningClass) {
        this.showDefiningClassOption = showDefiningClass;
    }

    private void $init$() {
        this.boldDeclaredMembersOption = false;
        this.italicLocalVariablesOption = false;
        this.strikethruDeprecatedOption = false;
        this.showDefiningClassOption = false;
        this.cellTypeWidth = 0;
        this.cellNameWidth = 0;
        this.cellIconWidth = 0;
        this.cellHeight = 0;
        this.cellSize = new Dimension();
        this.currentItem = null;
    }

    private void updateCellSize(int nameWidth, int typeWidth, int iconWidth, int height) {
        this.cellTypeWidth = Math.max(typeWidth, 0);
        this.cellNameWidth = Math.max(nameWidth, 80);
        this.cellIconWidth = iconWidth;
        this.cellHeight = height;
        this.cellSize.width = 6 + this.cellIconWidth + 8 + this.cellTypeWidth + 8 + this.cellNameWidth + 6;
        this.cellSize.height = 2 + this.cellHeight + 2;
        EditorProperties properties = EditorProperties.getProperties();
        int widthCap = properties.getIntegerProperty("insight-max-popup-width");
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (this.cellSize.width > (widthCap = Math.min(screenSize.width / 2 - 20, widthCap))) {
            this.cellSize.width = widthCap;
            int spaceRemaining = widthCap - 12 - this.cellIconWidth - 16;
            this.cellTypeWidth = Math.min(spaceRemaining * this.cellTypeWidth / (this.cellTypeWidth + this.cellNameWidth), this.cellTypeWidth);
            this.cellNameWidth = spaceRemaining - this.cellTypeWidth;
        }
        this.setMinimumSize(this.cellSize);
        this.setPreferredSize(this.cellSize);
        this.setMaximumSize(this.cellSize);
    }

    public void paint(Graphics graphics) {
        Font plainFont;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.cellSize.width, this.cellSize.height);
        if (this.currentItem != null && (plainFont = this.getFont()) != null) {
            Font fontToUse;
            FontMetrics plainMetrics = this.getFontMetrics(plainFont);
            int plainAscent = plainMetrics.getAscent();
            int plainHeight = plainMetrics.getHeight();
            Font boldFont = this.boldDeclaredMembersOption ? plainFont.deriveFont(1) : plainFont;
            FontMetrics boldMetrics = this.getFontMetrics(boldFont);
            Font italicFont = this.italicLocalVariablesOption ? plainFont.deriveFont(2) : plainFont;
            FontMetrics italicMetrics = this.getFontMetrics(italicFont);
            boolean isField = this.currentItem.isField();
            boolean isLocal = this.currentItem.isLocal();
            boolean isClass = this.currentItem.isClass();
            Font font = isLocal ? boldFont : (fontToUse = isField ? italicFont : plainFont);
            FontMetrics metricsToUse = isLocal ? boldMetrics : (isField ? italicMetrics : plainMetrics);
            Icon icon = this.currentItem.getIcon();
            if (icon != null) {
                int iconXPos = 6;
                int iconYPos = 2;
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                int yAdjust = (this.cellHeight - iconHeight) / 2;
                icon.paintIcon(this, graphics, 6, 2 + yAdjust);
            }
            graphics.setColor(this.getForeground());
            graphics.setFont(fontToUse);
            int textYAdjust = (this.cellHeight - plainHeight) / 2;
            int textYPos = 2 + plainAscent + textYAdjust;
            String itemName = this.currentItem.getName();
            int nameWidth = metricsToUse.stringWidth(itemName);
            if (nameWidth > this.cellNameWidth) {
                itemName = this.truncateString(itemName, nameWidth, this.cellNameWidth, metricsToUse);
                nameWidth = metricsToUse.stringWidth(itemName);
            }
            int nameXPos = 6 + this.cellIconWidth + 8;
            SwingUtils.drawString((Graphics)graphics, (String)itemName, (int)nameXPos, (int)textYPos);
            if (!isClass) {
                String itemType = this.currentItem.getDescription();
                int typeWidth = metricsToUse.stringWidth(itemType);
                if (typeWidth > this.cellTypeWidth) {
                    itemType = this.truncateString(itemType, typeWidth, this.cellTypeWidth, metricsToUse);
                    typeWidth = metricsToUse.stringWidth(itemType);
                }
                int typeXPos = this.cellSize.width - 6 - typeWidth;
                SwingUtils.drawString((Graphics)graphics, (String)itemType, (int)typeXPos, (int)textYPos);
            }
        }
    }

    protected String truncateString(String displayText, int width, int maxWidth, FontMetrics metrics) {
        if (width < maxWidth) {
            return displayText;
        }
        String ellipsis = "...";
        int allowedWidth = maxWidth - metrics.stringWidth("...");
        int currentWidth = width;
        int lastIndex = displayText.length() - 1;
        while (currentWidth > allowedWidth && lastIndex > 0) {
            char c = displayText.charAt(lastIndex--);
            int charWidth = metrics.charWidth(c);
            currentWidth -= charWidth;
        }
        String truncatedText = displayText.substring(0, lastIndex + 1) + "...";
        return truncatedText;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value instanceof HintChoice) {
            this.currentItem = (HintChoice)((Object)value);
        }
        return this;
    }

    public Object getPrototypeCell(JList list, ListModel listModel) {
        Font plainFont = list.getFont();
        FontMetrics plainMetrics = this.getFontMetrics(plainFont);
        Font boldFont = this.boldDeclaredMembersOption ? plainFont.deriveFont(1) : plainFont;
        FontMetrics boldMetrics = this.getFontMetrics(boldFont);
        Font italicFont = this.italicLocalVariablesOption ? plainFont.deriveFont(2) : plainFont;
        FontMetrics italicMetrics = this.getFontMetrics(italicFont);
        int maxTypeWidth = 0;
        int maxNameWidth = 0;
        int maxIconWidth = 0;
        String extraDefining = this.showDefiningClassOption ? " - " : null;
        int maxHeight = plainMetrics.getHeight();
        int numElements = listModel.getSize();
        int i = 0;
        while (i < numElements) {
            Font fontToUse;
            HintChoice item = (HintChoice)((Object)listModel.getElementAt(i));
            Icon icon = item.getIcon();
            boolean isField = item.isField();
            boolean isLocal = item.isLocal();
            boolean isClass = item.isClass();
            Font font = isLocal ? boldFont : (fontToUse = isField ? italicFont : plainFont);
            FontMetrics metricsToUse = isLocal ? boldMetrics : (isField ? italicMetrics : plainMetrics);
            int extraTypeWidth = 0;
            String itemType = item.getName();
            int nameWidth = metricsToUse.stringWidth(itemType) + extraTypeWidth;
            maxNameWidth = Math.max(maxNameWidth, nameWidth);
            if (!isClass) {
                String itemName = item.getDescription();
                int typeWidth = metricsToUse.stringWidth(itemName);
                maxTypeWidth = Math.max(maxTypeWidth, typeWidth);
            }
            if (icon != null) {
                int iconWidth = icon.getIconWidth();
                maxIconWidth = Math.max(maxIconWidth, iconWidth);
                int iconHeight = icon.getIconHeight();
                maxHeight = Math.max(maxHeight, iconHeight);
            }
            ++i;
        }
        this.updateCellSize(maxNameWidth, maxTypeWidth, maxIconWidth, maxHeight);
        return new int[0];
    }
}

