/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.ceditor.template;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.jdeveloper.ceditor.template.HintChoice;
import oracle.jdeveloper.ceditor.template.TemplateContext;
import oracle.jdeveloper.java.JavaManager;

public class TemplateJotUtils {
    private static final int WANT_LOCALS = 1;
    private static final int WANT_ARGUMENTS = 2;
    private static final int WANT_FIELDS = 4;
    private static final int WANT_ALL = 7;

    private static SourceFile getSourceFile(Context context) {
        SourceFile ret = null;
        Project project = context.getProject();
        if (project instanceof Project) {
            Project jProject = project;
            JavaManager javaManager = JavaManager.getJavaManager((Project)jProject);
            URL url = context.getNode().getURL();
            ret = javaManager.getSourceFile(url);
        }
        return ret;
    }

    private static JavaType getJavaType(String cname, Context context) {
        JavaClass ret = null;
        if (cname == null) {
            return null;
        }
        Project project = context.getProject();
        if (project instanceof Project) {
            Project jProject = project;
            JavaManager javaManager = JavaManager.getJavaManager((Project)jProject);
            int index = cname.lastIndexOf(36);
            if (index != -1) {
                return null;
            }
            ret = javaManager.getClass(cname);
        }
        return ret;
    }

    private static SourceElement getDeepestElement(SourceElement je, int offset) {
        SourceElement[] childs = je.getContainedElements();
        int i = 0;
        while (i < childs.length) {
            if (offset >= childs[i].getStartOffset() && offset < childs[i].getEndOffset()) {
                return TemplateJotUtils.getDeepestElement(childs[i], offset);
            }
            ++i;
        }
        return je;
    }

    private static SourceElement getCurrentJotElement(CodeEditor ce, int offset) {
        SourceFile jotFile;
        Context editorContext = ce.getContext();
        SourceFile el = jotFile = TemplateJotUtils.getSourceFile(editorContext);
        return TemplateJotUtils.getDeepestElement((SourceElement)el, offset);
    }

    private static SourceMethod getCurrentJotMethod(CodeEditor ce, int offset) {
        SourceElement curel = TemplateJotUtils.getCurrentJotElement(ce, offset);
        while (curel != null && curel.getSymbolKind() != 19 && curel.getSymbolKind() != 6) {
            curel = curel.getParent();
        }
        return (SourceMethod)curel;
    }

    private static SourceClass getCurrentJotClass(CodeEditor ce, int offset) {
        SourceElement curel = TemplateJotUtils.getCurrentJotElement(ce, offset);
        while (curel != null && curel.getSymbolKind() != 3) {
            curel = curel.getParent();
        }
        return (SourceClass)curel;
    }

    public static String getCurrentMethodName(TemplateContext ctx, int offset) {
        SourceMethod meth = TemplateJotUtils.getCurrentJotMethod(ctx.getCodeEditor(), offset);
        if (meth != null) {
            return meth.getName();
        }
        return "<ERROR>";
    }

    public static String getCurrentClassName(TemplateContext ctx, int offset) {
        JavaClass jc;
        SourceClass cls = TemplateJotUtils.getCurrentJotClass(ctx.getCodeEditor(), offset);
        if (cls != null) {
            return cls.getName();
        }
        SourceFile jotFile = TemplateJotUtils.getSourceFile(ctx.getCodeEditor().getContext());
        if (jotFile != null && (jc = jotFile.getPrimaryClass()) != null) {
            return jc.getName();
        }
        return "<ERROR>";
    }

    public static String getCurrentPackageName(TemplateContext ctx, int offset) {
        SourceFile jotFile = TemplateJotUtils.getSourceFile(ctx.getCodeEditor().getContext());
        if (jotFile != null) {
            return jotFile.getPackageName();
        }
        return "<ERROR>";
    }

    private static ArrayList getCurrentMethodJotParameters(CodeEditor ce, int offset, JavaType ofclass) {
        ArrayList<VarIdentifier> al = new ArrayList<VarIdentifier>();
        SourceMethod meth = TemplateJotUtils.getCurrentJotMethod(ce, offset);
        if (meth != null) {
            Iterator it = meth.getParameters().iterator();
            while (it.hasNext()) {
                VarIdentifier id = new VarIdentifier((JavaVariable)it.next());
                if (!id.isOfType(ofclass)) continue;
                al.add(id);
            }
        }
        return al;
    }

    public static ArrayList getCurrentMethodJotParameters(CodeEditor ce, int offset) {
        return TemplateJotUtils.getCurrentMethodJotParameters(ce, offset, null);
    }

    public static String[] getCurrentMethodArguments(TemplateContext ctx, int offset) {
        ArrayList al = TemplateJotUtils.getCurrentMethodJotParameters(ctx.getCodeEditor(), offset);
        String[] res = new String[al.size()];
        int i = 0;
        while (i < res.length) {
            Identifier id = (Identifier)al.get(i);
            res[i] = id.getName();
            ++i;
        }
        return res;
    }

    private static ArrayList getCurrentMethodJotFields(CodeEditor ce, int offset, JavaType ofclass) {
        ArrayList<VarIdentifier> al = new ArrayList<VarIdentifier>();
        boolean isStatic = false;
        SourceElement curel = TemplateJotUtils.getCurrentJotElement(ce, offset);
        int ctype = curel.getSymbolKind();
        while (curel != null && ctype != 11) {
            SourceElement tocheck = curel;
            Iterator fields = null;
            switch (ctype) {
                case 19: {
                    SourceMethod meth = (SourceMethod)tocheck;
                    if ((meth.getModifiers() & 8) == 0) break;
                    isStatic = true;
                    break;
                }
                case 3: {
                    SourceClass sc = (SourceClass)tocheck;
                    fields = sc.getDeclaredFields().iterator();
                    break;
                }
            }
            if (fields != null) {
                while (fields.hasNext()) {
                    VarIdentifier id;
                    JavaVariable var = (JavaVariable)fields.next();
                    if (isStatic && (var.getModifiers() & 8) == 0 || !(id = new VarIdentifier(var)).isOfType(ofclass)) continue;
                    al.add(id);
                }
            }
            curel = curel.getParent();
            ctype = curel.getSymbolKind();
        }
        return al;
    }

    private static ArrayList getCurrentMethodJotFields(CodeEditor ce, int offset) {
        return TemplateJotUtils.getCurrentMethodJotFields(ce, offset, null);
    }

    private static String typeFromSpecID(ArrayList ids, String specID) {
        int cindex = ids.size() - 1;
        while (cindex >= 0) {
            String curone = (String)ids.get(cindex);
            if (curone.startsWith(specID)) {
                return curone.substring(specID.length() + 1);
            }
            --cindex;
        }
        return null;
    }

    private static boolean isPrimitiveType(String s) {
        return s.equals("int") || s.equals("char") || s.equals("byte") || s.equals("short") || s.equals("long") || s.equals("float") || s.equals("double");
    }

    private static void addAssigns(HashSet aset, SourceElement elem, SourceElement decl, String[] mnames, int[] argofs) {
        if (elem != null) {
            int ctype = elem.getSymbolKind();
            switch (ctype) {
                case 53: {
                    JavaMethod resolvedMethod;
                    SourceElement declaration;
                    SourceMethodCallExpression se = (SourceMethodCallExpression)elem;
                    SourceExpression e = se.getLhsOperand();
                    if (e == null || decl != (declaration = e.getCompiledObject().getSourceElement()) || (resolvedMethod = se.getResolvedMethod()) == null) break;
                    String mname = resolvedMethod.getName();
                    int i = 0;
                    while (i < mnames.length) {
                        SourceExpression params;
                        int ocount;
                        if (mnames[i].equals(mname) && (ocount = (params = se.getSecondOperand()).getOperandCount()) >= argofs[i]) {
                            SourceExpression exp = params.getOperandAt(ocount - argofs[i]);
                            JavaType atype = exp.getResolvedType();
                            String tpe = atype.getQualifiedName();
                            aset.add(tpe);
                        }
                        ++i;
                    }
                    break;
                }
            }
            Iterator it = elem.getChildren().iterator();
            while (it.hasNext()) {
                TemplateJotUtils.addAssigns(aset, (SourceElement)it.next(), decl, mnames, argofs);
            }
        }
    }

    public static SourceVariable getSourceVariable(CodeEditor ce, int offset) {
        SourceElement baseElement = TemplateJotUtils.getCurrentJotElement(ce, offset);
        SourceElement declaration = null;
        while (baseElement != null && declaration == null) {
            int ctype = baseElement.getSymbolKind();
            switch (ctype) {
                case 53: {
                    JavaElement jel;
                    SourceMethodCallExpression se = (SourceMethodCallExpression)baseElement;
                    SourceExpression soex = se.getLhsOperand();
                    if (soex == null || (jel = soex.getCompiledObject()) == null) break;
                    declaration = jel.getSourceElement();
                    break;
                }
            }
            baseElement = baseElement.getParent();
        }
        return (SourceVariable)declaration;
    }

    public static ArrayList getCurrentAssigns(CodeEditor ce, int offset, String vname, String[] mnames, int[] argofs) {
        HashSet aset = new HashSet();
        boolean firstClass = true;
        SourceElement baseElement = TemplateJotUtils.getCurrentJotElement(ce, offset);
        SourceElement declaration = null;
        while (baseElement != null && declaration == null) {
            int ctype = baseElement.getSymbolKind();
            switch (ctype) {
                case 53: {
                    JavaElement jel;
                    SourceMethodCallExpression se = (SourceMethodCallExpression)baseElement;
                    SourceExpression soex = se.getLhsOperand();
                    if (soex == null || (jel = soex.getCompiledObject()) == null) break;
                    declaration = jel.getSourceElement();
                    break;
                }
            }
            baseElement = baseElement.getParent();
        }
        SourceElement block = null;
        SourceElement curel = declaration;
        while (curel != null && block == null) {
            int ctype = curel.getSymbolKind();
            switch (ctype) {
                case 2: 
                case 4: {
                    block = curel;
                }
            }
            curel = curel.getParent();
        }
        TemplateJotUtils.addAssigns(aset, block, declaration, mnames, argofs);
        return new ArrayList(aset);
    }

    private static ArrayList getCurrentMethodJotLocalVariables(CodeEditor ce, int offset, JavaType ofclass) {
        ArrayList<VarIdentifier> al = new ArrayList<VarIdentifier>();
        SourceElement curel = TemplateJotUtils.getCurrentJotElement(ce, offset);
        int cType = curel.getSymbolKind();
        while (curel != null && cType != 3) {
            SourceElement tocheck = curel;
            Iterator it = null;
            switch (cType) {
                case 2: {
                    SourceBlock blk = (SourceBlock)curel;
                    Collection lvar = blk.getLocalVariables();
                    it = lvar.iterator();
                    break;
                }
                case 38: {
                    SourceForStatement blk = (SourceForStatement)curel;
                    if (blk.getForType() != 1) break;
                    it = blk.getForVariables().iterator();
                    break;
                }
            }
            if (it != null) {
                while (it.hasNext()) {
                    VarIdentifier id;
                    SourceLocalVariable sv = (SourceLocalVariable)it.next();
                    if (sv.getStartOffset() >= offset || !(id = new VarIdentifier((JavaVariable)sv)).isOfType(ofclass) && !Identifier.mav$isOfGenericType(id, ofclass, ce.getContext())) continue;
                    al.add(id);
                }
            }
            if ((curel = curel.getParent()) == null) continue;
            cType = curel.getSymbolKind();
        }
        return al;
    }

    private static void recAddInterfaces(ArrayList al, JavaType inter, String aDim) {
        for (JavaType tp : inter.getInterfaces()) {
            String cname = tp.getName();
            if (al.contains(cname)) continue;
            al.add(cname + aDim);
        }
        for (JavaType tp : inter.getInterfaces()) {
            String cname = tp.getName();
            if (al.contains(cname)) continue;
            TemplateJotUtils.recAddInterfaces(al, tp, aDim);
        }
    }

    public static ArrayList getJotClassesFromClass(String cname, CodeEditor ce, int offset) {
        ArrayList<String> al = new ArrayList<String>();
        String aDim = "";
        int iArr = cname.indexOf(91);
        if (iArr != -1) {
            aDim = cname.substring(iArr);
            cname = cname.substring(0, iArr);
        }
        JavaType jc = TemplateJotUtils.getJavaType(cname, ce.getContext());
        while (jc != null) {
            JavaType sup;
            String curName = jc.getName();
            if (!al.contains(curName)) {
                al.add(curName + aDim);
            }
            if ((sup = jc.getSuperclass()) != null && !al.contains(curName = sup.getName())) {
                al.add(curName + aDim);
            }
            curName = jc.getName();
            TemplateJotUtils.recAddInterfaces(al, jc, aDim);
            jc = jc.getSuperclass();
        }
        return al;
    }

    private static ArrayList combineClassesList(ArrayList al1, ArrayList al2) {
        if (al1 == null) {
            return al2;
        }
        if (al2 == null) {
            return al1;
        }
        if (al1.size() > al2.size()) {
            return TemplateJotUtils.combineClassesList(al2, al1);
        }
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < al1.size()) {
            if (al2.contains(al1.get(i))) {
                res.add(al1.get(i));
            }
            ++i;
        }
        return res;
    }

    public static ArrayList getCurrentMethodJotLocalVariables(CodeEditor ce, int offset) {
        return TemplateJotUtils.getCurrentMethodJotLocalVariables(ce, offset, null);
    }

    private static ArrayList getCurrentJotIdentifierOfType(CodeEditor ce, int offset, int flags, JavaType ofclass) {
        ArrayList toadd;
        ArrayList res = new ArrayList();
        if ((flags & 1) != 0) {
            toadd = TemplateJotUtils.getCurrentMethodJotLocalVariables(ce, offset, ofclass);
            res.addAll(toadd);
        }
        if ((flags & 2) != 0) {
            toadd = TemplateJotUtils.getCurrentMethodJotParameters(ce, offset, ofclass);
            res.addAll(toadd);
        }
        if ((flags & 4) != 0) {
            toadd = TemplateJotUtils.getCurrentMethodJotFields(ce, offset, ofclass);
            res.addAll(toadd);
        }
        return res;
    }

    public static String[] getCurrentMethodLocals(TemplateContext ctx, int offset) {
        ArrayList jv = TemplateJotUtils.getCurrentMethodJotLocalVariables(ctx.getCodeEditor(), offset);
        String[] res = new String[jv.size()];
        int i = 0;
        while (i < res.length) {
            Identifier id = (Identifier)jv.get(i);
            res[i] = id.getName();
            ++i;
        }
        return res;
    }

    public static String shortClassName(String s) {
        s = s.substring(s.lastIndexOf(46) + 1);
        s = s.substring(s.lastIndexOf(36) + 1);
        return s;
    }

    public static HintChoice[] getCurrentHintsArraysIdentifiersOfType(TemplateContext ctx, int offset, String cname) {
        CodeEditor ce = ctx.getCodeEditor();
        JavaType type = TemplateJotUtils.getJavaType(cname, ce.getContext());
        ArrayList<HintChoice> res = new ArrayList<HintChoice>();
        ArrayList al = TemplateJotUtils.getCurrentMethodJotLocalVariables(ce, offset, type);
        int i = 0;
        while (i < al.size()) {
            Identifier id = (Identifier)al.get(i);
            if (id.isArray()) {
                res.add(new HintChoice(id.getName(), TemplateJotUtils.shortClassName(id.getType().getName()), 1));
            }
            ++i;
        }
        al = TemplateJotUtils.getCurrentMethodJotParameters(ce, offset, type);
        int i2 = 0;
        while (i2 < al.size()) {
            Identifier id = (Identifier)al.get(i2);
            if (id.isArray()) {
                res.add(new HintChoice(id.getName(), TemplateJotUtils.shortClassName(id.getType().getName()), 2));
            }
            ++i2;
        }
        al = TemplateJotUtils.getCurrentMethodJotFields(ce, offset, type);
        int i3 = 0;
        while (i3 < al.size()) {
            Identifier id = (Identifier)al.get(i3);
            if (id.isArray()) {
                res.add(new HintChoice(id.getName(), TemplateJotUtils.shortClassName(id.getType().getName()), 0));
            }
            ++i3;
        }
        HintChoice[] result = new HintChoice[res.size()];
        result = res.toArray(result);
        return result;
    }

    public static String[] getCurrentIdentifiersOfType(TemplateContext ctx, int offset, String type) {
        CodeEditor ce = ctx.getCodeEditor();
        JavaType jt = TemplateJotUtils.getJavaType(type, ce.getContext());
        ArrayList al = TemplateJotUtils.getCurrentJotIdentifierOfType(ce, offset, 7, jt);
        String[] res = new String[al.size()];
        int cur = 0;
        int i = 0;
        while (i < res.length) {
            Identifier id = (Identifier)al.get(i);
            res[cur++] = id.getName();
            ++i;
        }
        return res;
    }

    public static HintChoice[] getCurrentHintsIdentifiersOfType(TemplateContext ctx, int offset, String cname) {
        CodeEditor ce = ctx.getCodeEditor();
        JavaType type = TemplateJotUtils.getJavaType(cname, ce.getContext());
        ArrayList<HintChoice> res = new ArrayList<HintChoice>();
        ArrayList al = TemplateJotUtils.getCurrentMethodJotLocalVariables(ce, offset, type);
        int i = 0;
        while (i < al.size()) {
            Identifier id = (Identifier)al.get(i);
            res.add(new HintChoice(id.getName(), TemplateJotUtils.shortClassName(id.getType().getName()), 1));
            ++i;
        }
        al = TemplateJotUtils.getCurrentMethodJotParameters(ce, offset, type);
        int i2 = 0;
        while (i2 < al.size()) {
            Identifier id = (Identifier)al.get(i2);
            res.add(new HintChoice(id.getName(), TemplateJotUtils.shortClassName(id.getType().getName()), 2));
            ++i2;
        }
        al = TemplateJotUtils.getCurrentMethodJotFields(ce, offset, type);
        int i3 = 0;
        while (i3 < al.size()) {
            Identifier id = (Identifier)al.get(i3);
            res.add(new HintChoice(id.getName(), TemplateJotUtils.shortClassName(id.getType().getName()), 0));
            ++i3;
        }
        HintChoice[] result = new HintChoice[res.size()];
        result = res.toArray(result);
        return result;
    }

    public static String getTypeOf(TemplateContext ctx, int offset, String vname) {
        CodeEditor ce = ctx.getCodeEditor();
        ArrayList al = TemplateJotUtils.getCurrentJotIdentifierOfType(ce, offset, 7, null);
        int i = 0;
        while (i < al.size()) {
            Identifier id = (Identifier)al.get(i);
            if (vname.equals(id.getName())) {
                String res = id.getType().getComponentType().getName();
                int lastpoint = res.lastIndexOf(46);
                res = res.substring(lastpoint + 1);
                res = res.substring(res.lastIndexOf(36) + 1);
                return res;
            }
            ++i;
        }
        return "Object";
    }

    public static String getElementTypeOf(TemplateContext ctx, int offset, String vname) {
        CodeEditor ce = ctx.getCodeEditor();
        ArrayList al = TemplateJotUtils.getCurrentJotIdentifierOfType(ce, offset, 7, null);
        int i = 0;
        while (i < al.size()) {
            Identifier id = (Identifier)al.get(i);
            if (vname.equals(id.getName())) {
                String res = id.getType().getComponentType().getName();
                int lastpoint = res.lastIndexOf(46);
                if ((res = res.substring(lastpoint + 1)).endsWith("[]")) {
                    res = res.substring(0, res.length() - 2);
                }
                res = res.substring(res.lastIndexOf(36) + 1);
                return res;
            }
            ++i;
        }
        return "Object";
    }

    public static ArrayList getSmartContent(TemplateContext ctx, int offset, String varname, String[] mnames, int[] offsets) {
        CodeEditor ce = ctx.getCodeEditor();
        ArrayList lscl = TemplateJotUtils.getCurrentAssigns(ce, offset, varname, mnames, offsets);
        String[] strings = new String[lscl.size()];
        strings = lscl.toArray(strings);
        ArrayList commonClasses = null;
        int i = 0;
        while (i < strings.length) {
            ArrayList al = TemplateJotUtils.getJotClassesFromClass(strings[i], ce, 0);
            commonClasses = TemplateJotUtils.combineClassesList(commonClasses, al);
            ++i;
        }
        if (commonClasses == null) {
            commonClasses = new ArrayList();
            commonClasses.add("java.lang.Object");
        }
        return commonClasses;
    }

    static abstract class Identifier {
        abstract String getName();

        abstract JavaType getType();

        abstract int getModifiers();

        boolean isArray() {
            JavaType tpe = this.getType();
            if (tpe != null) {
                return tpe.isArray();
            }
            return false;
        }

        static boolean isAssignable(JavaType t, JavaType f) {
            if (f.equals((Object)t)) {
                return true;
            }
            return f.getHierarchy().contains(t);
        }

        boolean isOfType(JavaType type) {
            if (type == null) {
                return true;
            }
            JavaType jt = this.getType();
            if (jt == null) {
                return false;
            }
            return Identifier.isAssignable(type, jt);
        }

        private boolean isOfGenericType(JavaType ofclass, Context context) {
            JavaType resType = this.getType();
            if (resType == null) {
                return false;
            }
            if (!resType.hasTypeParameters()) {
                return false;
            }
            StringBuffer parameters = new StringBuffer("<");
            Collection args = this.getType().getActualTypeArguments();
            Iterator iterator = args.iterator();
            while (iterator.hasNext()) {
                JavaType aType = (JavaType)iterator.next();
                parameters.append(aType.getQualifiedName());
                if (iterator.hasNext()) {
                    parameters.append(",");
                    continue;
                }
                parameters.append(">");
            }
            JavaManager manager = JavaManager.getJavaManager((Project)context.getProject());
            JavaClass ofgeneric = manager.getClass(ofclass.getQualifiedName() + parameters.toString());
            if (ofgeneric == null) {
                return false;
            }
            return Identifier.isAssignable((JavaType)ofgeneric, resType);
        }

        Identifier() {
        }

        static boolean mav$isOfGenericType(Identifier identifier, JavaType javaType, Context context) {
            return identifier.isOfGenericType(javaType, context);
        }
    }

    static class VarIdentifier
    extends Identifier {
        private JavaVariable _var;

        public VarIdentifier(JavaVariable var) {
            this._var = var;
        }

        String getName() {
            return this._var.getName();
        }

        JavaType getType() {
            return this._var.getResolvedType();
        }

        int getModifiers() {
            return this._var.getModifiers();
        }
    }
}

